/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation.internals;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.RecordFilter;
import org.nuxeo.lib.stream.computation.RecordFilterChain;
import org.nuxeo.lib.stream.computation.internals.NoFilterChain;
import org.nuxeo.lib.stream.log.LogOffset;

public class RecordFilterChainImpl
implements RecordFilterChain {
    public static final RecordFilterChain NONE = new NoFilterChain();
    protected final Deque<RecordFilter> filters = new ArrayDeque<RecordFilter>();

    @Override
    public RecordFilterChain addFilter(RecordFilter filter) {
        Objects.requireNonNull(filter);
        this.filters.add(filter);
        return this;
    }

    @Override
    public Record beforeAppend(Record record) {
        Iterator<RecordFilter> iterator = this.filters.iterator();
        while (record != null && iterator.hasNext()) {
            RecordFilter filter = iterator.next();
            record = filter.beforeAppend(record);
        }
        return record;
    }

    @Override
    public void afterAppend(Record record, LogOffset offset) {
        Iterator<RecordFilter> iterator = this.filters.iterator();
        while (record != null && iterator.hasNext()) {
            RecordFilter filter = iterator.next();
            filter.afterAppend(record, offset);
        }
    }

    @Override
    public Record afterRead(Record record, LogOffset offset) {
        Iterator<RecordFilter> iterator = this.filters.descendingIterator();
        while (record != null && iterator.hasNext()) {
            RecordFilter filter = iterator.next();
            record = filter.afterRead(record, offset);
        }
        return record;
    }
}

