/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log;

import java.util.Objects;
import java.util.regex.Pattern;

public class Name {
    public static final String NAMESPACE_GLOBAL = "_GLOBAL_";
    public static final String NAMESPACE_URN_SEP = "/";
    public static final String NAMESPACE_ID_SEP = "-";
    protected static final Pattern VALID_NAMESPACE_PATTERN = Pattern.compile("[A-Za-z][A-Za-z0-9_]*");
    protected static final Pattern VALID_LOG_NAME_PATTERN = Pattern.compile("[A-Za-z0-9][A-Za-z0-9_\\-]*");
    protected static final Pattern VALID_LOG_NAME_WITHOUT_NS_PATTERN = Pattern.compile("[A-Za-z0-9][A-Za-z0-9_]*");
    protected final String namespace;
    protected final String name;
    protected final String id;
    protected final String urn;

    private Name(String namespace, String name) {
        Name.checkNameSpace(namespace);
        this.namespace = namespace;
        this.name = name;
        if (NAMESPACE_GLOBAL.equals(namespace)) {
            Name.checkLogNameWithoutNamespace(name);
            this.id = name;
            this.urn = name;
        } else {
            Name.checkLogName(name);
            this.id = namespace + NAMESPACE_ID_SEP + name;
            this.urn = namespace + NAMESPACE_URN_SEP + name;
        }
    }

    public static Name of(String namespace, String name) {
        return new Name(namespace, name);
    }

    public static Name ofUrn(String urn) {
        Objects.requireNonNull(urn, "Null URN");
        int pos = urn.indexOf(NAMESPACE_URN_SEP);
        if (pos < 0) {
            return new Name(NAMESPACE_GLOBAL, urn);
        }
        return new Name(urn.substring(0, pos), urn.substring(pos + 1));
    }

    public static Name ofId(String id) {
        Objects.requireNonNull(id, "Null id");
        int pos = id.indexOf(NAMESPACE_ID_SEP);
        if (pos < 0) {
            return new Name(NAMESPACE_GLOBAL, id);
        }
        return new Name(id.substring(0, pos), id.substring(pos + 1));
    }

    public static String idOfUrn(String urn) {
        return Name.ofUrn(urn).getId();
    }

    public static String urnOfId(String id) {
        return Name.ofId(id).getUrn();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getUrn() {
        return this.urn;
    }

    public String toString() {
        return "Name{namespace='" + this.namespace + "', name='" + this.name + "', id='" + this.id + "', urn='" + this.urn + "'}";
    }

    protected static void checkLogName(String name) {
        if (!VALID_LOG_NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid name: '" + name + "'.");
        }
    }

    protected static void checkLogNameWithoutNamespace(String name) {
        if (!VALID_LOG_NAME_WITHOUT_NS_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid name without namespace: '" + name + "'");
        }
    }

    protected static void checkNameSpace(String name) {
        if (!VALID_NAMESPACE_PATTERN.matcher(name).matches() & !NAMESPACE_GLOBAL.equals(name)) {
            throw new IllegalArgumentException("Invalid namespace: '" + name + "'");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Name name = (Name)o;
        return Objects.equals(this.urn, name.urn);
    }

    public int hashCode() {
        return Objects.hash(this.urn);
    }
}

