/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.log.LogLag;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.tools.command.Command;

public class LagCommand
extends Command {
    private static final Log log = LogFactory.getLog(LagCommand.class);
    protected static final String NAME = "lag";
    protected boolean verbose = false;

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void updateOptions(Options options) {
        options.addOption(Option.builder((String)"l").longOpt("log-name").desc("Log name").hasArg().argName("LOG_NAME").build());
        options.addOption(Option.builder().longOpt("verbose").desc("Display lag for each partition").build());
    }

    @Override
    public boolean run(LogManager manager, CommandLine cmd) {
        String logName = cmd.getOptionValue("log-name");
        this.verbose = cmd.hasOption("verbose");
        if (logName != null) {
            this.lag(manager, Name.ofUrn(logName));
        } else {
            this.lag(manager);
        }
        return true;
    }

    protected void lag(LogManager manager) {
        log.info((Object)("# " + manager));
        for (Name name : manager.listAllNames()) {
            this.lag(manager, name);
        }
    }

    protected void lag(LogManager manager, Name name) {
        log.info((Object)("## Log: " + name + " partitions: " + manager.size(name)));
        List<Name> consumers = manager.listConsumerGroups(name);
        if (this.verbose && consumers.isEmpty()) {
            consumers.add(Name.ofUrn("admin/tools"));
        }
        consumers.forEach(group -> this.renderLag((Name)group, manager.getLagPerPartition(name, (Name)group)));
    }

    protected void renderLag(Name group, List<LogLag> lags) {
        log.info((Object)("### Group: " + group));
        log.info((Object)"| partition | lag | pos | end | posOffset |\u00a0endOffset\u00a0|\n| --- | ---: | ---: | ---: | ---: | ---: |");
        LogLag all = LogLag.of(lags);
        log.info((Object)String.format("|All|%d|%d|%d|%d|%d|", all.lag(), all.lower(), all.upper(), all.lowerOffset(), all.upperOffset()));
        if (this.verbose && lags.size() > 1) {
            AtomicInteger i = new AtomicInteger();
            lags.forEach(lag -> log.info((Object)String.format("|%s|%d|%d|%d|%d|%d|", i.getAndIncrement(), lag.lag(), lag.lower(), lag.upper(), lag.lowerOffset(), lag.upperOffset())));
        }
    }
}

