/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log;

import java.io.Externalizable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.codec.NoCodec;
import org.nuxeo.lib.stream.log.Latency;
import org.nuxeo.lib.stream.log.LogAppender;
import org.nuxeo.lib.stream.log.LogLag;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.log.RebalanceListener;

public interface LogManager
extends AutoCloseable {
    public boolean exists(Name var1);

    @Deprecated(since="11.1")
    default public boolean exists(String name) {
        return this.exists(Name.ofUrn(name));
    }

    public boolean createIfNotExists(Name var1, int var2);

    @Deprecated(since="11.1")
    default public boolean createIfNotExists(String name, int size) {
        return this.createIfNotExists(Name.ofUrn(name), size);
    }

    public boolean delete(Name var1);

    @Deprecated(since="11.1")
    default public boolean delete(String name) {
        return this.delete(Name.ofUrn(name));
    }

    public int size(Name var1);

    @Deprecated(since="11.1")
    default public int size(String name) {
        return this.size(Name.ofUrn(name));
    }

    public <M extends Externalizable> LogAppender<M> getAppender(Name var1, Codec<M> var2);

    @Deprecated(since="11.1")
    default public <M extends Externalizable> LogAppender<M> getAppender(String name, Codec<M> codec) {
        return this.getAppender(Name.ofUrn(name), codec);
    }

    default public <M extends Externalizable> LogAppender<M> getAppender(Name name) {
        return this.getAppender(name, NoCodec.NO_CODEC);
    }

    @Deprecated(since="11.1")
    default public <M extends Externalizable> LogAppender<M> getAppender(String name) {
        return this.getAppender(name, NoCodec.NO_CODEC);
    }

    public <M extends Externalizable> LogTailer<M> createTailer(Name var1, Collection<LogPartition> var2, Codec<M> var3);

    @Deprecated(since="11.1")
    default public <M extends Externalizable> LogTailer<M> createTailer(String group, Collection<LogPartition> partitions, Codec<M> codec) {
        return this.createTailer(Name.ofUrn(group), partitions, codec);
    }

    default public <M extends Externalizable> LogTailer<M> createTailer(Name group, Collection<LogPartition> partitions) {
        return this.createTailer(group, partitions, NoCodec.NO_CODEC);
    }

    @Deprecated(since="11.1")
    default public <M extends Externalizable> LogTailer<M> createTailer(String group, Collection<LogPartition> partitions) {
        return this.createTailer(Name.ofUrn(group), partitions);
    }

    default public <M extends Externalizable> LogTailer<M> createTailer(Name group, LogPartition partition) {
        return this.createTailer(group, partition, NoCodec.NO_CODEC);
    }

    @Deprecated(since="11.1")
    default public <M extends Externalizable> LogTailer<M> createTailer(String group, LogPartition partition) {
        return this.createTailer(Name.ofUrn(group), partition);
    }

    default public <M extends Externalizable> LogTailer<M> createTailer(Name group, Name name) {
        return this.createTailer(group, name, NoCodec.NO_CODEC);
    }

    @Deprecated(since="11.1")
    default public <M extends Externalizable> LogTailer<M> createTailer(String group, String name) {
        return this.createTailer(Name.ofUrn(group), Name.ofUrn(name));
    }

    default public <M extends Externalizable> LogTailer<M> createTailer(Name group, LogPartition partition, Codec<M> codec) {
        return this.createTailer(group, Collections.singletonList(partition), codec);
    }

    @Deprecated(since="11.1")
    default public <M extends Externalizable> LogTailer<M> createTailer(String group, LogPartition partition, Codec<M> codec) {
        return this.createTailer(Name.ofUrn(group), Collections.singletonList(partition), codec);
    }

    default public <M extends Externalizable> LogTailer<M> createTailer(Name group, Name name, Codec<M> codec) {
        int partitions = this.size(name);
        if (partitions <= 0) {
            throw new IllegalArgumentException("Log name: " + name + " not found");
        }
        return this.createTailer(group, (Collection<LogPartition>)IntStream.range(0, partitions).boxed().map(partition -> new LogPartition(name, (int)partition)).collect(Collectors.toList()), codec);
    }

    @Deprecated(since="11.1")
    default public <M extends Externalizable> LogTailer<M> createTailer(String group, String name, Codec<M> codec) {
        return this.createTailer(Name.ofUrn(group), Name.ofUrn(name), codec);
    }

    public boolean supportSubscribe();

    public <M extends Externalizable> LogTailer<M> subscribe(Name var1, Collection<Name> var2, RebalanceListener var3, Codec<M> var4);

    @Deprecated(since="11.1")
    default public <M extends Externalizable> LogTailer<M> subscribe(String group, Collection<String> names, RebalanceListener listener, Codec<M> codec) {
        return this.subscribe(Name.ofUrn(group), names.stream().map(Name::ofUrn).collect(Collectors.toList()), listener, codec);
    }

    default public <M extends Externalizable> LogTailer<M> subscribe(Name group, Collection<Name> names, RebalanceListener listener) {
        return this.subscribe(group, names, listener, NoCodec.NO_CODEC);
    }

    @Deprecated(since="11.1")
    default public <M extends Externalizable> LogTailer<M> subscribe(String group, Collection<String> names, RebalanceListener listener) {
        return this.subscribe(group, names, listener, NoCodec.NO_CODEC);
    }

    public List<LogLag> getLagPerPartition(Name var1, Name var2);

    @Deprecated(since="11.1")
    default public List<LogLag> getLagPerPartition(String name, String group) {
        return this.getLagPerPartition(Name.ofUrn(name), Name.ofUrn(group));
    }

    default public LogLag getLag(Name name, Name group) {
        return LogLag.of(this.getLagPerPartition(name, group));
    }

    @Deprecated(since="11.1")
    default public LogLag getLag(String name, String group) {
        return this.getLag(Name.ofUrn(name), Name.ofUrn(group));
    }

    public <M extends Externalizable> List<Latency> getLatencyPerPartition(Name var1, Name var2, Codec<M> var3, Function<M, Long> var4, Function<M, String> var5);

    @Deprecated(since="11.1")
    default public <M extends Externalizable> List<Latency> getLatencyPerPartition(String name, String group, Codec<M> codec, Function<M, Long> timestampExtractor, Function<M, String> keyExtractor) {
        return this.getLatencyPerPartition(Name.ofUrn(name), Name.ofUrn(group), codec, timestampExtractor, keyExtractor);
    }

    default public <M extends Externalizable> Latency getLatency(Name name, Name group, Codec<M> codec, Function<M, Long> timestampExtractor, Function<M, String> keyExtractor) {
        return Latency.of(this.getLatencyPerPartition(name, group, codec, timestampExtractor, keyExtractor));
    }

    @Deprecated(since="11.1")
    default public <M extends Externalizable> Latency getLatency(String name, String group, Codec<M> codec, Function<M, Long> timestampExtractor, Function<M, String> keyExtractor) {
        return Latency.of(this.getLatencyPerPartition(name, group, codec, timestampExtractor, keyExtractor));
    }

    @Deprecated(since="11.1")
    default public List<String> listAll() {
        return this.listAllNames().stream().map(Name::getUrn).collect(Collectors.toList());
    }

    public List<Name> listAllNames();

    public List<Name> listConsumerGroups(Name var1);

    @Deprecated(since="11.1")
    default public List<String> listConsumerGroups(String name) {
        return this.listConsumerGroups(Name.ofUrn(name)).stream().map(Name::getUrn).collect(Collectors.toList());
    }

    @Override
    public void close();
}

