/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.chronicle;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.log.chronicle.ChronicleRetentionDuration;
import org.nuxeo.lib.stream.log.chronicle.ChronicleRetentionListener;

public class ChronicleLogOffsetTracker
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(ChronicleLogOffsetTracker.class);
    protected static final String OFFSET_QUEUE_PREFIX = "offset-";
    public static final int CQ_BLOCK_SIZE = 0x100000;
    protected final SingleChronicleQueue offsetQueue;
    protected final int partition;
    protected long lastCommittedOffset;
    protected final ChronicleRetentionDuration retention;

    public ChronicleLogOffsetTracker(String basePath, int partition, Name group, ChronicleRetentionDuration retention) {
        this.partition = partition;
        this.retention = retention;
        File offsetFile = new File(basePath, OFFSET_QUEUE_PREFIX + group.getId());
        ChronicleRetentionListener listener = null;
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.binary((File)offsetFile).rollCycle(retention.getRollCycle()).blockSize(0x100000);
        if (!retention.disable() && partition == 0) {
            listener = new ChronicleRetentionListener(retention);
            builder.storeFileListener((StoreFileListener)listener);
        }
        this.offsetQueue = builder.build();
        if (listener != null) {
            listener.setQueue(this.offsetQueue);
        }
    }

    public static boolean exists(Path basePath, Name group) {
        boolean bl;
        block8: {
            Stream<Path> paths = Files.list(basePath.resolve(OFFSET_QUEUE_PREFIX + group.getId()));
            try {
                boolean bl2 = bl = paths.count() > 0L;
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            paths.close();
        }
        return bl;
    }

    public static boolean isOffsetTracker(String dirName) {
        return dirName.startsWith(OFFSET_QUEUE_PREFIX);
    }

    public static String getGroupFromDirectory(String dirName) {
        if (!ChronicleLogOffsetTracker.isOffsetTracker(dirName)) {
            throw new IllegalArgumentException(String.format("Invalid directory %s, not an offset tracker", dirName));
        }
        return dirName.replaceFirst(OFFSET_QUEUE_PREFIX, "");
    }

    public long getLastCommittedOffset() {
        if (this.lastCommittedOffset > 0L) {
            return this.lastCommittedOffset;
        }
        return this.readLastCommittedOffset();
    }

    public long readLastCommittedOffset() {
        try {
            return this.doReadLastCommittedOffset();
        }
        catch (IllegalStateException e) {
            log.warn((Object)String.format("Fail to reach the end of offset queue: %s because of: %s, retrying.", this.offsetQueue.file().getAbsolutePath(), e.getMessage()));
            return this.doReadLastCommittedOffset();
        }
    }

    protected long doReadLastCommittedOffset() {
        try (ExcerptTailer offsetTailer = this.offsetQueue.createTailer().direction(TailerDirection.BACKWARD).toEnd();){
            boolean hasNext;
            switch (offsetTailer.state()) {
                case FOUND_CYCLE: {
                    break;
                }
                case UNINITIALISED: {
                    long l = 0L;
                    return l;
                }
                default: {
                    log.info((Object)("Invalid offset tailer state: " + this.offsetQueue.file().getAbsolutePath() + ": " + offsetTailer.state() + " taken as uninitialized"));
                    long l = 0L;
                    return l;
                }
            }
            long[] offset = new long[]{0L};
            do {
                hasNext = offsetTailer.readBytes(b -> {
                    int queue = b.readInt();
                    long off = b.readLong();
                    b.readLong();
                    if (this.partition == queue) {
                        offset[0] = off;
                    }
                });
            } while (offset[0] == 0L && hasNext);
            long l = offset[0];
            return l;
        }
    }

    public void commit(long offset) {
        ExcerptAppender appender = this.offsetQueue.acquireAppender();
        appender.writeBytes(b -> b.writeInt(this.partition).writeLong(offset).writeLong(System.currentTimeMillis()));
        this.lastCommittedOffset = offset;
    }

    @Override
    public void close() {
        if (!this.offsetQueue.isClosed()) {
            this.offsetQueue.close();
        }
    }
}

