/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.codec.NoCodec;
import org.nuxeo.lib.stream.computation.ComputationPolicy;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.RecordFilter;
import org.nuxeo.lib.stream.computation.RecordFilterChain;
import org.nuxeo.lib.stream.computation.internals.RecordFilterChainImpl;
import org.nuxeo.lib.stream.log.Name;

public class Settings {
    protected final int defaultPartitions;
    protected final Map<Name, Integer> partitions = new HashMap<Name, Integer>();
    protected final Codec<Record> defaultCodec;
    protected final Map<Name, Codec<Record>> codecs = new HashMap<Name, Codec<Record>>();
    protected final RecordFilterChain defaultFilter;
    protected final Map<Name, RecordFilterChain> filters = new HashMap<Name, RecordFilterChain>();
    protected final Map<Name, Boolean> externals = new HashMap<Name, Boolean>();
    protected final boolean defaultExternal;
    protected final int defaultConcurrency;
    protected final Map<Name, Integer> concurrencies = new HashMap<Name, Integer>();
    protected final ComputationPolicy defaultPolicy;
    protected final Map<Name, ComputationPolicy> policies = new HashMap<Name, ComputationPolicy>();

    public Settings(int defaultConcurrency, int defaultPartitions) {
        this(defaultConcurrency, defaultPartitions, null, null, null);
    }

    public Settings(int defaultConcurrency, int defaultPartitions, Codec<Record> defaultCodec) {
        this(defaultConcurrency, defaultPartitions, defaultCodec, null, null);
    }

    public Settings(int defaultConcurrency, int defaultPartitions, ComputationPolicy defaultPolicy) {
        this(defaultConcurrency, defaultPartitions, null, defaultPolicy, null);
    }

    public Settings(int defaultConcurrency, int defaultPartitions, Codec<Record> defaultCodec, ComputationPolicy defaultPolicy) {
        this(defaultConcurrency, defaultPartitions, defaultCodec, defaultPolicy, null);
    }

    public Settings(int defaultConcurrency, int defaultPartitions, Codec<Record> defaultCodec, ComputationPolicy defaultPolicy, RecordFilterChain defaultFilter) {
        this(defaultConcurrency, defaultPartitions, defaultCodec, defaultPolicy, defaultFilter, false);
    }

    public Settings(int defaultConcurrency, int defaultPartitions, Codec<Record> defaultCodec, ComputationPolicy defaultPolicy, RecordFilterChain defaultFilter, boolean defaultExternal) {
        this.defaultConcurrency = defaultConcurrency;
        this.defaultPartitions = defaultPartitions;
        this.defaultCodec = defaultCodec == null ? NoCodec.NO_CODEC : defaultCodec;
        this.defaultPolicy = defaultPolicy == null ? ComputationPolicy.NONE : defaultPolicy;
        this.defaultFilter = defaultFilter == null ? RecordFilterChainImpl.NONE : defaultFilter;
        this.defaultExternal = defaultExternal;
    }

    public Settings setConcurrency(String computationName, int concurrency) {
        return this.setConcurrency(Name.ofUrn(computationName), concurrency);
    }

    public Settings setConcurrency(Name computationName, int concurrency) {
        this.concurrencies.put(computationName, concurrency);
        return this;
    }

    public int getConcurrency(String computationName) {
        return this.getConcurrency(Name.ofUrn(computationName));
    }

    public int getConcurrency(Name computationName) {
        return this.concurrencies.getOrDefault(computationName, this.defaultConcurrency);
    }

    public Settings setPartitions(Name streamName, int partitions) {
        this.partitions.put(streamName, partitions);
        return this;
    }

    public Settings setPartitions(String streamName, int partitions) {
        return this.setPartitions(Name.ofUrn(streamName), partitions);
    }

    public int getPartitions(Name streamName) {
        return this.partitions.getOrDefault(streamName, this.defaultPartitions);
    }

    public int getPartitions(String streamName) {
        return this.getPartitions(Name.ofUrn(streamName));
    }

    public Settings setExternal(Name streamName, boolean external) {
        this.externals.put(streamName, external);
        return this;
    }

    public boolean isExternal(Name streamName) {
        return this.externals.getOrDefault(streamName, this.defaultExternal);
    }

    public Settings setCodec(Name streamName, Codec<Record> codec) {
        Objects.requireNonNull(codec);
        this.codecs.put(streamName, codec);
        return this;
    }

    public Settings setCodec(String streamName, Codec<Record> codec) {
        return this.setCodec(Name.ofUrn(streamName), codec);
    }

    public Codec<Record> getCodec(String streamName) {
        return this.getCodec(Name.ofUrn(streamName));
    }

    public Codec<Record> getCodec(Name streamName) {
        return this.codecs.getOrDefault(streamName, this.defaultCodec);
    }

    public Settings setPolicy(Name computationName, ComputationPolicy policy) {
        if (policy == null) {
            this.policies.remove(computationName);
        } else {
            this.policies.put(computationName, policy);
        }
        return this;
    }

    public Settings setPolicy(String computationName, ComputationPolicy policy) {
        return this.setPolicy(Name.ofUrn(computationName), policy);
    }

    public ComputationPolicy getPolicy(Name computationName) {
        return this.policies.getOrDefault(computationName, this.defaultPolicy);
    }

    public ComputationPolicy getPolicy(String computationName) {
        return this.policies.getOrDefault(Name.ofUrn(computationName), this.defaultPolicy);
    }

    public Settings addFilter(Name streamName, RecordFilter filter) {
        if (filter == null) {
            this.filters.remove(streamName);
        } else {
            RecordFilterChain chain = this.filters.computeIfAbsent(streamName, k -> new RecordFilterChainImpl());
            chain.addFilter(filter);
        }
        return this;
    }

    public Settings addFilter(String streamName, RecordFilter filter) {
        return this.addFilter(Name.ofUrn(streamName), filter);
    }

    public RecordFilterChain getFilterChain(Name streamName) {
        return this.filters.getOrDefault(streamName, this.defaultFilter);
    }

    public RecordFilterChain getFilterChain(String streamName) {
        return this.filters.getOrDefault(Name.ofUrn(streamName), this.defaultFilter);
    }
}

