/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.computation.Computation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.ComputationMetadata;

public abstract class AbstractComputation
implements Computation {
    private static final Log log = LogFactory.getLog(AbstractComputation.class);
    protected final ComputationMetadata metadata;
    public static final String INPUT_1 = "i1";
    public static final String INPUT_2 = "i2";
    public static final String INPUT_3 = "i3";
    public static final String OUTPUT_1 = "o1";
    public static final String OUTPUT_2 = "o2";
    public static final String OUTPUT_3 = "o3";
    public static final String OUTPUT_4 = "o4";
    public static final String INPUT_NULL = "input/null";

    public AbstractComputation(String name, int nbInputStreams, int nbOutputStreams) {
        this.metadata = new ComputationMetadata(name, IntStream.range(1, nbInputStreams + 1).boxed().map(i -> "i" + i).collect(Collectors.toSet()), IntStream.range(1, nbOutputStreams + 1).boxed().map(i -> "o" + i).collect(Collectors.toSet()));
    }

    @Override
    public void init(ComputationContext context) {
    }

    @Override
    public void processTimer(ComputationContext context, String key, long timestamp) {
    }

    @Override
    public ComputationMetadata metadata() {
        return this.metadata;
    }

    @Override
    public void processRetry(ComputationContext context, Throwable failure) {
        log.warn((Object)String.format("Computation: %s fails last record: %s, retrying ...", this.metadata.name(), context.getLastOffset()), failure);
    }

    @Override
    public void processFailure(ComputationContext context, Throwable failure) {
        log.error((Object)String.format("Computation: %s fails last record: %s, after retries.", this.metadata.name(), context.getLastOffset()), failure);
    }
}

