/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log;

import org.nuxeo.lib.stream.log.Name;

public class NameResolver {
    protected final String prefix;
    protected final int prefixLen;

    public NameResolver(String prefix) {
        this.prefix = prefix != null ? prefix : "";
        this.prefixLen = this.prefix.length();
    }

    public String getId(Name name) {
        return this.prefix + name.getId();
    }

    public Name getName(String id) {
        if (!id.startsWith(this.prefix)) {
            throw new IllegalArgumentException(String.format("invalid id: %s must starts with prefix %s", id, this.prefix));
        }
        return Name.ofId(id.substring(this.prefixLen));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String toString() {
        return "NameResolver{prefix='" + this.prefix + "'}";
    }
}

