/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.kafka;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.nuxeo.lib.stream.log.AbstractLogConfig;
import org.nuxeo.lib.stream.log.NameResolver;

public class KafkaLogConfig
extends AbstractLogConfig {
    public static final String DISABLE_SUBSCRIBE_PROP = "subscribe.disable";
    public static final String DEFAULT_REPLICATION_FACTOR_PROP = "default.replication.factor";
    protected final Properties adminProperties;
    protected final Properties producerProperties;
    protected final Properties consumerProperties;
    protected final short defaultReplicationFactor;
    protected final Boolean disableSubscribe;
    protected final NameResolver resolver;
    protected final String name;

    public KafkaLogConfig(String name, boolean defaultConfig, List<String> patterns, String prefix, Properties adminProperties, Properties producerProperties, Properties consumerProperties) {
        super(defaultConfig, patterns);
        this.name = name;
        this.resolver = new NameResolver(prefix);
        this.producerProperties = this.normalizeProducerProperties(producerProperties);
        this.consumerProperties = this.normalizeConsumerProperties(consumerProperties);
        this.adminProperties = adminProperties == null || adminProperties.isEmpty() ? this.createAdminProperties(this.producerProperties) : this.normalizeAdminProperties(adminProperties);
        this.disableSubscribe = Boolean.valueOf(consumerProperties.getProperty(DISABLE_SUBSCRIBE_PROP, "false"));
        this.defaultReplicationFactor = Short.parseShort(producerProperties.getProperty(DEFAULT_REPLICATION_FACTOR_PROP, "1"));
    }

    public short getReplicatorFactor() {
        return this.defaultReplicationFactor;
    }

    public Boolean getDisableSubscribe() {
        return this.disableSubscribe;
    }

    public NameResolver getResolver() {
        return this.resolver;
    }

    public Properties getAdminProperties() {
        return this.adminProperties;
    }

    public Properties getProducerProperties() {
        return this.producerProperties;
    }

    public Properties getConsumerProperties() {
        return this.consumerProperties;
    }

    protected Properties normalizeAdminProperties(Properties adminProperties) {
        return (Properties)adminProperties.clone();
    }

    protected Properties normalizeProducerProperties(Properties producerProperties) {
        Properties ret = producerProperties != null ? (Properties)producerProperties.clone() : new Properties();
        try {
            ret.put("key.serializer", Class.forName("org.apache.kafka.common.serialization.StringSerializer"));
            ret.put("value.serializer", Class.forName("org.apache.kafka.common.serialization.BytesSerializer"));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        ret.remove(DEFAULT_REPLICATION_FACTOR_PROP);
        return ret;
    }

    protected Properties normalizeConsumerProperties(Properties consumerProperties) {
        Properties ret = consumerProperties != null ? (Properties)consumerProperties.clone() : new Properties();
        try {
            ret.put("key.deserializer", Class.forName("org.apache.kafka.common.serialization.StringDeserializer"));
            ret.put("value.deserializer", Class.forName("org.apache.kafka.common.serialization.BytesDeserializer"));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        ret.put("enable.auto.commit", (Object)false);
        ret.put("auto.offset.reset", "earliest");
        ret.remove(DISABLE_SUBSCRIBE_PROP);
        return ret;
    }

    protected Properties createAdminProperties(Properties producerProperties) {
        Properties ret = new Properties();
        block15: for (Map.Entry<Object, Object> prop : producerProperties.entrySet()) {
            switch (prop.getKey().toString()) {
                case "acks": 
                case "batch.size": 
                case "buffer.memory": 
                case "compression.type": 
                case "key.serializer": 
                case "linger.ms": 
                case "max.block.ms": 
                case "value.serializer": 
                case "delivery.timeout.ms": 
                case "default.replication.factor": {
                    continue block15;
                }
            }
            ret.put(prop.getKey(), prop.getValue());
        }
        return ret;
    }

    public String toString() {
        return "KafkaLogConfig{name='" + this.name + "', resolver='" + this.resolver + "', adminProperties=" + this.filterDisplayedProperties(this.adminProperties) + ", producerProperties=" + this.filterDisplayedProperties(this.producerProperties) + ", consumerProperties=" + this.filterDisplayedProperties(this.consumerProperties) + ", defaultReplicationFactor=" + this.defaultReplicationFactor + ", disableSubscribe=" + this.disableSubscribe + "}";
    }

    protected String filterDisplayedProperties(Properties properties) {
        String ret = properties.toString();
        if (!ret.contains("password")) {
            return ret;
        }
        return ret.replaceAll("password=.[^\\\"\\;\\,\\ ]*", "password=****");
    }
}

