/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.LogRecord;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.tools.command.Command;

public class WorkCatCommand
extends Command {
    private static final Log log = LogFactory.getLog(WorkCatCommand.class);
    protected static final String NAME = "workCat";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void updateOptions(Options options) {
        options.addOption(Option.builder((String)"n").desc("Limit to the first N Works").hasArg().argName("N").build());
        options.addOption(Option.builder((String)"l").longOpt("log-name").desc("Work Queue Log name").required().hasArg().argName("LOG_NAME").build());
        options.addOption(Option.builder().longOpt("codec").desc("Codec used to read record, can be: java, avro, avroBinary, avroJson").hasArg().argName("CODEC").build());
    }

    @Override
    public boolean run(LogManager manager, CommandLine cmd) throws InterruptedException {
        int limit = Integer.parseInt(cmd.getOptionValue("n", "-1"));
        Name name = Name.ofUrn(cmd.getOptionValue("log-name"));
        Name group = Name.ofUrn(cmd.getOptionValue("group", "admin/tools"));
        String codec = cmd.getOptionValue("codec");
        this.workStat(manager, name, group, limit, codec);
        return true;
    }

    protected void workStat(LogManager manager, Name name, Name group, int limit, String codec) throws InterruptedException {
        try (LogTailer<Record> tailer = manager.createTailer(group, name, this.getRecordCodec(codec));){
            int count = 0;
            log.info((Object)"pos,class,fullname,category,name");
            do {
                LogRecord<Record> record;
                if ((record = tailer.read(Duration.ofMillis(1000L))) == null) {
                    break;
                }
                log.info((Object)(record.offset().toString() + "," + WorkCatCommand.deserialize(record.message().getData())));
            } while (limit < 0 || ++count < limit);
        }
    }

    public static String deserialize(byte[] data) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ObjectInputStream in = null;
        Object ret = "";
        try {
            in = new ObjectInputStream(bis);
            Object work = in.readObject();
            String clazz = work.getClass().getSimpleName();
            ret = (String)ret + clazz;
            ret = (String)ret + "," + work.getClass().getCanonicalName();
            Method getCategory = work.getClass().getMethod("getCategory", new Class[0]);
            String category = (String)getCategory.invoke(work, new Object[0]);
            ret = (String)ret + "," + category;
            Object object = ret = (String)ret + "," + work.toString().replace(",", ".");
            return object;
        }
        catch (IOException | ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

