/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.coldstorage.helpers;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobStatus;
import org.nuxeo.ecm.core.blob.BlobUpdateContext;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.runtime.api.Framework;

public class ColdStorageHelper {
    private static final Logger log = LogManager.getLogger(ColdStorageHelper.class);
    public static final String COLD_STORAGE_FACET_NAME = "ColdStorage";
    public static final String FILE_CONTENT_PROPERTY = "file:content";
    public static final String COLD_STORAGE_CONTENT_PROPERTY = "coldstorage:coldContent";
    public static final String COLD_STORAGE_BEING_RETRIEVED_PROPERTY = "coldstorage:beingRetrieved";
    public static final String GET_DOCUMENTS_TO_CHECK_QUERY = String.format("SELECT * FROM Document, Relation WHERE %s = 1", "coldstorage:beingRetrieved");
    public static final String COLD_STORAGE_CONTENT_AVAILABLE_EVENT_NAME = "coldStorageContentAvailable";
    public static final String COLD_STORAGE_CONTENT_AVAILABLE_UNTIL_MAIL_TEMPLATE_KEY = "coldStorageAvailableUntil";
    public static final String COLD_STORAGE_CONTENT_AVAILABLE_NOTIFICATION_NAME = "ColdStorageContentAvailable";
    public static final String COLD_STORAGE_CONTENT_ARCHIVE_LOCATION_MAIL_TEMPLATE_KEY = "archiveLocation";

    public static DocumentModel moveContentToColdStorage(CoreSession session, DocumentRef documentRef) {
        DocumentModel documentModel = session.getDocument(documentRef);
        log.debug("Move to cold storage the main content of document: {}", (Object)documentModel);
        if (!session.hasPermission(documentRef, "WriteColdStorage")) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((CoreSession)session).getPrincipal();
            supplierArray[1] = () -> documentModel;
            log.debug("The user {} does not have the right permissions to move the content of document {}", supplierArray);
            throw new NuxeoException(String.format("The document: %s cannot be moved to cold storage", documentRef), 403);
        }
        if (documentModel.hasFacet(COLD_STORAGE_FACET_NAME) && documentModel.getPropertyValue(COLD_STORAGE_CONTENT_PROPERTY) != null) {
            throw new NuxeoException(String.format("The main content for document: %s is already in cold storage.", documentModel), 409);
        }
        Serializable mainContent = documentModel.getPropertyValue(FILE_CONTENT_PROPERTY);
        if (mainContent == null) {
            throw new NuxeoException(String.format("There is no main content for document: %s.", documentModel), 404);
        }
        documentModel.addFacet(COLD_STORAGE_FACET_NAME);
        documentModel.setPropertyValue(COLD_STORAGE_CONTENT_PROPERTY, mainContent);
        documentModel.setPropertyValue(FILE_CONTENT_PROPERTY, null);
        return documentModel;
    }

    public static DocumentModel requestRetrievalFromColdStorage(CoreSession session, DocumentRef documentRef, Duration restoreDuration) {
        Objects.requireNonNull(restoreDuration, "Restore duration is required");
        DocumentModel documentModel = session.getDocument(documentRef);
        log.debug("Retrieve from cold storage the content of document: {} for a duration: {}", (Object)documentModel, (Object)restoreDuration);
        if (!documentModel.hasFacet(COLD_STORAGE_FACET_NAME) || documentModel.getPropertyValue(COLD_STORAGE_CONTENT_PROPERTY) == null) {
            throw new NuxeoException(String.format("No cold storage content defined for document: %s.", documentModel), 404);
        }
        Serializable beingRetrieved = documentModel.getPropertyValue(COLD_STORAGE_BEING_RETRIEVED_PROPERTY);
        if (Boolean.TRUE.equals(beingRetrieved)) {
            throw new NuxeoException(String.format("The cold storage content associated with the document: %s is being retrieved.", documentModel), 403);
        }
        try {
            Blob coldContent = (Blob)documentModel.getPropertyValue(COLD_STORAGE_CONTENT_PROPERTY);
            String key = ColdStorageHelper.getContentBlobKey(coldContent);
            BlobUpdateContext updateContext = new BlobUpdateContext(key).withRestoreForDuration(restoreDuration);
            ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(coldContent).updateBlob(updateContext);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        documentModel.setPropertyValue(COLD_STORAGE_BEING_RETRIEVED_PROPERTY, (Serializable)Boolean.valueOf(true));
        return documentModel;
    }

    public static ColdStorageContentStatus checkColdStorageContentAvailability(CoreSession session) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> ((CoreSession)session).getRepositoryName();
        log.debug("Start checking the available cold storage content for repository: {}", supplierArray);
        DocumentModelList documents = session.query(GET_DOCUMENTS_TO_CHECK_QUERY);
        int beingRetrieved = documents.size();
        int available = 0;
        EventService eventService = (EventService)Framework.getService(EventService.class);
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        for (DocumentModel doc : documents) {
            BlobStatus blobStatus;
            Blob coldContent = (Blob)doc.getPropertyValue(COLD_STORAGE_CONTENT_PROPERTY);
            try {
                blobStatus = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(coldContent).getStatus((ManagedBlob)coldContent);
            }
            catch (IOException e) {
                log.error("Unable to get the cold storage blob status for document: {}", (Object)doc, (Object)e);
                continue;
            }
            if (!blobStatus.isDownloadable()) continue;
            ++available;
            --beingRetrieved;
            doc.setPropertyValue(COLD_STORAGE_BEING_RETRIEVED_PROPERTY, (Serializable)Boolean.valueOf(false));
            session.saveDocument(doc);
            DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), doc);
            Instant downloadableUntil = blobStatus.getDownloadableUntil();
            if (downloadableUntil != null) {
                ctx.getProperties().put(COLD_STORAGE_CONTENT_AVAILABLE_UNTIL_MAIL_TEMPLATE_KEY, downloadableUntil.toString());
            }
            String downloadUrl = downloadService.getDownloadUrl(doc, COLD_STORAGE_CONTENT_PROPERTY, null);
            ctx.getProperties().put(COLD_STORAGE_CONTENT_ARCHIVE_LOCATION_MAIL_TEMPLATE_KEY, downloadUrl);
            eventService.fireEvent(ctx.newEvent(COLD_STORAGE_CONTENT_AVAILABLE_EVENT_NAME));
        }
        log.debug("End checking the available cold storage content for repository: {}, beingRetrieved: {}, available: {}", (Object)session.getRepositoryName(), (Object)beingRetrieved, (Object)available);
        return new ColdStorageContentStatus(beingRetrieved, available);
    }

    protected static String getContentBlobKey(Blob coldContent) {
        String key = ((ManagedBlob)coldContent).getKey();
        int colon = key.indexOf(58);
        if (colon >= 0) {
            key = key.substring(colon + 1);
        }
        return key;
    }

    private ColdStorageHelper() {
    }

    public static class ColdStorageContentStatus {
        protected final int totalBeingRetrieved;
        protected final int totalAvailable;

        public ColdStorageContentStatus(int totalBeingRetrieved, int totalAvailable) {
            this.totalBeingRetrieved = totalBeingRetrieved;
            this.totalAvailable = totalAvailable;
        }

        public int getTotalBeingRetrieved() {
            return this.totalBeingRetrieved;
        }

        public int getTotalAvailable() {
            return this.totalAvailable;
        }
    }
}

