/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.xml;

import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.model.Field;
import org.nuxeo.connect.update.model.Form;
import org.nuxeo.connect.update.model.PackageDefinition;
import org.nuxeo.connect.update.xml.FormDefinition;
import org.nuxeo.connect.update.xml.FormsDefinition;
import org.nuxeo.connect.update.xml.XmlWriter;

public class XmlSerializer
extends XmlWriter {
    public XmlSerializer() {
    }

    public XmlSerializer(String tab) {
        super(tab);
    }

    public String toXML(PackageDefinition def) {
        this.start("package");
        if (def.getType() != null) {
            this.attr("type", def.getType().getValue());
        }
        this.attr("name", def.getName());
        if (def.getVersion() != null) {
            this.attr("version", def.getVersion().toString());
        }
        this.startContent();
        this.element("title", def.getTitle());
        this.element("description", def.getDescription());
        this.element("vendor", def.getVendor());
        this.element("classifier", def.getClassifier());
        this.element("hotreload-support", Boolean.valueOf(def.supportsHotReload()).toString());
        this.element("require-terms-and-conditions-acceptance", Boolean.valueOf(def.requireTermsAndConditionsAcceptance()).toString());
        if (def.getInstaller() != null) {
            this.start("installer");
            this.attr("class", def.getInstaller().getType());
            this.attr("restart", String.valueOf(def.getInstaller().getRequireRestart()));
            this.end();
        }
        if (def.getUninstaller() != null) {
            this.start("uninstaller");
            this.attr("class", def.getUninstaller().getType());
            this.attr("restart", String.valueOf(def.getUninstaller().getRequireRestart()));
            this.end();
        }
        this.element("validator", def.getValidator());
        if (def.getTargetPlatforms() != null && def.getTargetPlatforms().length > 0) {
            this.start("platforms");
            this.startContent();
            for (String string : def.getTargetPlatforms()) {
                this.element("platform", string);
            }
            this.end("platforms");
        }
        if (def.getDependencies() != null && def.getDependencies().length > 0) {
            this.start("dependencies");
            this.startContent();
            for (PackageDependency packageDependency : def.getDependencies()) {
                this.element("package", packageDependency.toString());
            }
            this.end("dependencies");
        }
        if (def.getOptionalDependencies() != null && def.getOptionalDependencies().length > 0) {
            this.start("optional-dependencies");
            this.startContent();
            for (PackageDependency packageDependency : def.getOptionalDependencies()) {
                this.element("package", packageDependency.toString());
            }
            this.end("optional-dependencies");
        }
        try {
            def.getClass().getMethod("getConflicts", new Class[0]);
            if (def.getConflicts() != null && def.getConflicts().length > 0) {
                this.start("conflicts");
                this.startContent();
                for (PackageDependency packageDependency : def.getConflicts()) {
                    this.element("package", packageDependency.toString());
                }
                this.end("conflicts");
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            def.getClass().getMethod("getProvides", new Class[0]);
            if (def.getProvides() != null && def.getProvides().length > 0) {
                this.start("provides");
                this.startContent();
                for (PackageDependency packageDependency : def.getProvides()) {
                    this.element("package", packageDependency.toString());
                }
                this.end("provides");
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.end("package");
        return this.sb.toString();
    }

    public void buildXML(Form form) {
        this.start("form");
        this.startContent();
        this.element("title", form.getTitle());
        this.element("image", form.getImage());
        this.element("description", form.getDescription());
        if (form.getFields() != null && form.getFields().length > 0) {
            this.start("fields");
            this.startContent();
            for (Field field : form.getFields()) {
                this.start("field");
                this.attr("name", field.getName());
                this.attr("type", field.getType());
                if (field.isRequired()) {
                    this.attr("required", "true");
                }
                if (field.isReadOnly()) {
                    this.attr("readonly", "true");
                }
                if (field.isVertical()) {
                    this.attr("vertical", "true");
                }
                this.startContent();
                this.element("label", field.getLabel());
                this.element("value", field.getValue());
                this.end("field");
            }
            this.end("fields");
        }
        this.end("form");
    }

    public String toXML(FormDefinition form) {
        this.buildXML(form);
        return this.sb.toString();
    }

    public String toXML(FormDefinition ... forms) {
        this.start("forms");
        this.startContent();
        for (FormDefinition form : forms) {
            this.buildXML(form);
        }
        this.end("forms");
        return this.sb.toString();
    }

    public String toXML(FormsDefinition forms) {
        this.start("forms");
        this.startContent();
        for (Form form : forms.getForms()) {
            this.buildXML(form);
        }
        this.end("forms");
        return this.sb.toString();
    }
}

