/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.persistence.fs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.xmap.DOMSerializer;
import org.nuxeo.runtime.model.persistence.Contribution;
import org.nuxeo.runtime.model.persistence.ContributionStorage;
import org.nuxeo.runtime.model.persistence.fs.ContributionFile;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FileSystemStorage
implements ContributionStorage {
    public static final Log log = LogFactory.getLog(FileSystemStorage.class);
    protected static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    protected final File root = new File(Environment.getDefault().getData(), "contribs");

    public FileSystemStorage() {
        this.root.mkdirs();
    }

    public static synchronized String safeRead(File file) {
        try {
            return FileUtils.readFileToString(file, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized void safeWrite(File file, String content) {
        try {
            FileUtils.writeStringToFile(file, content, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized boolean safeCreate(File file, String content) {
        if (file.isFile()) {
            return false;
        }
        try {
            FileUtils.writeStringToFile(file, content, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public static synchronized boolean safeRemove(File file) {
        return file.delete();
    }

    public static void loadMetadata(Contribution contrib) {
        try {
            Node node;
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(new ByteArrayInputStream(contrib.getContent().getBytes()));
            Element root = doc.getDocumentElement();
            contrib.setDisabled(Boolean.parseBoolean(root.getAttribute("disabled")));
            for (node = root.getFirstChild(); !(node == null || node.getNodeType() == 1 && "documentation".equals(node.getNodeName())); node = node.getNextSibling()) {
            }
            if (node != null) {
                StringBuilder sb = new StringBuilder();
                for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 3) continue;
                    sb.append(node.getNodeValue());
                }
                contrib.setDescription(sb.toString().trim());
            } else {
                contrib.setDescription("");
            }
        }
        catch (IOException | ParserConfigurationException | DOMException | SAXException e) {
            log.error("Failed to read contribution metadata", e);
        }
    }

    @Override
    public Contribution addContribution(Contribution contribution) {
        String content;
        File file = new File(this.root, contribution.getName() + ".xml");
        if (FileSystemStorage.safeCreate(file, content = contribution.getContent())) {
            return new ContributionFile(contribution.getName(), file);
        }
        return null;
    }

    @Override
    public Contribution getContribution(String name) {
        File file = new File(this.root, name + ".xml");
        if (file.isFile()) {
            return new ContributionFile(name, file);
        }
        return null;
    }

    @Override
    public List<Contribution> getContributions() {
        ArrayList<Contribution> result = new ArrayList<Contribution>();
        File[] files = this.root.listFiles();
        if (files == null) {
            return result;
        }
        for (File file : files) {
            String name = file.getName();
            if (!name.endsWith(".xml")) continue;
            name = name.substring(0, name.length() - 4);
            result.add(new ContributionFile(name, file));
        }
        return result;
    }

    @Override
    public boolean removeContribution(Contribution contrib) {
        return FileSystemStorage.safeRemove(new File(this.root, contrib.getName() + ".xml"));
    }

    @Override
    public Contribution updateContribution(Contribution contribution) {
        Node node;
        Document doc;
        DocumentBuilder docBuilder;
        File file = new File(this.root, contribution.getName() + ".xml");
        String content = FileSystemStorage.safeRead(file);
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            doc = docBuilder.parse(new ByteArrayInputStream(content.getBytes()));
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
        Element root = doc.getDocumentElement();
        if (contribution.isDisabled()) {
            root.setAttribute("disabled", "true");
        } else {
            root.removeAttribute("disabled");
        }
        for (node = root.getFirstChild(); !(node == null || node.getNodeType() == 1 && "documentation".equals(node.getNodeName())); node = node.getNextSibling()) {
        }
        String description = contribution.getDescription();
        if (description == null) {
            description = "";
        }
        if (node != null) {
            root.removeChild(node);
        }
        Element el = doc.createElement("documentation");
        el.appendChild(doc.createTextNode(description));
        root.appendChild(el);
        try {
            FileSystemStorage.safeWrite(file, DOMSerializer.toString(doc));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.getContribution(contribution.getName());
    }
}

