/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableObject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.connect.data.AbstractJSONSerializableData;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.marshaling.JSONExportMethod;
import org.nuxeo.connect.data.marshaling.JSONExportableField;
import org.nuxeo.connect.data.marshaling.JSONImportMethod;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.Version;

public class PackageDescriptor
extends AbstractJSONSerializableData
implements DownloadablePackage {
    private static final String CAP_PREFIX = "cap-";
    private static final String SERVER_PREFIX = "server-";
    private static final String NUXEO_JSF_UI = "nuxeo-jsf-ui";
    public static final String NUXEO_CAP_TARGET_PLATFORM_COMPAT = "nuxeo.cap.target.platform.compat";
    @JSONExportableField
    protected String classifier;
    @JSONExportableField
    protected String description;
    @JSONExportableField
    protected String name;
    @JSONExportableField
    protected String vendor;
    @JSONExportableField
    protected PackageState packageState;
    @JSONExportableField
    protected String license;
    @JSONExportableField
    protected String licenseUrl;
    @JSONExportableField
    protected String[] targetPlatforms;
    protected PackageDependency[] dependencies;
    protected PackageDependency[] optionalDependencies;
    protected PackageDependency[] conflicts;
    protected PackageDependency[] provides;
    @JSONExportableField
    protected String title;
    @JSONExportableField
    protected PackageType type;
    @JSONExportableField
    protected Version version;
    @JSONExportableField
    protected String sourceDigest;
    @JSONExportableField
    protected String sourceUrl;
    @JSONExportableField
    protected long sourceSize;
    @JSONExportableField
    protected int commentsNumber;
    @JSONExportableField
    protected int downloadsCount;
    @JSONExportableField
    protected int rating;
    @JSONExportableField
    protected boolean supportsHotReload;
    @JSONExportableField
    protected boolean subscriptionRequired;
    @JSONExportableField
    protected String owner;
    private boolean local = false;

    @Deprecated
    public static PackageDescriptor loadFromJSON(JSONObject json) throws JSONException {
        return PackageDescriptor.loadFromJSON(PackageDescriptor.class, json);
    }

    @Deprecated
    public static PackageDescriptor loadFromJSON(String json) throws JSONException {
        return PackageDescriptor.loadFromJSON(new JSONObject(json));
    }

    public PackageDescriptor() {
    }

    public PackageDescriptor(DownloadablePackage descriptor) {
        this.classifier = descriptor.getClassifier();
        this.dependencies = descriptor.getDependencies();
        this.optionalDependencies = descriptor.getOptionalDependencies();
        this.conflicts = descriptor.getConflicts();
        this.description = descriptor.getDescription();
        this.license = descriptor.getLicenseType();
        this.licenseUrl = descriptor.getLicenseUrl();
        this.name = descriptor.getName();
        this.provides = descriptor.getProvides();
        this.packageState = descriptor.getPackageState();
        this.targetPlatforms = descriptor.getTargetPlatforms();
        this.title = descriptor.getTitle();
        this.type = descriptor.getType();
        this.vendor = descriptor.getVendor();
        this.version = descriptor.getVersion();
        this.supportsHotReload = descriptor.supportsHotReload();
        this.subscriptionRequired = descriptor.hasSubscriptionRequired();
        this.owner = descriptor.getOwner();
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public int getCommentsNumber() {
        return this.commentsNumber;
    }

    @Override
    public PackageDependency[] getConflicts() {
        if (this.conflicts == null) {
            this.conflicts = new PackageDependency[0];
        }
        return this.conflicts;
    }

    @JSONExportMethod(name="conflicts")
    protected JSONArray getConflictsAsJSON() {
        JSONArray deps = new JSONArray();
        for (PackageDependency dep : this.getConflicts()) {
            deps.put(dep.toString());
        }
        return deps;
    }

    public String getConflictsAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.conflicts == null || this.conflicts.length == 0) {
            return "";
        }
        for (PackageDependency dep : this.getConflicts()) {
            sb.append(dep.toString());
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public PackageDependency[] getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new PackageDependency[0];
        }
        return this.dependencies;
    }

    @JSONExportMethod(name="dependencies")
    protected JSONArray getDependenciesAsJSON() {
        JSONArray deps = new JSONArray();
        for (PackageDependency dep : this.getDependencies()) {
            deps.put(dep.toString());
        }
        return deps;
    }

    public String getDependenciesAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.dependencies == null || this.dependencies.length == 0) {
            return "";
        }
        for (PackageDependency dep : this.getDependencies()) {
            sb.append(dep.toString());
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public PackageDependency[] getOptionalDependencies() {
        if (this.optionalDependencies == null) {
            this.optionalDependencies = new PackageDependency[0];
        }
        return this.optionalDependencies;
    }

    @JSONExportMethod(name="optionalDependencies")
    protected JSONArray getOptionalDependenciesAsJSON() {
        JSONArray deps = new JSONArray();
        for (PackageDependency dep : this.getOptionalDependencies()) {
            deps.put(dep.toString());
        }
        return deps;
    }

    public String getOptionalDependenciesAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.optionalDependencies == null || this.optionalDependencies.length == 0) {
            return "";
        }
        for (PackageDependency dep : this.getOptionalDependencies()) {
            sb.append(dep.toString());
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getDownloadsCount() {
        return this.downloadsCount;
    }

    @Override
    public String getId() {
        if (this.getVersion() == null) {
            return this.getName();
        }
        return this.getName() + "-" + this.getVersion();
    }

    @Override
    public String getLicenseType() {
        return this.license;
    }

    @Override
    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PackageState getPackageState() {
        if (this.packageState == null) {
            this.packageState = PackageState.UNKNOWN;
        }
        return this.packageState;
    }

    @Override
    public PackageDependency[] getProvides() {
        if (this.provides == null) {
            this.provides = new PackageDependency[0];
        }
        return this.provides;
    }

    @JSONExportMethod(name="provides")
    protected JSONArray getProvidesAsJSON() {
        JSONArray deps = new JSONArray();
        for (PackageDependency dep : this.getProvides()) {
            deps.put(dep.toString());
        }
        return deps;
    }

    public String getProvidesAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.provides == null || this.provides.length == 0) {
            return "";
        }
        for (PackageDependency dep : this.getProvides()) {
            sb.append(dep.toString());
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public int getRating() {
        return this.rating;
    }

    @Override
    public String getSourceDigest() {
        return this.sourceDigest;
    }

    @Override
    public long getSourceSize() {
        return this.sourceSize;
    }

    @Override
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @Override
    @Deprecated
    public int getState() {
        return this.packageState.getValue();
    }

    @Override
    public String[] getTargetPlatforms() {
        return this.targetPlatforms;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public PackageType getType() {
        return this.type;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setCommentsNumber(int commentsNumber) {
        this.commentsNumber = commentsNumber;
    }

    public void setConflicts(PackageDependency[] conflicts) {
        this.conflicts = conflicts;
    }

    @JSONImportMethod(name="conflicts")
    protected void setConflictsAsJSON(JSONArray array) throws JSONException {
        PackageDependency[] deps = new PackageDependency[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            deps[i] = new PackageDependency(array.getString(i));
        }
        this.setConflicts(deps);
    }

    public static PackageDependency[] addPackageDependencies(PackageDependency[] dep1, PackageDependency[] dep2) {
        if (dep1 == null) {
            return dep2;
        }
        if (dep2 == null) {
            return dep1;
        }
        LinkedHashSet<PackageDependency> set = new LinkedHashSet<PackageDependency>();
        set.addAll(Arrays.asList(dep1));
        set.addAll(Arrays.asList(dep2));
        return set.toArray(new PackageDependency[0]);
    }

    public void setDependencies(PackageDependency[] dependencies) {
        this.dependencies = PackageDescriptor.addPackageDependencies(this.dependencies, dependencies);
    }

    @JSONImportMethod(name="dependencies")
    protected void setDependenciesAsJSON(JSONArray array) throws JSONException {
        PackageDependency[] deps = new PackageDependency[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            deps[i] = new PackageDependency(array.getString(i));
        }
        this.setDependencies(deps);
    }

    public void setOptionalDependencies(PackageDependency[] optionalDependencies) {
        this.optionalDependencies = PackageDescriptor.addPackageDependencies(this.optionalDependencies, optionalDependencies);
    }

    @JSONImportMethod(name="optionalDependencies")
    protected void setOptionalDependenciesAsJSON(JSONArray array) throws JSONException {
        PackageDependency[] deps = new PackageDependency[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            deps[i] = new PackageDependency(array.getString(i));
        }
        this.setOptionalDependencies(deps);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDownloadsCount(int downloadsCount) {
        this.downloadsCount = downloadsCount;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public void setLocal(boolean isLocal) {
        this.local = isLocal;
    }

    @JSONImportMethod(name="name")
    public void setName(String name) {
        this.name = name;
        this.dependencies = PackageDescriptor.fixDependencies(name, this.dependencies);
    }

    public static PackageDependency[] fixDependencies(String name, PackageDependency[] dependencies) {
        if (dependencies == null) {
            return null;
        }
        for (PackageDependency dep : dependencies) {
            if (!dep.getName().equals(name)) continue;
            ArrayList<PackageDependency> list = new ArrayList<PackageDependency>(Arrays.asList(dependencies));
            list.remove(dep);
            return list.toArray(new PackageDependency[0]);
        }
        return dependencies;
    }

    public void setPackageState(PackageState state) {
        this.packageState = state;
    }

    @JSONImportMethod(name="state")
    public void setPackageState(int state) {
        this.packageState = PackageState.getByValue(state);
    }

    @JSONImportMethod(name="packageState")
    public void setPackageStateAsJSON(String state) {
        this.setPackageState(PackageState.getByLabel(state));
    }

    public void setProvides(PackageDependency[] provides) {
        this.provides = provides;
    }

    @JSONImportMethod(name="provides")
    protected void setProvidesAsJSON(JSONArray array) throws JSONException {
        PackageDependency[] deps = new PackageDependency[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            deps[i] = new PackageDependency(array.getString(i));
        }
        this.setProvides(deps);
    }

    public void setRating(int rating) {
        this.rating = rating;
    }

    public void setSourceDigest(String sourceDigest) {
        this.sourceDigest = sourceDigest;
    }

    public void setSourceSize(long sourceSize) {
        this.sourceSize = sourceSize;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    @Deprecated
    public void setState(int state) {
        this.packageState = PackageState.getByValue(state);
    }

    public void setSupportsHotReload(boolean supportsHotReload) {
        this.supportsHotReload = supportsHotReload;
    }

    public void setTargetPlatforms(List<String> targetPlatforms) {
        this.targetPlatforms = targetPlatforms == null ? new String[]{} : targetPlatforms.toArray(new String[targetPlatforms.size()]);
    }

    public void setTargetPlatforms(String[] targetPlatforms) {
        this.targetPlatforms = targetPlatforms;
    }

    @JSONImportMethod(name="targetPlatforms")
    public void setTargetPlatformsAsJSON(JSONArray array) throws JSONException {
        String[] targets = new String[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            targets[i] = array.getString(i);
        }
        MutableObject packageDependencies = new MutableObject();
        this.targetPlatforms = PackageDescriptor.fixTargetPlatforms(this.name, targets, packageDependencies);
        this.setDependencies((PackageDependency[])packageDependencies.getValue());
    }

    public static String[] fixTargetPlatforms(String name, String[] targets, MutableObject packageDependencies) {
        if (Boolean.parseBoolean(System.getProperty(NUXEO_CAP_TARGET_PLATFORM_COMPAT, "true"))) {
            ArrayList<String> serverTargets = new ArrayList<String>();
            ArrayList<String> newServerTargets = new ArrayList<String>();
            for (String target : targets) {
                if (target.startsWith(SERVER_PREFIX)) {
                    serverTargets.add(target);
                    continue;
                }
                if (!target.startsWith(CAP_PREFIX)) continue;
                String newServerTarget = SERVER_PREFIX + target.substring(CAP_PREFIX.length());
                newServerTargets.add(newServerTarget);
            }
            newServerTargets.removeAll(serverTargets);
            if (!newServerTargets.isEmpty()) {
                ArrayList<String> list = new ArrayList<String>(targets.length + newServerTargets.size());
                list.addAll(Arrays.asList(targets));
                if (!NUXEO_JSF_UI.equals(name)) {
                    list.addAll(newServerTargets);
                }
                targets = list.toArray(new String[0]);
                if (NUXEO_JSF_UI.equals(name)) {
                    packageDependencies.setValue(null);
                } else {
                    packageDependencies.setValue(new PackageDependency[]{new PackageDependency(NUXEO_JSF_UI)});
                }
            }
        }
        return targets;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(PackageType type) {
        this.type = type;
    }

    @JSONImportMethod(name="type")
    public void setTypeAsJSON(String strType) {
        this.type = PackageType.getByValue(strType);
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    @JSONImportMethod(name="version")
    public void setVersionAsJSON(String v) {
        this.version = new Version(v);
    }

    @Override
    public boolean supportsHotReload() {
        return this.supportsHotReload;
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public boolean hasSubscriptionRequired() {
        return this.subscriptionRequired;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }
}

