/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.update;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.common.utils.FileMatcher;

public class JarUtils {
    public static final Pattern JAR_NAME = Pattern.compile("(.+)-(r?[0-9]+.*)\\.jar");
    public static final Pattern JAR_WITHOUT_VERSION_NAME = Pattern.compile("(.+)\\.jar");

    public static Match<String> findJarVersion(String name) {
        Matcher m = JAR_NAME.matcher(name);
        if (m.matches()) {
            Match<String> result = new Match<String>();
            result.object = m.group(1);
            result.version = m.group(2);
            return result;
        }
        m = JAR_WITHOUT_VERSION_NAME.matcher(name);
        if (m.matches()) {
            Match<String> result = new Match<String>();
            result.object = m.group(1);
            result.version = "0.0.0-SNAPSHOT";
            return result;
        }
        return null;
    }

    public static Match<File> findJar(File root, String key) {
        return JarUtils.find(new File(root, key));
    }

    public static Match<File> find(File filePattern) {
        File dir = filePattern.getParentFile();
        File[] files = dir.listFiles();
        if (files != null) {
            FileMatcher fm = FileMatcher.getMatcher(filePattern.getName().concat("-{v:r?[0-9]+.*}\\.jar"));
            String studioSnapshotName = filePattern.getName().concat(".jar");
            for (File f : files) {
                if (fm.match(f.getName())) {
                    Match<File> result = new Match<File>();
                    result.version = fm.getValue();
                    result.object = f;
                    return result;
                }
                if (!studioSnapshotName.equals(f.getName())) continue;
                Match<File> result = new Match<File>();
                result.version = "0.0.0-SNAPSHOT";
                result.object = f;
                return result;
            }
        }
        return null;
    }

    static class Match<T> {
        public T object;
        public String version;

        Match() {
        }
    }
}

