/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.standalone.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Command;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.task.standalone.commands.AbstractCommand;
import org.nuxeo.connect.update.xml.XmlWriter;
import org.w3c.dom.Element;

public class CompositeCommand
extends AbstractCommand {
    public static final String ID = "composite";
    protected final List<Command> commands = new ArrayList<Command>();

    protected CompositeCommand(String id) {
        super(id);
    }

    public CompositeCommand() {
        super(ID);
    }

    @Override
    public void writeTo(XmlWriter writer) {
        for (Command command : this.commands) {
            command.writeTo(writer);
        }
    }

    @Override
    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        CompositeCommand rollbackCommand = new CompositeCommand();
        for (Command command : this.commands) {
            rollbackCommand.addCommand(command.run(task, prefs));
        }
        return rollbackCommand;
    }

    @Override
    protected void doValidate(Task task, ValidationStatus status) throws PackageException {
        for (Command command : this.commands) {
            command.validate(task, status);
        }
    }

    @Override
    public void readFrom(Element element) throws PackageException {
        throw new UnsupportedOperationException("Composite command is for internal use only.");
    }

    public void addCommand(Command command) {
        if (command != null) {
            this.commands.add(command);
        }
    }

    public boolean isEmpty() {
        return this.commands.isEmpty();
    }

    public CompositeCommand combine(CompositeCommand cc) {
        this.commands.addAll(cc.commands);
        return this;
    }
}

