/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher;

import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.launcher.NuxeoLauncher;
import org.nuxeo.launcher.config.ConfigurationGenerator;

public class NuxeoTomcatLauncher
extends NuxeoLauncher {
    public NuxeoTomcatLauncher(ConfigurationGenerator configurationGenerator) {
        super(configurationGenerator);
    }

    @Override
    protected Collection<? extends String> getServerProperties() {
        ArrayList<CallSite> serverProperties = new ArrayList<CallSite>();
        File home = this.configurationGenerator.getNuxeoHome();
        serverProperties.add((CallSite)((Object)("-Dcatalina.base=" + home.getPath())));
        serverProperties.add((CallSite)((Object)("-Dcatalina.home=" + home.getPath())));
        return serverProperties;
    }

    protected String getBinJarName(File binDir, String pattern) {
        File[] binJarFiles = ConfigurationGenerator.getJarFilesFromPattern(binDir, pattern);
        if (binJarFiles.length != 1) {
            throw new RuntimeException("There should be only 1 file but " + binJarFiles.length + " were found in " + binDir.getAbsolutePath() + " looking for " + pattern);
        }
        return binDir.getName() + File.separator + binJarFiles[0].getName();
    }

    @Override
    protected String getClassPath() {
        File binDir = this.configurationGenerator.getNuxeoBinDir();
        String cp = ".";
        cp = this.addToClassPath(cp, "nxserver" + File.separator + "lib");
        cp = this.addToClassPath(cp, this.getBinJarName(binDir, "bootstrap(-\\d+(\\.\\d+)*)?.jar"));
        cp = this.addToClassPath(cp, this.getBinJarName(binDir, "tomcat-juli(-\\d+(\\.\\d+)*)?.jar"));
        return cp;
    }

    @Override
    protected void setServerStartCommand(List<String> command) {
        command.add("org.apache.catalina.startup.Bootstrap");
        command.add("start");
    }

    @Override
    protected void setServerStopCommand(List<String> command) {
        command.add("org.apache.catalina.startup.Bootstrap");
        command.add("stop");
    }

    @Override
    protected String getServerPrint() {
        return "org.apache.catalina.startup.Bootstrap";
    }

    @Override
    protected String getShutdownClassPath() {
        return this.getClassPath();
    }
}

