/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import freemarker.template.TemplateException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.core.LoggerContext;
import org.nuxeo.common.Environment;
import org.nuxeo.common.codec.Crypto;
import org.nuxeo.common.codec.CryptoProperties;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.launcher.commons.DatabaseDriverException;
import org.nuxeo.launcher.config.BackingServiceConfigurator;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.JVMVersion;
import org.nuxeo.launcher.config.JettyConfigurator;
import org.nuxeo.launcher.config.ServerConfigurator;
import org.nuxeo.launcher.config.TomcatConfigurator;
import org.nuxeo.launcher.config.UnknownServerConfigurator;
import org.nuxeo.log4j.Log4JHelper;

public class ConfigurationGenerator {
    public static final String TEMPLATE_SEPARATOR = ",";
    public static final String[] COMPLIANT_JAVA_VERSIONS = new String[]{"1.8.0_40", "11"};
    protected static final String CONFIGURATION_PROPERTIES = "configuration.properties";
    private static final Log log = LogFactory.getLog(ConfigurationGenerator.class);
    public static final String NUXEO_CONF = "nuxeo.conf";
    public static final String TEMPLATES = "templates";
    public static final String NUXEO_DEFAULT_CONF = "nuxeo.defaults";
    public static final String PARAM_TEMPLATES_NAME = "nuxeo.templates";
    public static final String PARAM_TEMPLATE_DBNAME = "nuxeo.dbtemplate";
    public static final String PARAM_TEMPLATE_DBSECONDARY_NAME = "nuxeo.dbnosqltemplate";
    public static final String PARAM_TEMPLATE_DBTYPE = "nuxeo.db.type";
    public static final String PARAM_TEMPLATE_DBSECONDARY_TYPE = "nuxeo.dbsecondary.type";
    public static final String OLD_PARAM_TEMPLATES_PARSING_EXTENSIONS = "nuxeo.templates.parsing.extensions";
    public static final String PARAM_TEMPLATES_PARSING_EXTENSIONS = "nuxeo.plaintext_parsing_extensions";
    public static final String PARAM_TEMPLATES_FREEMARKER_EXTENSIONS = "nuxeo.freemarker_parsing_extensions";
    protected static final String PARAM_INCLUDED_TEMPLATES = "nuxeo.template.includes";
    public static final String PARAM_FORCE_GENERATION = "nuxeo.force.generation";
    public static final String BOUNDARY_BEGIN = "### BEGIN - DO NOT EDIT BETWEEN BEGIN AND END ###";
    public static final String BOUNDARY_END = "### END - DO NOT EDIT BETWEEN BEGIN AND END ###";
    public static final List<String> DB_LIST = Arrays.asList("default", "mongodb", "postgresql", "oracle", "mysql", "mariadb", "mssql", "db2");
    public static final List<String> DB_SECONDARY_LIST = Collections.singletonList("none");
    public static final List<String> DB_EXCLUDE_CHECK_LIST = Arrays.asList("default", "none", "mongodb");
    @Deprecated(since="11.1")
    public static final String PARAM_WIZARD_DONE = "nuxeo.wizard.done";
    @Deprecated(since="11.1")
    public static final String PARAM_WIZARD_RESTART_PARAMS = "wizard.restart.params";
    public static final String PARAM_FAKE_WINDOWS = "org.nuxeo.fake.vindoz";
    public static final String PARAM_LOOPBACK_URL = "nuxeo.loopback.url";
    public static final int MIN_PORT = 1;
    public static final int MAX_PORT = 65535;
    public static final int ADDRESS_PING_TIMEOUT = 1000;
    public static final String PARAM_BIND_ADDRESS = "nuxeo.bind.address";
    public static final String PARAM_HTTP_PORT = "nuxeo.server.http.port";
    @Deprecated
    public static final String PARAM_STATUS_KEY = "server.status.key";
    public static final String PARAM_CONTEXT_PATH = "org.nuxeo.ecm.contextPath";
    @Deprecated(since="11.1")
    public static final String PARAM_MP_DIR = "nuxeo.distribution.marketplace.dir";
    @Deprecated(since="11.1")
    public static final String DISTRIBUTION_MP_DIR = "setupWizardDownloads";
    public static final String INSTALL_AFTER_RESTART = "installAfterRestart.log";
    public static final String PARAM_DB_DRIVER = "nuxeo.db.driver";
    public static final String PARAM_DB_JDBC_URL = "nuxeo.db.jdbc.url";
    public static final String PARAM_DB_HOST = "nuxeo.db.host";
    public static final String PARAM_DB_PORT = "nuxeo.db.port";
    public static final String PARAM_DB_NAME = "nuxeo.db.name";
    public static final String PARAM_DB_USER = "nuxeo.db.user";
    public static final String PARAM_DB_PWD = "nuxeo.db.password";
    public static final String PARAM_MONGODB_NAME = "nuxeo.mongodb.dbname";
    public static final String PARAM_MONGODB_SERVER = "nuxeo.mongodb.server";
    private static final Pattern ENV_VALUE_PATTERN = Pattern.compile("\\$\\{env(?<boolean>\\?\\?)?:(?<envparam>\\w*)(:?(?<defaultvalue>.*?)?)?\\}");
    protected static final Pattern JAVA_OPTS_PATTERN = Pattern.compile("[ ]+(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
    public static final List<String> SECRET_KEYS = Arrays.asList("nuxeo.db.password", "mailservice.password", "mail.transport.password", "nuxeo.http.proxy.password", "nuxeo.ldap.bindpassword", "nuxeo.user.emergency.password");
    @Deprecated
    public static final String PARAM_PRODUCT_NAME = "org.nuxeo.ecm.product.name";
    @Deprecated
    public static final String PARAM_PRODUCT_VERSION = "org.nuxeo.ecm.product.version";
    public static final String PARAM_NUXEO_URL = "nuxeo.url";
    public static final String NUXEO_DEV_SYSTEM_PROP = "org.nuxeo.dev";
    public static final String SEAM_DEBUG_SYSTEM_PROP = "org.nuxeo.seam.debug";
    public static final String JVMCHECK_PROP = "jvmcheck";
    public static final String JVMCHECK_FAIL = "fail";
    public static final String JVMCHECK_NOFAIL = "nofail";
    public static final String JAVA_OPTS_PROP = "launcher.java.opts";
    public static final String VERSIONED_REGEX = "(-\\d+(\\.\\d+)*)?";
    public static final String BOOTSTRAP_JAR_REGEX = "bootstrap(-\\d+(\\.\\d+)*)?.jar";
    public static final String JULI_JAR_REGEX = "tomcat-juli(-\\d+(\\.\\d+)*)?.jar";
    private final File nuxeoHome;
    private final File nuxeoBinDir;
    private final File nuxeoConf;
    private final List<File> includedTemplates = new ArrayList<File>();
    private File nuxeoDefaultConf;
    public boolean isJetty;
    public boolean isTomcat;
    private ServerConfigurator serverConfigurator;
    private BackingServiceConfigurator backingServicesConfigurator;
    private boolean forceGeneration;
    private Properties defaultConfig;
    private CryptoProperties userConfig;
    private boolean configurable = false;
    private boolean onceGeneration = false;
    private String templates;
    private boolean setOnceToFalse = true;
    private boolean setFalseToOnce = false;
    private boolean quiet = false;
    private static boolean hideDeprecationWarnings = false;
    private Environment env;
    private Properties storedConfig;
    private String currentConfigurationDigest;
    protected static final Map<String, String> parametersMigration = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(ConfigurationGenerator.OLD_PARAM_TEMPLATES_PARSING_EXTENSIONS, ConfigurationGenerator.PARAM_TEMPLATES_PARSING_EXTENSIONS);
            this.put("nuxeo.db.user.separator.key", "nuxeo.db.user_separator_key");
            this.put("mail.pop3.host", "mail.store.host");
            this.put("mail.pop3.port", "mail.store.port");
            this.put("mail.smtp.host", "mail.transport.host");
            this.put("mail.smtp.port", "mail.transport.port");
            this.put("mail.smtp.username", "mail.transport.username");
            this.put("mail.transport.username", "mail.transport.user");
            this.put("mail.smtp.password", "mail.transport.password");
            this.put("mail.smtp.usetls", "mail.transport.usetls");
            this.put("mail.smtp.auth", "mail.transport.auth");
        }
    };

    public boolean isConfigurable() {
        return this.configurable;
    }

    public ConfigurationGenerator() {
        this(true, false);
    }

    protected Properties getStoredConfig() {
        if (this.storedConfig == null) {
            this.updateStoredConfig();
        }
        return this.storedConfig;
    }

    public static File[] getJarFilesFromPattern(File dir, String pattern) {
        Pattern jarPattern = Pattern.compile(pattern);
        File[] foundJarFiles = dir.listFiles(f -> jarPattern.matcher(f.getName()).matches());
        if (foundJarFiles == null) {
            foundJarFiles = new File[]{};
        } else if (foundJarFiles.length > 1) {
            throw new RuntimeException(foundJarFiles.length + " files found in " + dir.getAbsolutePath() + " looking for " + pattern);
        }
        return foundJarFiles;
    }

    public ConfigurationGenerator(boolean quiet, boolean debug) {
        File userDir;
        this.quiet = quiet;
        File serverHome = Environment.getDefault().getServerHome();
        this.nuxeoHome = serverHome != null ? serverHome.getAbsoluteFile() : ("bin".equalsIgnoreCase((userDir = new File(System.getProperty("user.dir"))).getName()) ? userDir.getParentFile().getAbsoluteFile() : userDir.getAbsoluteFile());
        this.nuxeoBinDir = new File(this.nuxeoHome, "bin");
        String nuxeoConfPath = System.getProperty(NUXEO_CONF);
        this.nuxeoConf = nuxeoConfPath != null ? new File(nuxeoConfPath).getAbsoluteFile() : new File(this.nuxeoHome, "bin" + File.separator + NUXEO_CONF).getAbsoluteFile();
        System.setProperty(NUXEO_CONF, this.nuxeoConf.getPath());
        this.nuxeoDefaultConf = new File(this.nuxeoHome, TEMPLATES + File.separator + NUXEO_DEFAULT_CONF);
        this.isJetty = System.getProperty("jetty.home") != null;
        boolean bl = this.isTomcat = System.getProperty("tomcat.home") != null;
        if (!this.isJetty && !this.isTomcat) {
            String[] files;
            this.isTomcat = ConfigurationGenerator.getJarFilesFromPattern(this.getNuxeoBinDir(), BOOTSTRAP_JAR_REGEX).length == 1;
            for (String file : files = this.nuxeoHome.list()) {
                if (!file.startsWith("nuxeo-runtime-launcher")) continue;
                this.isJetty = true;
                break;
            }
        }
        this.serverConfigurator = this.isTomcat ? new TomcatConfigurator(this) : (this.isJetty ? new JettyConfigurator(this) : new UnknownServerConfigurator(this));
        if (LoggerContext.getContext(false).getRootLogger().getAppenders().isEmpty()) {
            this.serverConfigurator.initLogs();
        }
        this.backingServicesConfigurator = new BackingServiceConfigurator(this);
        String homeInfo = "Nuxeo home:          " + this.nuxeoHome.getPath();
        String confInfo = "Nuxeo configuration: " + this.nuxeoConf.getPath();
        if (quiet) {
            log.debug(homeInfo);
            log.debug(confInfo);
        } else {
            log.info(homeInfo);
            log.info(confInfo);
        }
    }

    public void hideDeprecationWarnings(boolean hide) {
        hideDeprecationWarnings = hide;
    }

    public void setForceGeneration(boolean forceGeneration) {
        this.forceGeneration = forceGeneration;
    }

    public boolean isForceGeneration() {
        return this.forceGeneration;
    }

    public CryptoProperties getUserConfig() {
        return this.userConfig;
    }

    public final ServerConfigurator getServerConfigurator() {
        return this.serverConfigurator;
    }

    public void run() throws ConfigurationException {
        if (this.init()) {
            if (!this.serverConfigurator.isConfigured()) {
                log.info("No current configuration, generating files...");
                this.generateFiles();
            } else if (this.forceGeneration) {
                log.info("Configuration files generation (nuxeo.force.generation=" + this.userConfig.getProperty(PARAM_FORCE_GENERATION) + ")...");
                this.generateFiles();
            } else {
                log.info("Server already configured (set nuxeo.force.generation=true to force configuration files generation).");
            }
        }
    }

    public boolean init() {
        return this.init(false);
    }

    public boolean init(boolean forceReload) {
        if (this.serverConfigurator instanceof UnknownServerConfigurator) {
            this.configurable = false;
            this.forceGeneration = false;
            log.warn("Server will be considered as not configurable.");
        }
        if (!this.nuxeoConf.exists()) {
            log.info("Missing " + this.nuxeoConf);
            this.configurable = false;
            this.userConfig = new CryptoProperties();
            this.defaultConfig = new Properties();
        } else if (this.userConfig == null || this.userConfig.size() == 0 || forceReload) {
            try {
                if (forceReload) {
                    this.templates = null;
                }
                this.setBasicConfiguration();
                this.configurable = true;
            }
            catch (ConfigurationException e) {
                log.warn("Error reading basic configuration.", e);
                this.configurable = false;
            }
        } else {
            this.configurable = true;
        }
        return this.configurable;
    }

    public String changeTemplates(String newTemplates) {
        String oldTemplates = this.templates;
        this.templates = newTemplates;
        try {
            this.setBasicConfiguration(false);
            this.configurable = true;
        }
        catch (ConfigurationException e) {
            log.warn("Error reading basic configuration.", e);
            this.configurable = false;
        }
        return oldTemplates;
    }

    public void changeDBTemplate(String dbTemplate) {
        this.changeTemplates(this.rebuildTemplatesStr(dbTemplate));
    }

    private void setBasicConfiguration() throws ConfigurationException {
        this.setBasicConfiguration(true);
    }

    private void setBasicConfiguration(boolean save) throws ConfigurationException {
        try {
            this.defaultConfig = ConfigurationGenerator.loadTrimmedProperties(this.nuxeoDefaultConf);
            this.defaultConfig.putAll((Map<?, ?>)System.getProperties());
            this.userConfig = new CryptoProperties(this.defaultConfig);
            if (SystemUtils.IS_OS_WINDOWS) {
                this.replaceBackslashes();
            }
            this.userConfig.putAll(ConfigurationGenerator.loadTrimmedProperties(this.nuxeoConf));
            this.onceGeneration = "once".equals(this.userConfig.getProperty(PARAM_FORCE_GENERATION));
            this.forceGeneration = this.onceGeneration || Boolean.parseBoolean(this.userConfig.getProperty(PARAM_FORCE_GENERATION, "false"));
            this.checkForDeprecatedParameters(this.userConfig);
            this.setDirectoryWithProperty("nuxeo.data.dir");
            this.setDirectoryWithProperty("nuxeo.log.dir");
            this.setDirectoryWithProperty("nuxeo.pid.dir");
            this.setDirectoryWithProperty("nuxeo.tmp.dir");
            this.setDirectoryWithProperty("nuxeo.mp.dir");
        }
        catch (NullPointerException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file: " + this.nuxeoDefaultConf + " or " + this.nuxeoConf, e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        try {
            this.includeTemplates();
            this.checkForDeprecatedParameters(this.defaultConfig);
            this.extractDatabaseTemplateName();
            this.extractSecondaryDatabaseTemplateName();
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        HashMap<String, String> newParametersToSave = this.evalDynamicProperties();
        if (save && newParametersToSave != null && !newParametersToSave.isEmpty()) {
            this.saveConfiguration(newParametersToSave, false, false);
        }
        this.logDebugInformation();
    }

    protected void includeTemplates() throws IOException {
        this.includedTemplates.clear();
        List<File> orderedTemplates = this.includeTemplates(this.getUserTemplates());
        this.includedTemplates.clear();
        this.includedTemplates.addAll(orderedTemplates);
        log.debug(this.includedTemplates);
    }

    private void logDebugInformation() {
        String debugPropValue = this.userConfig.getProperty(NUXEO_DEV_SYSTEM_PROP);
        if (Boolean.parseBoolean(debugPropValue)) {
            log.debug("Nuxeo Dev mode enabled");
        } else {
            log.debug("Nuxeo Dev mode is not enabled");
        }
        String seamDebugPropValue = this.userConfig.getProperty(SEAM_DEBUG_SYSTEM_PROP);
        if (Boolean.parseBoolean(seamDebugPropValue)) {
            log.debug("Nuxeo Seam HotReload is enabled");
        } else {
            log.debug("Nuxeo Seam HotReload is not enabled");
        }
    }

    protected HashMap<String, String> evalDynamicProperties() throws ConfigurationException {
        HashMap<String, String> newParametersToSave = new HashMap<String, String>();
        this.evalEnvironmentVariables(newParametersToSave);
        this.evalLoopbackURL();
        this.evalServerStatusKey(newParametersToSave);
        return newParametersToSave;
    }

    protected void evalEnvironmentVariables(Map<String, String> newParametersToSave) {
        for (Object keyObject : this.userConfig.keySet()) {
            String newValue;
            String key = (String)keyObject;
            String value = this.userConfig.getProperty(key);
            if (!StringUtils.isNotBlank(value) || value.equals(newValue = this.replaceEnvironmentVariables(value))) continue;
            newParametersToSave.put(key, newValue);
        }
    }

    private String replaceEnvironmentVariables(String value) {
        if (StringUtils.isBlank(value)) {
            return value;
        }
        Matcher matcher = ENV_VALUE_PATTERN.matcher(value);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            boolean booleanValue = "??".equals(matcher.group("boolean"));
            String envVarName = matcher.group("envparam");
            String defaultValue = matcher.group("defaultvalue");
            String envValue = this.getEnvironmentVariableValue(envVarName);
            String result = booleanValue ? (StringUtils.isBlank(envValue) ? "false" : "true") : (StringUtils.isBlank(envValue) ? defaultValue : envValue);
            matcher.appendReplacement(sb, result);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private void evalServerStatusKey(Map<String, String> newParametersToSave) {
        if (this.userConfig.getProperty(PARAM_STATUS_KEY) == null) {
            newParametersToSave.put(PARAM_STATUS_KEY, UUID.randomUUID().toString().substring(0, 8));
        }
    }

    private void evalLoopbackURL() throws ConfigurationException {
        Object loopbackURL = this.userConfig.getProperty(PARAM_LOOPBACK_URL);
        if (loopbackURL != null) {
            log.debug("Using configured loop back url: " + (String)loopbackURL);
            return;
        }
        InetAddress bindAddress = this.getBindAddress();
        try {
            if (bindAddress.isAnyLocalAddress()) {
                boolean preferIPv6 = "false".equals(System.getProperty("java.net.preferIPv4Stack")) && "true".equals(System.getProperty("java.net.preferIPv6Addresses"));
                bindAddress = preferIPv6 ? InetAddress.getByName("::1") : InetAddress.getByName("127.0.0.1");
                log.debug("Bind address is \"ANY\", using local address instead: " + bindAddress);
            }
        }
        catch (UnknownHostException e) {
            log.debug(e, e);
            log.error(e.getMessage());
        }
        String httpPort = this.userConfig.getProperty(PARAM_HTTP_PORT);
        String contextPath = this.userConfig.getProperty(PARAM_CONTEXT_PATH);
        loopbackURL = bindAddress instanceof Inet6Address ? "http://[" + bindAddress.getHostAddress() + "]:" + httpPort + contextPath : "http://" + bindAddress.getHostAddress() + ":" + httpPort + contextPath;
        log.debug("Set as loop back URL: " + (String)loopbackURL);
        this.defaultConfig.setProperty(PARAM_LOOPBACK_URL, (String)loopbackURL);
    }

    protected void replaceBackslashes() throws ConfigurationException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.nuxeoConf));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.matches(".*:\\\\.*")) {
                    line = line.replaceAll("\\\\", "/");
                }
                sb.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        try (FileWriter writer = new FileWriter(this.nuxeoConf, false);){
            writer.append(sb.toString());
        }
        catch (IOException e) {
            throw new ConfigurationException("Error writing in " + this.nuxeoConf, e);
        }
    }

    public void setDirectoryWithProperty(String key) {
        String directory = this.userConfig.getProperty(key);
        if (directory == null) {
            this.defaultConfig.setProperty(key, this.serverConfigurator.getDirectory(key).getPath());
        } else {
            this.serverConfigurator.setDirectory(key, directory);
        }
    }

    public String getUserTemplates() {
        if (this.templates == null) {
            this.templates = this.userConfig.getProperty(PARAM_TEMPLATES_NAME);
        }
        if (this.templates == null) {
            log.warn("No template found in configuration! Fallback on 'default'.");
            this.templates = "default";
        }
        this.templates = this.replaceEnvironmentVariables(this.templates);
        this.userConfig.setProperty(PARAM_TEMPLATES_NAME, this.templates);
        return this.templates;
    }

    protected void generateFiles() throws ConfigurationException {
        try {
            this.serverConfigurator.parseAndCopy(this.userConfig);
            this.serverConfigurator.dumpProperties(this.userConfig);
            log.info("Configuration files generated.");
            if (this.onceGeneration) {
                this.setOnceToFalse = true;
                this.writeConfiguration();
            }
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file: " + e.getMessage(), e);
        }
        catch (freemarker.core.ParseException | TemplateException e) {
            throw new ConfigurationException("Could not process FreeMarker template: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Configuration failure: " + e.getMessage(), e);
        }
    }

    private List<File> includeTemplates(String templatesList) throws IOException {
        ArrayList<File> orderedTemplates = new ArrayList<File>();
        StringTokenizer st = new StringTokenizer(templatesList, TEMPLATE_SEPARATOR);
        while (st.hasMoreTokens()) {
            String nextToken = this.replaceEnvironmentVariables(st.nextToken());
            File chosenTemplate = new File(nextToken);
            if (!chosenTemplate.exists() || !chosenTemplate.getPath().equals(chosenTemplate.getAbsolutePath())) {
                chosenTemplate = new File(this.nuxeoDefaultConf.getParentFile(), nextToken);
            }
            if (this.includedTemplates.contains(chosenTemplate)) {
                log.debug("Already included " + nextToken);
                continue;
            }
            if (!chosenTemplate.exists()) {
                log.error(String.format("Template '%s' not found with relative or absolute path (%s). Check your %s parameter, and %s for included files.", nextToken, chosenTemplate, PARAM_TEMPLATES_NAME, PARAM_INCLUDED_TEMPLATES));
                continue;
            }
            File chosenTemplateConf = new File(chosenTemplate, NUXEO_DEFAULT_CONF);
            this.includedTemplates.add(chosenTemplate);
            if (!chosenTemplateConf.exists()) {
                log.warn("Ignore template (no default configuration): " + nextToken);
                continue;
            }
            Properties subTemplateConf = ConfigurationGenerator.loadTrimmedProperties(chosenTemplateConf);
            String subTemplatesList = this.replaceEnvironmentVariables(subTemplateConf.getProperty(PARAM_INCLUDED_TEMPLATES));
            if (subTemplatesList != null && subTemplatesList.length() > 0) {
                orderedTemplates.addAll(this.includeTemplates(subTemplatesList));
            }
            this.defaultConfig.putAll((Map<?, ?>)subTemplateConf);
            orderedTemplates.add(chosenTemplate);
            String templateInfo = "Include template: " + chosenTemplate.getPath();
            if (this.quiet) {
                log.debug(templateInfo);
                continue;
            }
            log.info(templateInfo);
        }
        return orderedTemplates;
    }

    protected void checkForDeprecatedParameters(Properties properties) {
        this.serverConfigurator.addServerSpecificParameters(parametersMigration);
        Enumeration<?> userEnum = properties.propertyNames();
        while (userEnum.hasMoreElements()) {
            String key = (String)userEnum.nextElement();
            if (!parametersMigration.containsKey(key)) continue;
            String value = properties.getProperty(key);
            properties.setProperty(parametersMigration.get(key), value);
            if (hideDeprecationWarnings) continue;
            log.warn("Parameter " + key + " is deprecated - please use " + parametersMigration.get(key) + " instead");
        }
    }

    public File getNuxeoHome() {
        return this.nuxeoHome;
    }

    public File getNuxeoBinDir() {
        return this.nuxeoBinDir;
    }

    public File getNuxeoDefaultConf() {
        return this.nuxeoDefaultConf;
    }

    public List<File> getIncludedTemplates() {
        return this.includedTemplates;
    }

    public void saveConfiguration(Map<String, String> changedParameters) throws ConfigurationException {
        this.saveConfiguration(changedParameters, false, true);
    }

    public void saveConfiguration(Map<String, String> changedParameters, boolean setGenerationOnceToFalse, boolean setGenerationFalseToOnce) throws ConfigurationException {
        this.setOnceToFalse = setGenerationOnceToFalse;
        this.setFalseToOnce = setGenerationFalseToOnce;
        this.updateStoredConfig();
        String newDbTemplate = changedParameters.remove(PARAM_TEMPLATE_DBNAME);
        if (newDbTemplate != null) {
            changedParameters.put(PARAM_TEMPLATES_NAME, this.rebuildTemplatesStr(newDbTemplate));
        }
        if ((newDbTemplate = changedParameters.remove(PARAM_TEMPLATE_DBSECONDARY_NAME)) != null) {
            changedParameters.put(PARAM_TEMPLATES_NAME, this.rebuildTemplatesStr(newDbTemplate));
        }
        if (changedParameters.containsValue(null) || changedParameters.containsValue("")) {
            HashSet<String> propertiesToUnset = new HashSet<String>();
            for (Map.Entry<String, String> entry : changedParameters.entrySet()) {
                if (!StringUtils.isEmpty(entry.getValue())) continue;
                propertiesToUnset.add(entry.getKey());
            }
            for (String key : propertiesToUnset) {
                changedParameters.remove(key);
                this.userConfig.remove(key);
            }
        }
        this.userConfig.putAll((Map<? extends Object, ? extends Object>)changedParameters);
        this.writeConfiguration();
        this.updateStoredConfig();
    }

    private void updateStoredConfig() {
        if (this.storedConfig == null) {
            this.storedConfig = new Properties(this.defaultConfig);
        } else {
            this.storedConfig.clear();
        }
        this.storedConfig.putAll((Map<?, ?>)this.userConfig);
    }

    public void saveFilteredConfiguration(Map<String, String> changedParameters) throws ConfigurationException {
        Map<String, String> filteredParameters = this.getChangedParameters(changedParameters);
        this.saveConfiguration(filteredParameters);
    }

    public Map<String, String> getChangedParameters(Map<String, String> changedParameters) {
        HashMap<String, String> filteredChangedParameters = new HashMap<String, String>();
        for (String key : changedParameters.keySet()) {
            String oldParam = this.getStoredConfig().getProperty(key);
            String newParam = changedParameters.get(key);
            if (newParam != null) {
                newParam = newParam.trim();
            }
            if ((oldParam != null || !StringUtils.isNotEmpty(newParam)) && (oldParam == null || oldParam.trim().equals(newParam))) continue;
            filteredChangedParameters.put(key, newParam);
        }
        return filteredChangedParameters;
    }

    private void writeConfiguration() throws ConfigurationException {
        final MessageDigest newContentDigest = DigestUtils.getMd5Digest();
        StringWriter newContent = new StringWriter(){

            @Override
            public void write(String str) {
                if (str != null) {
                    newContentDigest.update(str.getBytes());
                }
                super.write(str);
            }
        };
        newContent.append(this.readConfiguration());
        newContent.write(BOUNDARY_BEGIN + System.getProperty("line.separator"));
        for (Object o : new TreeSet<Object>(this.userConfig.keySet())) {
            String key = (String)o;
            if (PARAM_FORCE_GENERATION.equals(key) || PARAM_TEMPLATES_NAME.equals(key)) continue;
            String oldValue = this.storedConfig.getProperty(key, "");
            String newValue = this.userConfig.getRawProperty(key, "");
            if (newValue.equals(oldValue)) continue;
            newContent.write("#" + key + "=" + oldValue + System.getProperty("line.separator"));
            newContent.write(key + "=" + newValue + System.getProperty("line.separator"));
        }
        newContent.write(BOUNDARY_END + System.getProperty("line.separator"));
        if (!Hex.encodeHexString(newContentDigest.digest()).equals(this.currentConfigurationDigest)) {
            try (FileWriter writer = new FileWriter(this.nuxeoConf, false);){
                ((Writer)writer).append(newContent.getBuffer());
            }
            catch (IOException e) {
                throw new ConfigurationException("Error writing in " + this.nuxeoConf, e);
            }
        }
    }

    private StringBuilder readConfiguration() throws ConfigurationException {
        String templatesParam = this.userConfig.getProperty(PARAM_TEMPLATES_NAME);
        Integer generationIndex = null;
        Integer templatesIndex = null;
        ArrayList<Object> newLines = new ArrayList<Object>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.nuxeoConf));){
            Object line;
            MessageDigest messageDigest = DigestUtils.getMd5Digest();
            boolean onConfiguratorContent = false;
            while ((line = reader.readLine()) != null) {
                String key;
                int equalIdx;
                messageDigest.update(((String)line).getBytes());
                if (!onConfiguratorContent) {
                    if (!((String)line).startsWith(BOUNDARY_BEGIN)) {
                        if (((String)line).startsWith(PARAM_FORCE_GENERATION)) {
                            if (this.setOnceToFalse && this.onceGeneration) {
                                line = "nuxeo.force.generation=false";
                            }
                            if (this.setFalseToOnce && !this.forceGeneration) {
                                line = "nuxeo.force.generation=once";
                            }
                            if (generationIndex == null) {
                                newLines.add(line);
                                generationIndex = newLines.size() - 1;
                                continue;
                            }
                            newLines.set(generationIndex, line);
                            continue;
                        }
                        if (((String)line).startsWith(PARAM_TEMPLATES_NAME)) {
                            if (templatesParam != null) {
                                line = "nuxeo.templates=" + templatesParam;
                            }
                            if (templatesIndex == null) {
                                newLines.add(line);
                                templatesIndex = newLines.size() - 1;
                                continue;
                            }
                            newLines.set(templatesIndex, line);
                            continue;
                        }
                        equalIdx = ((String)line).indexOf("=");
                        if (equalIdx < 1 || ((String)line).trim().startsWith("#")) {
                            newLines.add(line);
                            continue;
                        }
                        key = ((String)line).substring(0, equalIdx).trim();
                        if (this.userConfig.getProperty(key) != null) {
                            newLines.add(line);
                            continue;
                        }
                        newLines.add("#" + (String)line);
                        continue;
                    }
                    if (templatesIndex == null && templatesParam != null) {
                        newLines.add("nuxeo.templates=" + templatesParam);
                        templatesIndex = newLines.size() - 1;
                    }
                    onConfiguratorContent = true;
                    continue;
                }
                if (!((String)line).startsWith(BOUNDARY_END)) {
                    String value;
                    equalIdx = ((String)line).indexOf("=");
                    if (((String)line).startsWith("#nuxeo.templates") || ((String)line).startsWith(PARAM_TEMPLATES_NAME) || equalIdx < 1) continue;
                    if (((String)line).trim().startsWith("#")) {
                        key = ((String)line).substring(1, equalIdx).trim();
                        value = ((String)line).substring(equalIdx + 1).trim();
                        this.getStoredConfig().setProperty(key, value);
                        continue;
                    }
                    key = ((String)line).substring(0, equalIdx).trim();
                    value = ((String)line).substring(equalIdx + 1).trim();
                    if (value.equals(this.userConfig.getRawProperty(key))) continue;
                    this.getStoredConfig().setProperty(key, value);
                    continue;
                }
                onConfiguratorContent = false;
            }
            reader.close();
            this.currentConfigurationDigest = Hex.encodeHexString(messageDigest.digest());
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        StringBuilder newContent = new StringBuilder();
        for (String string : newLines) {
            newContent.append(string.trim()).append(System.lineSeparator());
        }
        return newContent;
    }

    public String extractDatabaseTemplateName() {
        return this.extractDbTemplateName(DB_LIST, PARAM_TEMPLATE_DBTYPE, PARAM_TEMPLATE_DBNAME, "unknown");
    }

    public String extractSecondaryDatabaseTemplateName() {
        return this.extractDbTemplateName(DB_SECONDARY_LIST, PARAM_TEMPLATE_DBSECONDARY_TYPE, PARAM_TEMPLATE_DBSECONDARY_NAME, null);
    }

    private String extractDbTemplateName(List<String> knownDbList, String paramTemplateDbType, String paramTemplateDbName, String defaultTemplate) {
        String dbTemplate = defaultTemplate;
        boolean found = false;
        for (File templateFile : this.includedTemplates) {
            String template = templateFile.getName();
            if (!knownDbList.contains(template)) continue;
            dbTemplate = template;
            found = true;
        }
        String dbType = this.userConfig.getProperty(paramTemplateDbType);
        if (!found && dbType != null) {
            log.warn(String.format("Didn't find a known database template in the list but some template contributed a value for %s.", paramTemplateDbType));
            dbTemplate = dbType;
        }
        if (dbTemplate != null && !dbTemplate.equals(dbType)) {
            if (dbType == null) {
                log.warn(String.format("Missing value for %s, using %s", paramTemplateDbType, dbTemplate));
                this.userConfig.setProperty(paramTemplateDbType, dbTemplate);
            } else {
                log.debug(String.format("Different values between %s (%s) and %s (%s)", paramTemplateDbName, dbTemplate, paramTemplateDbType, dbType));
            }
        }
        if (dbTemplate == null) {
            this.defaultConfig.remove(paramTemplateDbName);
        } else {
            this.defaultConfig.setProperty(paramTemplateDbName, dbTemplate);
        }
        return dbTemplate;
    }

    public File getNuxeoConf() {
        return this.nuxeoConf;
    }

    public void initLogs() {
        this.serverConfigurator.initLogs();
    }

    public File getLogDir() {
        return this.serverConfigurator.getLogDir();
    }

    public File getPidDir() {
        return this.serverConfigurator.getPidDir();
    }

    public File getDataDir() {
        return this.serverConfigurator.getDataDir();
    }

    public void verifyInstallation() throws ConfigurationException {
        this.checkJavaVersion();
        this.ifNotExistsAndIsDirectoryThenCreate(this.getLogDir());
        this.ifNotExistsAndIsDirectoryThenCreate(this.getPidDir());
        this.ifNotExistsAndIsDirectoryThenCreate(this.getDataDir());
        this.ifNotExistsAndIsDirectoryThenCreate(this.getTmpDir());
        this.ifNotExistsAndIsDirectoryThenCreate(this.getPackagesDir());
        this.checkAddressesAndPorts();
        this.serverConfigurator.verifyInstallation();
        this.backingServicesConfigurator.verifyInstallation();
    }

    private File getPackagesDir() {
        return this.serverConfigurator.getPackagesDir();
    }

    public void checkJavaVersion() throws ConfigurationException {
        String version = System.getProperty("java.version");
        ConfigurationGenerator.checkJavaVersion(version, COMPLIANT_JAVA_VERSIONS);
    }

    protected static void checkJavaVersion(String version, String[] compliantVersions) throws ConfigurationException {
        String lastCompliantVersion = null;
        for (String compliantVersion : compliantVersions) {
            if (ConfigurationGenerator.checkJavaVersion(version, compliantVersion, false, false)) {
                lastCompliantVersion = compliantVersion;
                continue;
            }
            if (lastCompliantVersion != null) {
                return;
            }
            if (!ConfigurationGenerator.checkJavaVersion(version, compliantVersion, true, true)) continue;
            return;
        }
        if (lastCompliantVersion != null) {
            ConfigurationGenerator.checkJavaVersion(version, lastCompliantVersion, false, true);
            return;
        }
        String message = String.format("Nuxeo requires Java %s (detected %s).", ArrayUtils.toString(compliantVersions), version);
        throw new ConfigurationException(message + " See 'jvmcheck' option to bypass version check.");
    }

    protected static boolean checkJavaVersion(String version, String requiredVersion, boolean allowNoFailFlag, boolean warnIfLooseCompliance) {
        allowNoFailFlag = allowNoFailFlag && JVMCHECK_NOFAIL.equalsIgnoreCase(System.getProperty(JVMCHECK_PROP, JVMCHECK_FAIL));
        try {
            boolean compliant;
            JVMVersion required = JVMVersion.parse(requiredVersion);
            JVMVersion actual = JVMVersion.parse(version);
            boolean bl = compliant = actual.compareTo(required) >= 0;
            if (compliant && actual.compareTo(required, JVMVersion.UpTo.MAJOR) == 0) {
                return true;
            }
            if (!compliant && !allowNoFailFlag) {
                return false;
            }
            if (warnIfLooseCompliance) {
                log.warn(String.format("Nuxeo requires Java %s+ (detected %s).", requiredVersion, version));
            }
            return true;
        }
        catch (ParseException cause) {
            if (allowNoFailFlag) {
                log.warn("Cannot check java version", cause);
                return true;
            }
            throw new IllegalArgumentException("Cannot check java version", cause);
        }
    }

    public static boolean checkJavaVersion(String version, String requiredVersion) {
        return ConfigurationGenerator.checkJavaVersion(version, requiredVersion, false, false);
    }

    public void checkAddressesAndPorts() throws ConfigurationException {
        InetAddress bindAddress = this.getBindAddress();
        if (bindAddress.isMulticastAddress()) {
            throw new ConfigurationException("Multicast address won't work: " + bindAddress);
        }
        ConfigurationGenerator.checkAddressReachable(bindAddress);
        ConfigurationGenerator.checkPortAvailable(bindAddress, Integer.parseInt(this.userConfig.getProperty(PARAM_HTTP_PORT)));
    }

    public InetAddress getBindAddress() throws ConfigurationException {
        return ConfigurationGenerator.getBindAddress(this.userConfig.getProperty(PARAM_BIND_ADDRESS));
    }

    public static InetAddress getBindAddress(String hostName) throws ConfigurationException {
        InetAddress bindAddress;
        try {
            bindAddress = InetAddress.getByName(hostName);
            if (bindAddress.isAnyLocalAddress()) {
                boolean preferIPv6 = "false".equals(System.getProperty("java.net.preferIPv4Stack")) && "true".equals(System.getProperty("java.net.preferIPv6Addresses"));
                bindAddress = preferIPv6 ? InetAddress.getByName("::1") : InetAddress.getByName("127.0.0.1");
                log.debug("Bind address is \"ANY\", using local address instead: " + bindAddress);
            }
            log.debug("Configured bind address: " + bindAddress);
        }
        catch (UnknownHostException e) {
            throw new ConfigurationException(e);
        }
        return bindAddress;
    }

    public static void checkAddressReachable(InetAddress address) throws ConfigurationException {
        try {
            log.debug("Checking availability of " + address);
            address.isReachable(1000);
        }
        catch (IOException e) {
            throw new ConfigurationException("Unreachable bind address " + address);
        }
    }

    public static void checkPortAvailable(InetAddress address, int port) throws ConfigurationException {
        if (port == 0 || port == -1) {
            log.warn("Port is set to " + Integer.toString(port) + " - assuming it is disabled - skipping availability check");
            return;
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        ServerSocket socketTCP = null;
        try {
            log.debug("Checking availability of port " + port + " on address " + address);
            socketTCP = new ServerSocket(port, 0, address);
            socketTCP.setReuseAddress(true);
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage() + ": " + address + ":" + port, e);
        }
        finally {
            if (socketTCP != null) {
                try {
                    socketTCP.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public File getTmpDir() {
        return this.serverConfigurator.getTmpDir();
    }

    private void ifNotExistsAndIsDirectoryThenCreate(File directory) {
        if (!directory.isDirectory()) {
            directory.mkdirs();
        }
    }

    public List<String> getLogFiles() {
        File log4jConfFile = this.serverConfigurator.getLogConfFile();
        System.setProperty("nuxeo.log.dir", this.getLogDir().getPath());
        return Log4JHelper.getFileAppendersFileNames(log4jConfFile);
    }

    public String rebuildTemplatesStr(String dbTemplate) {
        int dbIdx;
        ArrayList<String> templatesList = new ArrayList<String>(Arrays.asList(this.templates.split(TEMPLATE_SEPARATOR)));
        String currentDBTemplate = null;
        if (DB_LIST.contains(dbTemplate)) {
            currentDBTemplate = this.userConfig.getProperty(PARAM_TEMPLATE_DBNAME);
            if (currentDBTemplate == null) {
                currentDBTemplate = this.extractDatabaseTemplateName();
            }
        } else if (DB_SECONDARY_LIST.contains(dbTemplate)) {
            currentDBTemplate = this.userConfig.getProperty(PARAM_TEMPLATE_DBSECONDARY_NAME);
            if (currentDBTemplate == null) {
                currentDBTemplate = this.extractSecondaryDatabaseTemplateName();
            }
            if ("none".equals(dbTemplate)) {
                dbTemplate = null;
            }
        }
        if ((dbIdx = templatesList.indexOf(currentDBTemplate)) < 0) {
            if (dbTemplate == null) {
                return this.templates;
            }
            templatesList.add(dbTemplate);
        } else if (dbTemplate == null) {
            templatesList.remove(dbIdx);
        } else {
            templatesList.set(dbIdx, dbTemplate);
        }
        return this.replaceEnvironmentVariables(String.join((CharSequence)TEMPLATE_SEPARATOR, templatesList));
    }

    public File getConfigDir() {
        return this.serverConfigurator.getConfigDir();
    }

    public File getRuntimeHome() {
        return this.serverConfigurator.getRuntimeHome();
    }

    public boolean isInstallInProgress() {
        return this.getInstallFile().exists();
    }

    @Deprecated(since="11.1")
    public File getDistributionMPDir() {
        String mpDir = this.userConfig.getProperty(PARAM_MP_DIR, DISTRIBUTION_MP_DIR);
        return new File(this.getNuxeoHome(), mpDir);
    }

    public File getInstallFile() {
        return new File(this.serverConfigurator.getDataDir(), INSTALL_AFTER_RESTART);
    }

    public void addTemplate(String templatesToAdd) throws ConfigurationException {
        List<String> templatesToAddList;
        List<String> templatesList = this.getTemplateList();
        if (templatesList.addAll(templatesToAddList = Arrays.asList(templatesToAdd.split(TEMPLATE_SEPARATOR)))) {
            String newTemplatesStr = String.join((CharSequence)TEMPLATE_SEPARATOR, templatesList);
            HashMap<String, String> parametersToSave = new HashMap<String, String>();
            parametersToSave.put(PARAM_TEMPLATES_NAME, newTemplatesStr);
            this.saveFilteredConfiguration(parametersToSave);
            this.changeTemplates(newTemplatesStr);
        }
    }

    public List<String> getTemplateList() {
        String currentTemplatesStr = this.userConfig.getProperty(PARAM_TEMPLATES_NAME);
        return Stream.of(this.replaceEnvironmentVariables(currentTemplatesStr).split(TEMPLATE_SEPARATOR)).collect(Collectors.toList());
    }

    public void rmTemplate(String templatesToRm) throws ConfigurationException {
        List<String> templatesToRmList;
        List<String> templatesList = this.getTemplateList();
        if (templatesList.removeAll(templatesToRmList = Arrays.asList(templatesToRm.split(TEMPLATE_SEPARATOR)))) {
            String newTemplatesStr = String.join((CharSequence)TEMPLATE_SEPARATOR, templatesList);
            HashMap<String, String> parametersToSave = new HashMap<String, String>();
            parametersToSave.put(PARAM_TEMPLATES_NAME, newTemplatesStr);
            this.saveFilteredConfiguration(parametersToSave);
            this.changeTemplates(newTemplatesStr);
        }
    }

    public String setProperty(String key, String value) throws ConfigurationException {
        String oldValue = this.getStoredConfig().getProperty(key);
        if (PARAM_TEMPLATES_NAME.equals(key)) {
            this.templates = StringUtils.isBlank(value) ? null : value;
        }
        HashMap<String, String> newParametersToSave = new HashMap<String, String>();
        newParametersToSave.put(key, value);
        this.saveFilteredConfiguration(newParametersToSave);
        this.setBasicConfiguration();
        return oldValue;
    }

    public Map<String, String> setProperties(Map<String, String> newParametersToSave) throws ConfigurationException {
        HashMap<String, String> oldValues = new HashMap<String, String>();
        for (String key : newParametersToSave.keySet()) {
            oldValues.put(key, this.getStoredConfig().getProperty(key));
            if (!PARAM_TEMPLATES_NAME.equals(key)) continue;
            String value = newParametersToSave.get(key);
            this.templates = StringUtils.isBlank(value) ? null : value;
        }
        this.saveFilteredConfiguration(newParametersToSave);
        this.setBasicConfiguration();
        return oldValues;
    }

    public Map<String, String> setProperties(String template, Map<String, String> newParametersToSave) throws ConfigurationException, IOException {
        File templateConf = this.getTemplateConf(template);
        Properties templateProperties = ConfigurationGenerator.loadTrimmedProperties(templateConf);
        HashMap<String, String> oldValues = new HashMap<String, String>();
        StringBuilder newContent = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(templateConf));){
            String line = reader.readLine();
            if (line != null && line.startsWith("## DO NOT EDIT THIS FILE")) {
                throw new ConfigurationException("The template states in its header that it must not be modified.");
            }
            while (line != null) {
                int equalIdx = line.indexOf("=");
                if (equalIdx < 1 || line.trim().startsWith("#")) {
                    newContent.append(line).append(System.getProperty("line.separator"));
                } else {
                    String key = line.substring(0, equalIdx).trim();
                    if (newParametersToSave.containsKey(key)) {
                        newContent.append(key).append("=").append(newParametersToSave.get(key)).append(System.getProperty("line.separator"));
                    } else {
                        newContent.append(line).append(System.getProperty("line.separator"));
                    }
                }
                line = reader.readLine();
            }
        }
        for (String key : newParametersToSave.keySet()) {
            if (templateProperties.containsKey(key)) {
                oldValues.put(key, templateProperties.getProperty(key));
                continue;
            }
            newContent.append(key).append("=").append(newParametersToSave.get(key)).append(System.lineSeparator());
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(templateConf));){
            writer.append(newContent.toString());
        }
        this.setBasicConfiguration();
        return oldValues;
    }

    public void checkDatabaseConnection(String databaseTemplate, String dbName, String dbUser, String dbPassword, String dbHost, String dbPort) throws IOException, DatabaseDriverException, SQLException {
        File databaseTemplateDir = new File(this.nuxeoHome, TEMPLATES + File.separator + databaseTemplate);
        Properties templateProperties = ConfigurationGenerator.loadTrimmedProperties(new File(databaseTemplateDir, NUXEO_DEFAULT_CONF));
        String classname = this.userConfig.containsKey(PARAM_DB_DRIVER) ? (String)this.userConfig.get(PARAM_DB_DRIVER) : templateProperties.getProperty(PARAM_DB_DRIVER);
        String connectionUrl = this.userConfig.containsKey(PARAM_DB_JDBC_URL) ? (String)this.userConfig.get(PARAM_DB_JDBC_URL) : templateProperties.getProperty(PARAM_DB_JDBC_URL);
        Driver driver = this.lookupDriver(databaseTemplate, databaseTemplateDir, classname);
        DriverManager.registerDriver(driver);
        Properties ttProps = new Properties(this.userConfig);
        ttProps.put(PARAM_DB_HOST, dbHost);
        ttProps.put(PARAM_DB_PORT, dbPort);
        ttProps.put(PARAM_DB_NAME, dbName);
        ttProps.put(PARAM_DB_USER, dbUser);
        ttProps.put(PARAM_DB_PWD, dbPassword);
        TextTemplate tt = new TextTemplate(ttProps);
        String url = tt.processText(connectionUrl);
        Properties conProps = new Properties();
        conProps.put("user", dbUser);
        conProps.put("password", dbPassword);
        log.debug("Testing URL " + url + " with " + conProps);
        Connection con = driver.connect(url, conProps);
        con.close();
    }

    private Driver lookupDriver(String databaseTemplate, File databaseTemplateDir, String classname) throws DatabaseDriverException {
        File[] files = ArrayUtils.addAll(new File(databaseTemplateDir, "lib").listFiles(), this.serverConfigurator.getServerLibDir().listFiles());
        ArrayList<URL> urlsList = new ArrayList<URL>();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith("jar")) continue;
                try {
                    urlsList.add(new URL("jar:file:" + file.getPath() + "!/"));
                    log.debug("Added " + file.getPath());
                }
                catch (MalformedURLException e) {
                    log.error(e);
                }
            }
        }
        URLClassLoader ucl = new URLClassLoader(urlsList.toArray(new URL[0]));
        try {
            return (Driver)Class.forName(classname, true, ucl).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new DatabaseDriverException(e);
        }
    }

    public Environment getEnv() {
        if (this.env == null) {
            this.env = new Environment(this.getRuntimeHome());
            File distribFile = new File(new File(this.nuxeoHome, TEMPLATES), "common/config/distribution.properties");
            if (distribFile.exists()) {
                try {
                    this.env.loadProperties(ConfigurationGenerator.loadTrimmedProperties(distribFile));
                }
                catch (IOException e) {
                    log.error(e);
                }
            }
            this.env.loadProperties(this.userConfig);
            this.env.setServerHome(this.getNuxeoHome());
            this.env.init();
            this.env.setData(this.userConfig.getProperty("nuxeo.data.dir", "data"));
            this.env.setLog(this.userConfig.getProperty("nuxeo.log.dir", "logs"));
            this.env.setTemp(this.userConfig.getProperty("nuxeo.tmp.dir", "tmp"));
            this.env.setPath("nuxeo.mp.dir", this.getPackagesDir(), this.env.getServerHome());
        }
        return this.env;
    }

    public static Charset checkFileCharset(File propsFile) throws IOException {
        List<Charset> charsetsToBeTested = Arrays.asList(StandardCharsets.US_ASCII, StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1);
        for (Charset charsetTest : charsetsToBeTested) {
            CharsetDecoder decoder = charsetTest.newDecoder();
            decoder.reset();
            boolean identified = true;
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(propsFile));){
                byte[] buffer = new byte[512];
                while (input.read(buffer) != -1 && identified) {
                    try {
                        decoder.decode(ByteBuffer.wrap(buffer));
                        identified = true;
                    }
                    catch (CharacterCodingException e) {
                        identified = false;
                    }
                }
            }
            if (!identified) continue;
            return charsetTest;
        }
        return null;
    }

    public static Properties loadTrimmedProperties(File propsFile) throws IOException {
        Properties props = new Properties();
        Charset charset = ConfigurationGenerator.checkFileCharset(propsFile);
        if (charset == null) {
            throw new IOException("Can't identify input file charset for " + propsFile.getName());
        }
        log.debug("Opening " + propsFile.getName() + " in " + charset.name());
        try (InputStreamReader propsIS = new InputStreamReader((InputStream)new FileInputStream(propsFile), charset);){
            ConfigurationGenerator.loadTrimmedProperties(props, propsIS);
        }
        return props;
    }

    public static void loadTrimmedProperties(Properties props, InputStreamReader propsIS) throws IOException {
        if (props == null) {
            return;
        }
        Properties p = new Properties();
        p.load(propsIS);
        Enumeration<?> pEnum = p.propertyNames();
        while (pEnum.hasMoreElements()) {
            String key = (String)pEnum.nextElement();
            String value = p.getProperty(key);
            props.put(key.trim(), value.trim());
        }
    }

    public File getDumpedConfig() {
        return new File(this.getConfigDir(), CONFIGURATION_PROPERTIES);
    }

    public Hashtable<Object, Object> getContextEnv(String ldapUrl, String bindDn, String bindPassword, boolean checkAuthentication) {
        Hashtable<Object, Object> contextEnv = new Hashtable<Object, Object>();
        contextEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        contextEnv.put("com.sun.jndi.ldap.connect.timeout", "10000");
        contextEnv.put("java.naming.provider.url", ldapUrl);
        if (checkAuthentication) {
            contextEnv.put("java.naming.security.authentication", "simple");
            contextEnv.put("java.naming.security.principal", bindDn);
            contextEnv.put("java.naming.security.credentials", bindPassword);
        }
        return contextEnv;
    }

    public void checkLdapConnection(String ldapUrl, String ldapBindDn, String ldapBindPwd, boolean authenticate) throws NamingException {
        this.checkLdapConnection(this.getContextEnv(ldapUrl, ldapBindDn, ldapBindPwd, authenticate));
    }

    public void checkLdapConnection(Hashtable<Object, Object> contextEnv) throws NamingException {
        InitialDirContext dirContext = new InitialDirContext(contextEnv);
        dirContext.close();
    }

    public Crypto getCrypto() {
        return this.userConfig.getCrypto();
    }

    public File getTemplateConf(String template) throws ConfigurationException {
        File templateDir = new File(template);
        if (!(templateDir.isAbsolute() || (templateDir = new File(System.getProperty("user.dir"), template)).exists() && new File(templateDir, NUXEO_DEFAULT_CONF).exists())) {
            templateDir = new File(this.nuxeoDefaultConf.getParentFile(), template);
        }
        if (!templateDir.exists() || !new File(templateDir, NUXEO_DEFAULT_CONF).exists()) {
            throw new ConfigurationException("Template not found: " + template);
        }
        return new File(templateDir, NUXEO_DEFAULT_CONF);
    }

    @Deprecated
    protected String getJavaOpts(String key, String value) {
        return this.getJavaOptsString();
    }

    public List<String> getJavaOpts(Function<String, String> mapper) {
        return Arrays.stream(JAVA_OPTS_PATTERN.split(System.getProperty(JAVA_OPTS_PROP, ""))).map(option -> StringSubstitutor.replace(option, this.getUserConfig())).map(mapper).collect(Collectors.toList());
    }

    protected String getJavaOptsString() {
        return String.join((CharSequence)" ", this.getJavaOpts(Function.identity()));
    }

    protected String getEnvironmentVariableValue(String key) {
        return System.getenv(key);
    }
}

