/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.nuxeo.common.Environment;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.impl.DefaultRuntimeContext;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.osgi.OSGiRuntimeService;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ComponentPersistence {
    protected final File root;
    protected final RuntimeContext sysrc;
    protected final OSGiRuntimeService runtime;
    protected final ReadWriteLock fileLock;
    protected final Set<RegistrationInfo> persistedComponents;

    public ComponentPersistence(OSGiRuntimeService runtime) {
        this.runtime = runtime;
        this.root = new File(Environment.getDefault().getData(), "components");
        this.fileLock = new ReentrantReadWriteLock();
        this.sysrc = runtime.getContext();
        this.persistedComponents = Collections.synchronizedSet(new HashSet());
    }

    public File getRoot() {
        return this.root;
    }

    public final RuntimeContext getContext(String symbolicName) {
        if (symbolicName == null) {
            return this.sysrc;
        }
        Bundle bundle = this.runtime.getBundle(symbolicName);
        if (bundle == null) {
            return null;
        }
        return this.runtime.createContext(bundle);
    }

    protected void deploy(RuntimeContext rc, File file) throws IOException {
        RegistrationInfoImpl ri = (RegistrationInfoImpl)rc.deploy(file.toURI().toURL());
        ri.isPersistent = true;
    }

    public void loadPersistedComponents() throws IOException {
        File[] files = this.root.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    RuntimeContext rc = this.getContext(file.getName());
                    if (rc == null) continue;
                    this.loadPersistedComponents(rc, file);
                    continue;
                }
                if (!file.isFile() || !file.getName().endsWith(".xml")) continue;
                this.deploy(this.sysrc, file);
            }
        }
    }

    public void loadPersistedComponents(RuntimeContext rc, File root) throws IOException {
        File[] files = root.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".xml")) continue;
                this.deploy(rc, file);
            }
        }
    }

    public void loadPersistedComponent(File file) throws IOException {
        if ((file = file.getCanonicalFile()).isFile() && file.getName().endsWith(".xml")) {
            RuntimeContext rc;
            File parent = file.getParentFile();
            if (this.root.equals(parent)) {
                this.deploy(this.sysrc, file);
                return;
            }
            String symbolicName = parent.getName();
            if (this.root.equals(parent = parent.getParentFile()) && (rc = this.getContext(symbolicName)) != null) {
                this.deploy(rc, file);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid component file location or bundle not found");
    }

    public Document loadXml(File file) throws IOException {
        byte[] bytes = this.safeReadFile(file);
        return ComponentPersistence.loadXml(new ByteArrayInputStream(bytes));
    }

    public static Document loadXml(InputStream in) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(in);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public void createComponent(byte[] bytes) throws IOException {
        this.createComponent(bytes, true);
    }

    public synchronized void createComponent(byte[] bytes, boolean isPersistent) throws IOException {
        DefaultRuntimeContext rc;
        Document doc = ComponentPersistence.loadXml(new ByteArrayInputStream(bytes));
        Element root = doc.getDocumentElement();
        String name = root.getAttribute("name");
        int p = name.indexOf(58);
        if (p > -1) {
            name = name.substring(p + 1);
        }
        p = name.indexOf(47);
        String owner = null;
        if (p > -1) {
            owner = name.substring(0, p);
        }
        if ((rc = (DefaultRuntimeContext)this.getContext(owner)) == null) {
            throw new IllegalArgumentException("Invalid component name: " + name);
        }
        File file = new File(this.root, name + ".xml");
        if (!isPersistent) {
            file.deleteOnExit();
        }
        file.getParentFile().mkdirs();
        this.safeWriteFile(bytes, file);
        rc.deploy(file.toURI().toURL());
    }

    public synchronized boolean removeComponent(String compName) throws IOException {
        DefaultRuntimeContext rc;
        String path = compName + ".xml";
        File file = new File(this.root, path);
        if (!file.isFile()) {
            return false;
        }
        int p = compName.indexOf(47);
        String owner = null;
        if (p > -1) {
            owner = compName.substring(0, p);
        }
        if ((rc = (DefaultRuntimeContext)this.getContext(owner)) == null) {
            throw new IllegalArgumentException("Invalid component name: " + compName);
        }
        rc.undeploy(file.toURI().toURL());
        file.delete();
        return true;
    }

    protected void safeWriteFile(byte[] bytes, File file) throws IOException {
        this.fileLock.writeLock().lock();
        try {
            FileUtils.writeByteArrayToFile(file, bytes);
        }
        finally {
            this.fileLock.writeLock().unlock();
        }
    }

    protected byte[] safeReadFile(File file) throws IOException {
        this.fileLock.readLock().lock();
        try {
            byte[] byArray = FileUtils.readFileToByteArray(file);
            return byArray;
        }
        finally {
            this.fileLock.readLock().unlock();
        }
    }
}

