/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.standalone.commands;

import java.io.File;
import java.util.Map;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Command;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.task.standalone.commands.AbstractCommand;
import org.nuxeo.connect.update.task.standalone.commands.DeployPlaceholder;
import org.nuxeo.connect.update.task.standalone.commands.UninstallPlaceholder;
import org.nuxeo.connect.update.xml.XmlWriter;
import org.w3c.dom.Element;

public class UndeployPlaceholder
extends AbstractCommand {
    public static final String ID = "undeploy";
    protected File file;

    public UndeployPlaceholder() {
        super(ID);
    }

    public UndeployPlaceholder(File file) {
        super(ID);
        this.file = file;
    }

    @Override
    protected void doValidate(Task task, ValidationStatus status) throws PackageException {
    }

    @Override
    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        if (!this.file.isFile()) {
            return null;
        }
        new UninstallPlaceholder(this.file).doRun(task, prefs);
        return new DeployPlaceholder(this.file);
    }

    @Override
    public void readFrom(Element element) throws PackageException {
        String v = element.getAttribute("file");
        if (v.length() > 0) {
            this.file = new File(v);
            this.guardVars.put("file", this.file);
        }
    }

    @Override
    public void writeTo(XmlWriter writer) {
        writer.start(ID);
        if (this.file != null) {
            writer.attr("file", this.file.getAbsolutePath());
        }
        writer.end();
    }
}

