/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.core.runtime;

import hidden.org.eclipse.core.internal.runtime.Activator;
import hidden.org.eclipse.core.internal.runtime.CommonMessages;
import hidden.org.eclipse.core.internal.runtime.RuntimeLog;
import hidden.org.eclipse.core.runtime.Assert;
import hidden.org.eclipse.core.runtime.CoreException;
import hidden.org.eclipse.core.runtime.ISafeRunnable;
import hidden.org.eclipse.core.runtime.MultiStatus;
import hidden.org.eclipse.core.runtime.OperationCanceledException;
import hidden.org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public final class SafeRunner {
    public static void run(ISafeRunnable code) {
        Assert.isNotNull(code);
        try {
            code.run();
        }
        catch (Exception e) {
            SafeRunner.handleException(code, e);
        }
        catch (LinkageError e) {
            SafeRunner.handleException(code, e);
        }
        catch (AssertionError e) {
            SafeRunner.handleException(code, (Throwable)((Object)e));
        }
    }

    private static void handleException(ISafeRunnable code, Throwable e) {
        if (!(e instanceof OperationCanceledException)) {
            Status status;
            Activator activator = Activator.getDefault();
            String pluginId = null;
            if (activator != null) {
                pluginId = activator.getBundleId(code);
            }
            if (pluginId == null) {
                pluginId = "org.eclipse.equinox.common";
            }
            String message = NLS.bind(CommonMessages.meta_pluginProblems, pluginId);
            if (e instanceof CoreException) {
                status = new MultiStatus(pluginId, 2, message, e);
                status.merge(((CoreException)e).getStatus());
            } else {
                status = new Status(4, pluginId, 2, message, e);
            }
            if (!RuntimeLog.isEmpty()) {
                RuntimeLog.log(status);
            } else {
                e.printStackTrace();
            }
        }
        code.handleException(e);
    }
}

