/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.Functions;
import net.jodah.failsafe.Listeners;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.event.ContextualResultListener;
import net.jodah.failsafe.function.CheckedBiConsumer;
import net.jodah.failsafe.function.CheckedBiFunction;
import net.jodah.failsafe.function.CheckedConsumer;
import net.jodah.failsafe.function.CheckedFunction;
import net.jodah.failsafe.function.CheckedRunnable;
import net.jodah.failsafe.internal.util.Assert;

public class FailsafeConfig<R, F> {
    RetryPolicy retryPolicy = RetryPolicy.NEVER;
    CircuitBreaker circuitBreaker;
    CheckedBiFunction<R, Throwable, R> fallback;
    Listeners<R> listeners;
    ListenerRegistry<R> listenerRegistry;

    FailsafeConfig() {
    }

    FailsafeConfig(FailsafeConfig<R, ?> config) {
        this.retryPolicy = config.retryPolicy;
        this.circuitBreaker = config.circuitBreaker;
        this.fallback = config.fallback;
        this.listeners = config.listeners;
        this.listenerRegistry = config.listenerRegistry;
    }

    static <T> void call(List<ContextualResultListener<T, Throwable>> listeners, T result, Throwable failure, ExecutionContext context) {
        for (ContextualResultListener<T, Throwable> listener : listeners) {
            try {
                listener.onResult(result, failure, context);
            }
            catch (Exception exception) {}
        }
    }

    public F onAbort(CheckedBiConsumer<? extends R, ? extends Throwable> listener) {
        this.registry().abort().add(Listeners.of(listener));
        return (F)this;
    }

    public F onAbort(CheckedConsumer<? extends Throwable> listener) {
        this.registry().abort().add(Listeners.of(listener));
        return (F)this;
    }

    public F onAbort(ContextualResultListener<? extends R, ? extends Throwable> listener) {
        this.registry().abort().add(Assert.notNull(listener, "listener"));
        return (F)this;
    }

    public F onAbortAsync(CheckedBiConsumer<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().abort().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F onAbortAsync(CheckedConsumer<? extends Throwable> listener, ExecutorService executor) {
        this.registry().abort().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F onAbortAsync(ContextualResultListener<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().abort().add(Listeners.of(listener, Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F onComplete(CheckedBiConsumer<? extends R, ? extends Throwable> listener) {
        this.registry().complete().add(Listeners.of(listener));
        return (F)this;
    }

    public F onComplete(ContextualResultListener<? extends R, ? extends Throwable> listener) {
        this.registry().complete().add(Assert.notNull(listener, "listener"));
        return (F)this;
    }

    public F onCompleteAsync(CheckedBiConsumer<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().complete().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F onCompleteAsync(ContextualResultListener<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().complete().add(Listeners.of(listener, Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F onFailedAttempt(CheckedBiConsumer<? extends R, ? extends Throwable> listener) {
        this.registry().failedAttempt().add(Listeners.of(listener));
        return (F)this;
    }

    public F onFailedAttempt(CheckedConsumer<? extends Throwable> listener) {
        this.registry().failedAttempt().add(Listeners.of(listener));
        return (F)this;
    }

    public F onFailedAttempt(ContextualResultListener<? extends R, ? extends Throwable> listener) {
        this.registry().failedAttempt().add(Assert.notNull(listener, "listener"));
        return (F)this;
    }

    public F onFailedAttemptAsync(CheckedBiConsumer<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().failedAttempt().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F onFailedAttemptAsync(CheckedConsumer<? extends Throwable> listener, ExecutorService executor) {
        this.registry().failedAttempt().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F onFailedAttemptAsync(ContextualResultListener<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().failedAttempt().add(Listeners.of(listener, Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F onFailure(CheckedBiConsumer<? extends R, ? extends Throwable> listener) {
        this.registry().failure().add(Listeners.of(listener));
        return (F)this;
    }

    public F onFailure(CheckedConsumer<? extends Throwable> listener) {
        this.registry().failure().add(Listeners.of(listener));
        return (F)this;
    }

    public F onFailure(ContextualResultListener<? extends R, ? extends Throwable> listener) {
        this.registry().failure().add(Assert.notNull(listener, "listener"));
        return (F)this;
    }

    public F onFailureAsync(CheckedBiConsumer<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().failure().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F onFailureAsync(CheckedConsumer<? extends Throwable> listener, ExecutorService executor) {
        this.registry().failure().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F onFailureAsync(ContextualResultListener<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().failure().add(Listeners.of(listener, Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F onRetriesExceeded(CheckedBiConsumer<? extends R, ? extends Throwable> listener) {
        this.registry().retriesExceeded().add(Listeners.of(listener));
        return (F)this;
    }

    public F onRetriesExceeded(CheckedConsumer<? extends Throwable> listener) {
        this.registry().retriesExceeded().add(Listeners.of(listener));
        return (F)this;
    }

    public F onRetriesExceededAsync(CheckedBiConsumer<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().retriesExceeded().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F onRetriesExceededAsync(CheckedConsumer<? extends Throwable> listener, ExecutorService executor) {
        this.registry().retriesExceeded().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F onRetry(CheckedBiConsumer<? extends R, ? extends Throwable> listener) {
        this.registry().retry().add(Listeners.of(listener));
        return (F)this;
    }

    public F onRetry(CheckedConsumer<? extends Throwable> listener) {
        this.registry().retry().add(Listeners.of(listener));
        return (F)this;
    }

    public F onRetry(ContextualResultListener<? extends R, ? extends Throwable> listener) {
        this.registry().retry().add(Assert.notNull(listener, "listener"));
        return (F)this;
    }

    public F onRetryAsync(CheckedBiConsumer<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().retry().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F onRetryAsync(CheckedConsumer<? extends Throwable> listener, ExecutorService executor) {
        this.registry().retry().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F onRetryAsync(ContextualResultListener<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().retry().add(Listeners.of(listener, Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F onSuccess(CheckedBiConsumer<? extends R, ExecutionContext> listener) {
        this.registry().success().add(Listeners.ofResult(listener));
        return (F)this;
    }

    public F onSuccess(CheckedConsumer<? extends R> listener) {
        this.registry().success().add(Listeners.ofResult(listener));
        return (F)this;
    }

    public F onSuccessAsync(CheckedBiConsumer<? extends R, ExecutionContext> listener, ExecutorService executor) {
        this.registry().success().add(Listeners.of(Listeners.ofResult(listener), Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F onSuccessAsync(CheckedConsumer<? extends R> listener, ExecutorService executor) {
        this.registry().success().add(Listeners.of(Listeners.ofResult(listener), Assert.notNull(executor, "executor"), null));
        return (F)this;
    }

    public F with(CircuitBreaker circuitBreaker) {
        Assert.state(this.circuitBreaker == null, "A circuit breaker has already been configured", new Object[0]);
        this.circuitBreaker = Assert.notNull(circuitBreaker, "circuitBreaker");
        return (F)this;
    }

    public <T> F with(Listeners<T> listeners) {
        this.listeners = Assert.notNull(listeners, "listeners");
        return (F)this;
    }

    public F with(RetryPolicy retryPolicy) {
        Assert.state(this.retryPolicy == RetryPolicy.NEVER, "A retry policy has already been configurd", new Object[0]);
        this.retryPolicy = Assert.notNull(retryPolicy, "retryPolicy");
        return (F)this;
    }

    public F withFallback(Callable<? extends R> fallback) {
        return this.withFallback((R)Functions.fnOf(Assert.notNull(fallback, "fallback")));
    }

    public F withFallback(CheckedBiConsumer<? extends R, ? extends Throwable> fallback) {
        return this.withFallback((R)Functions.fnOf(Assert.notNull(fallback, "fallback")));
    }

    public F withFallback(CheckedBiFunction<? extends R, ? extends Throwable, ? extends R> fallback) {
        Assert.state(this.fallback == null, "withFallback has already been called", new Object[0]);
        this.fallback = Assert.notNull(fallback, "fallback");
        return (F)this;
    }

    public F withFallback(CheckedConsumer<? extends Throwable> fallback) {
        return this.withFallback((R)Functions.fnOf(Assert.notNull(fallback, "fallback")));
    }

    public F withFallback(CheckedFunction<? extends Throwable, ? extends R> fallback) {
        return this.withFallback((R)Functions.fnOf(Assert.notNull(fallback, "fallback")));
    }

    public F withFallback(CheckedRunnable fallback) {
        return this.withFallback((R)Functions.fnOf(Assert.notNull(fallback, "fallback")));
    }

    public F withFallback(R fallback) {
        return this.withFallback((R)Functions.fnOf(Assert.notNull(fallback, "fallback")));
    }

    void handleAbort(R result, Throwable failure, ExecutionContext context) {
        if (this.listenerRegistry != null && ((ListenerRegistry)this.listenerRegistry).abortListeners != null) {
            context = context.copy();
            FailsafeConfig.call(((ListenerRegistry)this.listenerRegistry).abortListeners, result, failure, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onAbort(result, failure);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onAbort(result, failure, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void handleComplete(R result, Throwable failure, ExecutionContext context, boolean success) {
        if (success) {
            this.handleSuccess(result, context);
        } else {
            this.handleFailure(result, failure, context);
        }
        this.handleComplete(result, failure, context);
    }

    void handleFailedAttempt(R result, Throwable failure, ExecutionContext context) {
        if (this.listenerRegistry != null && ((ListenerRegistry)this.listenerRegistry).failedAttemptListeners != null) {
            context = context.copy();
            FailsafeConfig.call(((ListenerRegistry)this.listenerRegistry).failedAttemptListeners, result, failure, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onFailedAttempt(result, failure);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onFailedAttempt(result, failure, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void handleRetriesExceeded(R result, Throwable failure, ExecutionContext context) {
        if (this.listenerRegistry != null && ((ListenerRegistry)this.listenerRegistry).retriesExceededListeners != null) {
            context = context.copy();
            FailsafeConfig.call(((ListenerRegistry)this.listenerRegistry).retriesExceededListeners, result, failure, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onRetriesExceeded(result, failure);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void handleRetry(R result, Throwable failure, ExecutionContext context) {
        if (this.listenerRegistry != null && ((ListenerRegistry)this.listenerRegistry).retryListeners != null) {
            context = context.copy();
            FailsafeConfig.call(((ListenerRegistry)this.listenerRegistry).retryListeners, result, failure, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onRetry(result, failure);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onRetry(result, failure, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    ListenerRegistry<R> registry() {
        return this.listenerRegistry != null ? this.listenerRegistry : (this.listenerRegistry = new ListenerRegistry());
    }

    private void handleComplete(R result, Throwable failure, ExecutionContext context) {
        if (this.listenerRegistry != null && ((ListenerRegistry)this.listenerRegistry).completeListeners != null) {
            context = context.copy();
            FailsafeConfig.call(((ListenerRegistry)this.listenerRegistry).completeListeners, result, failure, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onComplete(result, failure);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onComplete(result, failure, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void handleFailure(R result, Throwable failure, ExecutionContext context) {
        if (this.listenerRegistry != null && ((ListenerRegistry)this.listenerRegistry).failureListeners != null) {
            context = context.copy();
            FailsafeConfig.call(((ListenerRegistry)this.listenerRegistry).failureListeners, result, failure, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onFailure(result, failure);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onFailure(result, failure, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void handleSuccess(R result, ExecutionContext context) {
        if (this.listenerRegistry != null && ((ListenerRegistry)this.listenerRegistry).successListeners != null) {
            context = context.copy();
            FailsafeConfig.call(((ListenerRegistry)this.listenerRegistry).successListeners, result, null, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onSuccess(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onSuccess(result, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class ListenerRegistry<T> {
        private List<ContextualResultListener<T, Throwable>> abortListeners;
        private List<ContextualResultListener<T, Throwable>> completeListeners;
        private List<ContextualResultListener<T, Throwable>> failedAttemptListeners;
        private List<ContextualResultListener<T, Throwable>> failureListeners;
        private List<ContextualResultListener<T, Throwable>> retriesExceededListeners;
        private List<ContextualResultListener<T, Throwable>> retryListeners;
        private List<ContextualResultListener<T, Throwable>> successListeners;

        ListenerRegistry() {
        }

        List<ContextualResultListener<T, Throwable>> abort() {
            return this.abortListeners != null ? this.abortListeners : (this.abortListeners = new ArrayList<ContextualResultListener<T, Throwable>>(2));
        }

        List<ContextualResultListener<T, Throwable>> complete() {
            return this.completeListeners != null ? this.completeListeners : (this.completeListeners = new ArrayList<ContextualResultListener<T, Throwable>>(2));
        }

        List<ContextualResultListener<T, Throwable>> failedAttempt() {
            return this.failedAttemptListeners != null ? this.failedAttemptListeners : (this.failedAttemptListeners = new ArrayList<ContextualResultListener<T, Throwable>>(2));
        }

        List<ContextualResultListener<T, Throwable>> failure() {
            return this.failureListeners != null ? this.failureListeners : (this.failureListeners = new ArrayList<ContextualResultListener<T, Throwable>>(2));
        }

        List<ContextualResultListener<T, Throwable>> retriesExceeded() {
            return this.retriesExceededListeners != null ? this.retriesExceededListeners : (this.retriesExceededListeners = new ArrayList<ContextualResultListener<T, Throwable>>(2));
        }

        List<ContextualResultListener<T, Throwable>> retry() {
            return this.retryListeners != null ? this.retryListeners : (this.retryListeners = new ArrayList<ContextualResultListener<T, Throwable>>(2));
        }

        List<ContextualResultListener<T, Throwable>> success() {
            return this.successListeners != null ? this.successListeners : (this.successListeners = new ArrayList<ContextualResultListener<T, Throwable>>(2));
        }
    }
}

