/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http4;

import java.io.File;
import java.io.IOException;
import java.net.ProxySelector;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.http4.Http4FileNameParser;
import org.apache.commons.vfs2.provider.http4.Http4FileSystem;
import org.apache.commons.vfs2.provider.http4.Http4FileSystemConfigBuilder;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class Http4FileProvider
extends AbstractOriginatingFileProvider {
    static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};
    static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.GET_TYPE, Capability.READ_CONTENT, Capability.URI, Capability.GET_LAST_MODIFIED, Capability.ATTRIBUTES, Capability.RANDOM_ACCESS_READ, Capability.DIRECTORY_READ_CONTENT));

    public Http4FileProvider() {
        this.setFileNameParser(Http4FileNameParser.getInstance());
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return Http4FileSystemConfigBuilder.getInstance();
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        GenericFileName rootName = (GenericFileName)name;
        UserAuthenticationData authData = null;
        HttpClient httpClient = null;
        HttpClientContext httpClientContext = null;
        try {
            Http4FileSystemConfigBuilder builder = Http4FileSystemConfigBuilder.getInstance();
            authData = UserAuthenticatorUtils.authenticate(fileSystemOptions, AUTHENTICATOR_TYPES);
            httpClientContext = this.createHttpClientContext(builder, rootName, fileSystemOptions, authData);
            httpClient = this.createHttpClient(builder, rootName, fileSystemOptions);
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(authData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup(authData);
        return new Http4FileSystem(rootName, fileSystemOptions, httpClient, httpClientContext);
    }

    protected HttpClient createHttpClient(Http4FileSystemConfigBuilder builder, GenericFileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return this.createHttpClientBuilder(builder, rootName, fileSystemOptions).build();
    }

    protected HttpClientBuilder createHttpClientBuilder(Http4FileSystemConfigBuilder builder, GenericFileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        ArrayList<BasicHeader> defaultHeaders = new ArrayList<BasicHeader>();
        defaultHeaders.add(new BasicHeader("User-Agent", builder.getUserAgent(fileSystemOptions)));
        ConnectionReuseStrategy connectionReuseStrategy = builder.isKeepAlive(fileSystemOptions) ? DefaultConnectionReuseStrategy.INSTANCE : NoConnectionReuseStrategy.INSTANCE;
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setRoutePlanner(this.createHttpRoutePlanner(builder, fileSystemOptions)).setConnectionManager(this.createConnectionManager(builder, fileSystemOptions)).setSSLContext(this.createSSLContext(builder, fileSystemOptions)).setSSLHostnameVerifier(this.createHostnameVerifier(builder, fileSystemOptions)).setConnectionReuseStrategy(connectionReuseStrategy).setDefaultRequestConfig(this.createDefaultRequestConfig(builder, fileSystemOptions)).setDefaultHeaders(defaultHeaders).setDefaultCookieStore(this.createDefaultCookieStore(builder, fileSystemOptions));
        if (!builder.getFollowRedirect(fileSystemOptions)) {
            httpClientBuilder.disableRedirectHandling();
        }
        return httpClientBuilder;
    }

    protected SSLContext createSSLContext(Http4FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) throws FileSystemException {
        try {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            File keystoreFileObject = null;
            String keystoreFile = builder.getKeyStoreFile(fileSystemOptions);
            if (keystoreFile != null && !keystoreFile.isEmpty()) {
                keystoreFileObject = new File(keystoreFile);
            }
            if (keystoreFileObject != null && keystoreFileObject.exists()) {
                String keystorePass = builder.getKeyStorePass(fileSystemOptions);
                char[] keystorePassChars = keystorePass != null ? keystorePass.toCharArray() : null;
                sslContextBuilder.loadTrustMaterial(keystoreFileObject, keystorePassChars, (TrustStrategy)TrustAllStrategy.INSTANCE);
            } else {
                sslContextBuilder.loadTrustMaterial(TrustAllStrategy.INSTANCE);
            }
            return sslContextBuilder.build();
        }
        catch (KeyStoreException e) {
            throw new FileSystemException("Keystore error. " + e.getMessage(), e);
        }
        catch (KeyManagementException e) {
            throw new FileSystemException("Cannot retrieve keys. " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new FileSystemException("Algorithm error. " + e.getMessage(), e);
        }
        catch (CertificateException e) {
            throw new FileSystemException("Certificate error. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new FileSystemException("Cannot open key file. " + e.getMessage(), e);
        }
    }

    protected HttpClientContext createHttpClientContext(Http4FileSystemConfigBuilder builder, GenericFileName rootName, FileSystemOptions fileSystemOptions, UserAuthenticationData authData) throws FileSystemException {
        UserAuthenticator proxyAuth;
        HttpHost proxyHost;
        HttpClientContext clientContext = HttpClientContext.create();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        clientContext.setCredentialsProvider(credsProvider);
        String username = UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName())));
        String password = UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword())));
        if (username != null && !username.isEmpty()) {
            credsProvider.setCredentials(new AuthScope(rootName.getHostName(), -1), new UsernamePasswordCredentials(username, password));
        }
        if ((proxyHost = this.getProxyHttpHost(builder, fileSystemOptions)) != null && (proxyAuth = builder.getProxyAuthenticator(fileSystemOptions)) != null) {
            UserAuthenticationData proxyAuthData = UserAuthenticatorUtils.authenticate(proxyAuth, new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD});
            if (proxyAuthData != null) {
                UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, null)), UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, null)));
                credsProvider.setCredentials(new AuthScope(proxyHost.getHostName(), -1), proxyCreds);
            }
            if (builder.isPreemptiveAuth(fileSystemOptions)) {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(proxyHost, basicAuth);
                clientContext.setAuthCache(authCache);
            }
        }
        return clientContext;
    }

    private HttpClientConnectionManager createConnectionManager(Http4FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) throws FileSystemException {
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setMaxTotal(builder.getMaxTotalConnections(fileSystemOptions));
        connManager.setDefaultMaxPerRoute(builder.getMaxConnectionsPerHost(fileSystemOptions));
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(builder.getSoTimeout(fileSystemOptions)).build();
        connManager.setDefaultSocketConfig(socketConfig);
        return connManager;
    }

    private RequestConfig createDefaultRequestConfig(Http4FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) {
        return RequestConfig.custom().setConnectTimeout(builder.getConnectionTimeout(fileSystemOptions)).build();
    }

    private HttpRoutePlanner createHttpRoutePlanner(Http4FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) {
        HttpHost proxyHost = this.getProxyHttpHost(builder, fileSystemOptions);
        if (proxyHost != null) {
            return new DefaultProxyRoutePlanner(proxyHost);
        }
        return new SystemDefaultRoutePlanner(ProxySelector.getDefault());
    }

    private HttpHost getProxyHttpHost(Http4FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) {
        String proxyHost = builder.getProxyHost(fileSystemOptions);
        int proxyPort = builder.getProxyPort(fileSystemOptions);
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
            return new HttpHost(proxyHost, proxyPort);
        }
        return null;
    }

    private CookieStore createDefaultCookieStore(Http4FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) {
        BasicCookieStore cookieStore = new BasicCookieStore();
        Cookie[] cookies = builder.getCookies(fileSystemOptions);
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                cookieStore.addCookie(cookie);
            }
        }
        return cookieStore;
    }

    private HostnameVerifier createHostnameVerifier(Http4FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) throws FileSystemException {
        if (!builder.isHostnameVerificationEnabled(fileSystemOptions)) {
            return NoopHostnameVerifier.INSTANCE;
        }
        return new DefaultHostnameVerifier();
    }
}

