/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf.query;

import hidden.org.eclipse.core.runtime.IProgressMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.p2.cudf.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.cudf.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.cudf.metadata.InstallableUnit;
import org.eclipse.equinox.p2.cudf.metadata.ORRequirement;
import org.eclipse.equinox.p2.cudf.metadata.Version;
import org.eclipse.equinox.p2.cudf.metadata.VersionRange;
import org.eclipse.equinox.p2.cudf.query.CapabilityQuery;
import org.eclipse.equinox.p2.cudf.query.Collector;
import org.eclipse.equinox.p2.cudf.query.IQueryable;
import org.eclipse.equinox.p2.cudf.query.Query;

public class QueryableArray
implements IQueryable {
    private final List<InstallableUnit> dataSet;
    private Map<String, List<IUCapability>> namedCapabilityIndex;

    public QueryableArray(InstallableUnit[] ius) {
        this.dataSet = Arrays.asList(ius);
    }

    public List<InstallableUnit> getList() {
        return this.dataSet;
    }

    @Override
    public Collector query(Query query, Collector collector, IProgressMonitor monitor) {
        if (query instanceof CapabilityQuery) {
            return this.queryCapability((CapabilityQuery)query, collector, monitor);
        }
        throw new IllegalArgumentException();
    }

    private Collector queryCapability(CapabilityQuery query, Collector collector, IProgressMonitor monitor) {
        this.generateNamedCapabilityIndex();
        ArrayList<InstallableUnit> resultIUs = new ArrayList<InstallableUnit>();
        IRequiredCapability iRequiredCapability = query.getRequiredCapabilities();
        if (iRequiredCapability instanceof ORRequirement) {
            IRequiredCapability[] ored = ((ORRequirement)iRequiredCapability).getRequirements();
            for (int j = 0; j < ored.length; ++j) {
                Collection<InstallableUnit> orMatches = this.findMatchingIUs(ored[j]);
                if (orMatches == null) continue;
                resultIUs.addAll(orMatches);
            }
        } else {
            Collection<InstallableUnit> matchingIUs = this.findMatchingIUs(iRequiredCapability);
            if (matchingIUs == null) {
                return collector;
            }
            resultIUs.addAll(matchingIUs);
        }
        Iterator iterator = resultIUs.iterator();
        while (iterator.hasNext()) {
            collector.accept(iterator.next());
        }
        return collector;
    }

    private Collection<InstallableUnit> findMatchingIUs(IRequiredCapability requiredCapability) {
        List<IUCapability> iuCapabilities = this.namedCapabilityIndex.get(requiredCapability.getName());
        if (iuCapabilities == null) {
            return null;
        }
        HashSet<InstallableUnit> matchingIUs = new HashSet<InstallableUnit>();
        for (IUCapability iuCapability : iuCapabilities) {
            if (this.intersect(requiredCapability.getRange(), iuCapability.capability.getVersion()) == null) continue;
            matchingIUs.add(iuCapability.iu);
        }
        return matchingIUs;
    }

    private void generateNamedCapabilityIndex() {
        if (this.namedCapabilityIndex != null) {
            return;
        }
        this.namedCapabilityIndex = new HashMap<String, List<IUCapability>>();
        for (InstallableUnit iu : this.dataSet) {
            IProvidedCapability[] providedCapabilities = iu.getProvidedCapabilities();
            for (int i = 0; i < providedCapabilities.length; ++i) {
                String name = providedCapabilities[i].getName();
                List<IUCapability> iuCapabilities = this.namedCapabilityIndex.get(name);
                if (iuCapabilities == null) {
                    iuCapabilities = new ArrayList<IUCapability>(5);
                    this.namedCapabilityIndex.put(name, iuCapabilities);
                }
                iuCapabilities.add(new IUCapability(iu, providedCapabilities[i]));
            }
        }
    }

    public Iterator<InstallableUnit> iterator() {
        return this.dataSet.iterator();
    }

    private VersionRange intersect(VersionRange r1, VersionRange r2) {
        Version resultMin = null;
        boolean resultMinIncluded = false;
        Version resultMax = null;
        boolean resultMaxIncluded = false;
        int minCompare = r1.getMinimum().compareTo(r2.getMinimum());
        if (minCompare < 0) {
            resultMin = r2.getMinimum();
            resultMinIncluded = r2.getIncludeMinimum();
        } else if (minCompare > 0) {
            resultMin = r1.getMinimum();
            resultMinIncluded = r1.getIncludeMinimum();
        } else if (minCompare == 0) {
            resultMin = r1.getMinimum();
            resultMinIncluded = r1.getIncludeMinimum() && r2.getIncludeMinimum();
        }
        int maxCompare = r1.getMaximum().compareTo(r2.getMaximum());
        if (maxCompare > 0) {
            resultMax = r2.getMaximum();
            resultMaxIncluded = r2.getIncludeMaximum();
        } else if (maxCompare < 0) {
            resultMax = r1.getMaximum();
            resultMaxIncluded = r1.getIncludeMaximum();
        } else if (maxCompare == 0) {
            resultMax = r1.getMaximum();
            resultMaxIncluded = r1.getIncludeMaximum() && r2.getIncludeMaximum();
        }
        int resultRangeComparison = resultMin.compareTo(resultMax);
        if (resultRangeComparison < 0) {
            return new VersionRange(resultMin, resultMinIncluded, resultMax, resultMaxIncluded);
        }
        if (resultRangeComparison == 0 && resultMinIncluded == resultMaxIncluded) {
            return new VersionRange(resultMin, resultMinIncluded, resultMax, resultMaxIncluded);
        }
        return null;
    }

    public int getSize() {
        return this.dataSet.size();
    }

    static class IUCapability {
        final InstallableUnit iu;
        final IProvidedCapability capability;

        public IUCapability(InstallableUnit iu, IProvidedCapability capability) {
            this.iu = iu;
            this.capability = capability;
        }
    }
}

