/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.lang.reflect.InvocationTargetException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.List;

public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static Throwable getRootCause(Throwable throwable) {
        List<Throwable> list = ExceptionUtils.getThrowableList(throwable);
        return list.size() < 2 ? null : list.get(list.size() - 1);
    }

    public static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = ExceptionUtils.getCause(throwable);
        }
        return list;
    }

    protected static Throwable getCause(Throwable throwable) {
        if (throwable != null) {
            return throwable.getCause();
        }
        return null;
    }

    public static void checkInterrupt(Exception e) {
        if (ExceptionUtils.isInterrupted(e)) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        if (Thread.currentThread().isInterrupted()) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static Exception unwrapInvoke(Exception e) {
        if (e instanceof InvocationTargetException) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            e = cause instanceof Exception ? (Exception)cause : new RuntimeException(cause);
        }
        ExceptionUtils.checkInterrupt(e);
        return e;
    }

    public static RuntimeException runtimeException(Exception e) {
        if ((e = ExceptionUtils.unwrapInvoke(e)) instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static boolean hasInterruptedCause(Throwable e) {
        for (Throwable t = e; t != null; t = t.getCause()) {
            if (!ExceptionUtils.isInterrupted(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInterrupted(Throwable t) {
        return t instanceof InterruptedException || t instanceof ClosedByInterruptException;
    }
}

