/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.PathFilter;

public final class ZipUtils {
    private ZipUtils() {
    }

    public static void _putDirectoryEntry(String entryName, ZipOutputStream out) throws IOException {
        ZipEntry zentry = new ZipEntry(entryName + "/");
        out.putNextEntry(zentry);
        out.closeEntry();
    }

    public static void _putFileEntry(File file, String entryName, ZipOutputStream out) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            ZipUtils._zip(entryName, in, out);
        }
    }

    public static void _zip(String entryName, InputStream in, ZipOutputStream out) throws IOException {
        ZipEntry zentry = new ZipEntry(entryName);
        out.putNextEntry(zentry);
        IOUtils.copy(in, (OutputStream)out);
        out.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _zip(String entryName, File file, ZipOutputStream out) throws IOException {
        if (file.isDirectory()) {
            File[] files;
            entryName = (String)entryName + "/";
            ZipEntry zentry = new ZipEntry((String)entryName);
            out.putNextEntry(zentry);
            out.closeEntry();
            for (File child : files = file.listFiles()) {
                ZipUtils._zip((String)entryName + child.getName(), child, out);
            }
        } else {
            try (InputStream in = null;){
                in = new BufferedInputStream(new FileInputStream(file));
                ZipUtils._zip((String)entryName, in, out);
            }
        }
    }

    public static void _zip(File[] files, ZipOutputStream out, String prefix) throws IOException {
        String normalizedPrefix = ZipUtils.normalizePrefix(prefix);
        for (File file : files) {
            String name = normalizedPrefix + file.getName();
            ZipUtils._zip(name, file, out);
        }
    }

    public static void zip(File file, OutputStream out, String prefix) throws IOException {
        prefix = ZipUtils.normalizePrefix(prefix);
        String name = ZipUtils.normalizePrefix(prefix) + file.getName();
        try (ZipOutputStream zout = new ZipOutputStream(out);){
            ZipUtils._zip(name, file, zout);
        }
    }

    protected static String normalizePrefix(String prefix) {
        Object result = StringUtils.defaultString(prefix);
        int len = ((String)result).length();
        if (len > 0 && ((String)result).charAt(len - 1) != '/') {
            result = (String)result + "/";
        }
        return result;
    }

    public static void zip(File[] files, OutputStream out, String prefix) throws IOException {
        try (ZipOutputStream zout = new ZipOutputStream(out);){
            ZipUtils._zip(files, zout, prefix);
        }
    }

    public static void zip(File file, File zip) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(zip));){
            ZipUtils.zip(file, (OutputStream)out, null);
        }
    }

    public static void zip(File[] files, File zip) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(zip));){
            ZipUtils.zip(files, (OutputStream)out, null);
        }
    }

    public static void zip(File file, File zip, String prefix) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(zip));){
            ZipUtils.zip(file, (OutputStream)out, prefix);
        }
    }

    public static void zip(File[] files, File zip, String prefix) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(zip));){
            ZipUtils.zip(files, (OutputStream)out, prefix);
        }
    }

    public static void zipFilesUsingPrefix(String prefix, File[] files, OutputStream out) throws IOException {
        try (ZipOutputStream zout = new ZipOutputStream(out);){
            if (prefix != null && ((String)prefix).length() > 0) {
                int p = ((String)prefix).indexOf(47);
                while (p > -1) {
                    ZipUtils._putDirectoryEntry(((String)prefix).substring(0, p), zout);
                    p = ((String)prefix).indexOf(p + 1, 47);
                }
                ZipUtils._putDirectoryEntry((String)prefix, zout);
                prefix = (String)prefix + "/";
            } else {
                prefix = "";
            }
            for (File file : files) {
                ZipUtils._putFileEntry(file, (String)prefix + file.getName(), zout);
            }
        }
    }

    public static void unzip(String prefix, InputStream zipStream, File dir) throws IOException {
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(zipStream));){
            ZipUtils.unzip(prefix, in, dir);
        }
    }

    public static void unzip(InputStream zipStream, File dir) throws IOException {
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(zipStream));){
            ZipUtils.unzip(in, dir);
        }
    }

    public static void unzip(String prefix, URL zip, File dir) throws IOException {
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(zip.openStream()));){
            ZipUtils.unzip(prefix, in, dir);
        }
    }

    public static void unzip(URL zip, File dir) throws IOException {
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(zip.openStream()));){
            ZipUtils.unzip(in, dir);
        }
    }

    public static void unzip(String prefix, File zip, File dir) throws IOException {
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));){
            ZipUtils.unzip(prefix, in, dir);
        }
    }

    public static void unzip(File zip, File dir) throws IOException {
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));){
            ZipUtils.unzip(in, dir);
        }
    }

    public static void unzip(String prefix, ZipInputStream in, File dir) throws IOException {
        ZipUtils.unzip(in, dir, (ZipEntry entry) -> entry.getName().startsWith(prefix), (String name) -> name.substring(prefix.length()));
    }

    public static void unzip(ZipInputStream in, File dir) throws IOException {
        ZipUtils.unzip(in, dir, (ZipEntry entry) -> true, Function.identity());
    }

    private static void unzip(ZipInputStream in, File dir, Predicate<ZipEntry> filter, Function<String, String> nameFormatter) throws IOException {
        ZipEntry entry;
        dir.mkdirs();
        while ((entry = in.getNextEntry()) != null) {
            if (entry.getName().contains("..") || !filter.test(entry)) continue;
            File file = new File(dir, nameFormatter.apply(entry.getName()));
            if (entry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            file.getParentFile().mkdirs();
            FileOutputStream output = FileUtils.openOutputStream(file);
            try {
                IOUtils.copy((InputStream)in, (OutputStream)output);
            }
            finally {
                if (output == null) continue;
                output.close();
            }
        }
    }

    public static void unzipIgnoreDirs(ZipInputStream in, File dir) throws IOException {
        ZipUtils.unzip(in, dir, (ZipEntry entry) -> !entry.isDirectory(), Function.identity());
    }

    public static void unzipIgnoreDirs(InputStream zipStream, File dir) throws IOException {
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(zipStream));){
            ZipUtils.unzipIgnoreDirs(in, dir);
        }
    }

    public static void unzip(File zip, File dir, PathFilter filter) throws IOException {
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));){
            ZipUtils.unzip(in, dir, filter);
        }
    }

    public static void unzip(ZipInputStream in, File dir, PathFilter filter) throws IOException {
        if (filter == null) {
            ZipUtils.unzip(in, dir);
        } else {
            ZipUtils.unzip(in, dir, ZipUtils.toPredicate(filter), Function.identity());
        }
    }

    public static void unzip(String prefix, File zip, File dir, PathFilter filter) throws IOException {
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));){
            ZipUtils.unzip(prefix, in, dir, filter);
        }
    }

    public static void unzip(String prefix, ZipInputStream in, File dir, PathFilter filter) throws IOException {
        if (filter == null) {
            ZipUtils.unzip(prefix, in, dir);
        } else {
            ZipUtils.unzip(in, dir, ZipUtils.toPredicate(filter).and(entry -> entry.getName().startsWith(prefix)), (String name) -> name.substring(prefix.length()));
        }
    }

    private static Predicate<ZipEntry> toPredicate(PathFilter filter) {
        return entry -> filter.accept(new Path(entry.getName()));
    }

    @Deprecated
    public static InputStream getEntryContentAsStream(File file, String entryName) throws IOException {
        InputStream result = null;
        ZipFile zip = new ZipFile(file);
        ZipEntry entry = zip.getEntry(entryName);
        if (entry != null) {
            result = zip.getInputStream(entry);
        }
        return result;
    }

    @Deprecated
    public static String getEntryContentAsString(File file, String entryName) throws IOException {
        try (InputStream resultStream = ZipUtils.getEntryContentAsStream(file, entryName);){
            String string = IOUtils.toString(resultStream, StandardCharsets.UTF_8);
            return string;
        }
    }

    @Deprecated
    public static byte[] getEntryContentAsBytes(File file, String entryName) throws IOException {
        try (InputStream resultStream = ZipUtils.getEntryContentAsStream(file, entryName);){
            byte[] byArray = IOUtils.toByteArray(resultStream);
            return byArray;
        }
    }

    public static List<String> getEntryNames(File file) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                result.add(entry.getName());
            }
        }
        return result;
    }

    public static boolean hasEntry(File file, String entryName) throws IOException {
        List<String> elements = ZipUtils.getEntryNames(file);
        return elements.contains(entryName);
    }

    public static InputStream getEntryContentAsStream(InputStream stream, String entryName) throws IOException {
        ZipInputStream zip = new ZipInputStream(stream);
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            if (entry.getName().equals(entryName)) {
                return zip;
            }
            entry = zip.getNextEntry();
        }
        return null;
    }

    public static String getEntryContentAsString(InputStream stream, String searchedEntryName) throws IOException {
        try (InputStream resultStream = ZipUtils.getEntryContentAsStream(stream, searchedEntryName);){
            String string = IOUtils.toString(resultStream, StandardCharsets.UTF_8);
            return string;
        }
    }

    public static byte[] getEntryContentAsBytes(InputStream stream, String searchedEntryName) throws IOException {
        try (InputStream resultStream = ZipUtils.getEntryContentAsStream(stream, searchedEntryName);){
            byte[] byArray = IOUtils.toByteArray(resultStream);
            return byArray;
        }
    }

    public static List<String> getEntryNames(InputStream stream) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (ZipInputStream zip = new ZipInputStream(stream);){
            while (zip.available() == 1) {
                ZipEntry entry = zip.getNextEntry();
                if (entry == null) continue;
                result.add(entry.getName());
            }
        }
        return result;
    }

    public static boolean hasEntry(InputStream stream, String entryName) throws IOException {
        List<String> elements = ZipUtils.getEntryNames(stream);
        return elements.contains(entryName);
    }

    public static InputStream getEntryContentAsStream(URL url, String entryName) throws IOException {
        return ZipUtils.getEntryContentAsStream(url.openStream(), entryName);
    }

    public static String getEntryContentAsString(URL url, String entryName) throws IOException {
        try (InputStream resultStream = ZipUtils.getEntryContentAsStream(url, entryName);){
            String string = IOUtils.toString(resultStream, StandardCharsets.UTF_8);
            return string;
        }
    }

    public static byte[] getEntryContentAsBytes(URL url, String entryName) throws IOException {
        try (InputStream resultStream = ZipUtils.getEntryContentAsStream(url, entryName);){
            byte[] byArray = IOUtils.toByteArray(resultStream);
            return byArray;
        }
    }

    public static List<String> getEntryNames(URL url) throws IOException {
        return ZipUtils.getEntryNames(url.openStream());
    }

    public static boolean hasEntry(URL url, String entryName) throws IOException {
        return ZipUtils.hasEntry(url.openStream(), entryName);
    }

    public static boolean isValid(InputStream stream) {
        boolean bl;
        ZipInputStream zip = new ZipInputStream(stream);
        try {
            bl = zip.getNextEntry() != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        zip.close();
        return bl;
    }
}

