/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.CanNotReachConnectServer;
import org.nuxeo.connect.connector.ConnectConnector;
import org.nuxeo.connect.connector.ConnectSecurityError;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.connector.ConnectServerResponse;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.data.AbstractJSONSerializableData;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.data.PackageDescriptor;
import org.nuxeo.connect.data.SubscriptionStatus;
import org.nuxeo.connect.downloads.ConnectDownloadManager;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.identity.SecurityHeaderGenerator;
import org.nuxeo.connect.platform.PlatformId;
import org.nuxeo.connect.update.PackageType;

public abstract class AbstractConnectConnector
implements ConnectConnector {
    public static final String STUDIO_REGISTERED_CACHE_SUFFIX = "studio_registered";
    public static final String RENEW_REGISTRATION_SUFFIX = "remoteRenewRegistration";
    public static final String GET_DOWNLOADS_SUFFIX = "getDownloads";
    public static final String GET_DOWNLOAD_SUFFIX = "getDownload";
    public static final String GET_STATUS_SUFFIX = "status";
    public static final String NUXEO_TMP_DIR_PROPERTY = "nuxeo.tmp.dir";
    public static final String CONNECT_CONNECTOR_CACHE_MINUTES_PROPERTY = "org.nuxeo.connect.connector.cache.duration";
    public static final String DEFAULT_CACHE_TIME_MINUTES = "60";
    public static final long DEFAULT_CACHE_TIME_MS_STUDIO = 300000L;
    public static final String CONNECT_SERVER_REACHABLE_PROPERTY = "org.nuxeo.connect.server.reachable";
    private static final String CACHE_FILE_PREFIX = "pkg_cache_";
    protected static Log log = LogFactory.getLog(AbstractConnectConnector.class);

    protected String getBaseUrl() {
        if (LogicalInstanceIdentifier.isRegistered()) {
            return ConnectUrlConfig.getRegistredBaseUrl();
        }
        return ConnectUrlConfig.getUnregisteredBaseUrl();
    }

    protected File getCacheFileFor(String suffix) {
        String connectUrlString = ConnectUrlConfig.getBaseUrl();
        String cacheDir = NuxeoConnectClient.getProperty(NUXEO_TMP_DIR_PROPERTY, System.getProperty("java.io.tmpdir"));
        try {
            URL connectUrl = new URL(connectUrlString);
            String cachePrefix = CACHE_FILE_PREFIX + connectUrl.getHost() + "_";
            int port = connectUrl.getPort();
            if (port == -1) {
                port = connectUrl.getDefaultPort();
            }
            cachePrefix = port == -1 ? cachePrefix + "00_" : cachePrefix + Integer.toString(port) + "_";
            cachePrefix = cachePrefix + connectUrl.getPath().replaceAll("/", "#");
            String cacheFileName = cachePrefix + "_" + suffix + ".json";
            return new File(cacheDir, cacheFileName);
        }
        catch (MalformedURLException e) {
            String fallbackFileName = connectUrlString + "_" + suffix + ".json";
            return new File(cacheDir, fallbackFileName);
        }
    }

    @Override
    public void flushCache() {
        String cacheDir = NuxeoConnectClient.getProperty(NUXEO_TMP_DIR_PROPERTY, System.getProperty("java.io.tmpdir"));
        for (File cacheFile : FileUtils.listFiles(new File(cacheDir), new PrefixFileFilter(CACHE_FILE_PREFIX), null)) {
            FileUtils.deleteQuietly(cacheFile);
        }
    }

    protected ConnectServerResponse execCall(String url) throws ConnectServerError {
        return this.execServerCall(url, SecurityHeaderGenerator.getHeaders());
    }

    protected ConnectServerResponse execPost(String url) throws ConnectServerError {
        return this.execServerPost(url, SecurityHeaderGenerator.getHeaders());
    }

    protected abstract ConnectServerResponse execServerCall(String var1, Map<String, String> var2) throws ConnectServerError;

    protected abstract ConnectServerResponse execServerPost(String var1, Map<String, String> var2) throws ConnectServerError;

    @Override
    public SubscriptionStatus getConnectStatus() throws ConnectServerError {
        String url = this.getBaseUrl() + GET_STATUS_SUFFIX;
        ConnectServerResponse response = this.execCall(url);
        String json = response.getString();
        if (json == null) {
            throw new ConnectServerError("null response from server");
        }
        try {
            SubscriptionStatus subscriptionStatus = AbstractJSONSerializableData.loadFromJSON(SubscriptionStatus.class, json);
            return subscriptionStatus;
        }
        catch (Throwable t) {
            throw new ConnectServerError("Unable to parse response: " + json, t);
        }
        finally {
            response.release();
        }
    }

    @Override
    public DownloadingPackage getDownload(String id) throws ConnectServerError {
        if (!this.isConnectServerReachable()) {
            throw new CanNotReachConnectServer("Connect server set as not reachable");
        }
        ConnectDownloadManager cdm = NuxeoConnectClient.getDownloadManager();
        DownloadingPackage downloadingPackage = cdm.getDownloadingPackage(id);
        if (downloadingPackage != null) {
            return downloadingPackage;
        }
        try {
            id = URLEncoder.encode(id, "UTF-8");
            id = id.replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            log.error(e);
        }
        String url = this.getBaseUrl() + GET_DOWNLOAD_SUFFIX + "/" + id;
        PackageDescriptor pkg = null;
        ConnectServerResponse response = this.execCall(url);
        try {
            String json = response.getString();
            if (json == null) {
                DownloadingPackage downloadingPackage2 = null;
                return downloadingPackage2;
            }
            pkg = AbstractJSONSerializableData.loadFromJSON(PackageDescriptor.class, json);
        }
        catch (JSONException e) {
            throw new ConnectServerError("Unable to parse response", e);
        }
        finally {
            response.release();
        }
        if (pkg == null || pkg.getId() == null) {
            throw new ConnectSecurityError("Unable to parse server response: package has no id");
        }
        return cdm.storeDownloadedBundle(pkg);
    }

    @Override
    public List<DownloadablePackage> getDownloads(PackageType type) throws ConnectServerError {
        return this.getDownloads(type, null);
    }

    @Override
    public List<DownloadablePackage> getDownloads(PackageType type, PlatformId currentTargetPlatform) throws ConnectServerError {
        String fileSuffix;
        String urlSuffix = fileSuffix = String.valueOf((Object)type);
        if (currentTargetPlatform != null) {
            urlSuffix = urlSuffix + "?targetPlatform=" + currentTargetPlatform.asString();
            fileSuffix = fileSuffix + "_" + currentTargetPlatform.asString();
        }
        return this.getDownloads(fileSuffix, urlSuffix);
    }

    @Override
    public List<DownloadablePackage> getRegisteredStudio() throws ConnectServerError {
        return this.getRegisteredStudio(null);
    }

    @Override
    public List<DownloadablePackage> getRegisteredStudio(PlatformId currentTargetPlatform) throws ConnectServerError {
        String fileSuffix = STUDIO_REGISTERED_CACHE_SUFFIX;
        String urlSuffix = (Object)((Object)PackageType.STUDIO) + "?registered=true";
        if (currentTargetPlatform != null) {
            urlSuffix = urlSuffix + "&targetPlatform=" + currentTargetPlatform.asString();
            fileSuffix = fileSuffix + "_" + currentTargetPlatform.asString();
        }
        return this.getDownloads(fileSuffix, urlSuffix);
    }

    protected List<DownloadablePackage> getDownloads(String fileSuffix, String urlSuffix) throws ConnectServerError {
        List<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        if (!this.isConnectServerReachable()) {
            return result;
        }
        result = this.readCacheFile(fileSuffix);
        if (result != null) {
            log.debug("Using cache for " + fileSuffix);
            return result;
        }
        result = new ArrayList();
        log.debug("Cache empty or expired for " + fileSuffix + ". Sending request to " + this.getBaseUrl());
        String url = this.getBaseUrl() + GET_DOWNLOADS_SUFFIX + "/" + urlSuffix;
        ConnectServerResponse response = this.execCall(url);
        try {
            String json = response.getString();
            if (json != null) {
                JSONArray array = new JSONArray(json);
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject ob = (JSONObject)array.get(i);
                    result.add(AbstractJSONSerializableData.loadFromJSON(PackageDescriptor.class, ob));
                }
                this.writeCacheFile(fileSuffix, json);
            }
        }
        catch (JSONException e) {
            throw new ConnectServerError("Unable to parse response", e);
        }
        finally {
            response.release();
        }
        return result;
    }

    public void writeCacheFile(String type, String json) {
        try {
            FileUtils.writeStringToFile(this.getCacheFileFor(type), json);
        }
        catch (IOException e) {
            log.error("Could not store packages list in cache", e);
        }
    }

    public List<DownloadablePackage> readCacheFile(String suffix) {
        File cacheFile;
        long cacheMaxAge = Long.parseLong(NuxeoConnectClient.getProperty(CONNECT_CONNECTOR_CACHE_MINUTES_PROPERTY, DEFAULT_CACHE_TIME_MINUTES)) * 60L * 1000L;
        if (suffix == null || PackageType.getByValue(suffix) == PackageType.STUDIO) {
            cacheMaxAge = Math.min(cacheMaxAge, 300000L);
        }
        if (!(cacheFile = this.getCacheFileFor(suffix)).exists() || new Date().getTime() - cacheFile.lastModified() > cacheMaxAge) {
            return null;
        }
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        try {
            String json = FileUtils.readFileToString(cacheFile);
            JSONArray array = new JSONArray(json);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject ob = (JSONObject)array.get(i);
                result.add(AbstractJSONSerializableData.loadFromJSON(PackageDescriptor.class, ob));
            }
        }
        catch (IOException e) {
            log.debug(e.getMessage(), e);
        }
        catch (JSONException e) {
            log.debug(e.getMessage(), e);
        }
        return result;
    }

    protected boolean isConnectServerReachable() {
        return Boolean.parseBoolean(NuxeoConnectClient.getProperty(CONNECT_SERVER_REACHABLE_PROPERTY, "true"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String remoteRenewRegistration() throws ConnectServerError {
        String clid;
        String url = this.getBaseUrl() + RENEW_REGISTRATION_SUFFIX;
        ConnectServerResponse response = this.execPost(url);
        try {
            clid = response.getString();
        }
        finally {
            response.release();
        }
        if (clid == null) {
            throw new ConnectServerError("null response from server");
        }
        return clid;
    }
}

