/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.dependencies.DependencyException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.Version;

public class DependencyResolution {
    private static final Log log = LogFactory.getLog(DependencyResolution.class);
    protected Boolean resolution = null;
    protected boolean sorted = false;
    protected String failedMessage;
    protected Map<String, Version> allPackages = new HashMap<String, Version>();
    protected Map<String, Version> newPackagesToDownload = new HashMap<String, Version>();
    protected Map<String, Version> localPackagesToInstall = new HashMap<String, Version>();
    protected Map<String, Version> localPackagesToUpgrade = new HashMap<String, Version>();
    protected Map<String, Version> localPackagesToRemove = new HashMap<String, Version>();
    protected Map<String, Version> localUnchangedPackages = new HashMap<String, Version>();
    protected List<String> orderedInstallablePackages = new ArrayList<String>();
    protected List<String> orderedRemovablePackages = new ArrayList<String>();
    protected List<String> allPackagesToDownload = new ArrayList<String>();
    protected Map<String, Set<String>> reinstallForNewlyInstalledOptionals = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> reinstallForNewlyRemovedOptionals = new HashMap<String, Set<String>>();

    public DependencyResolution() {
    }

    public DependencyResolution(DependencyException ex) {
        this.markAsFailed(ex.getMessage());
    }

    @Deprecated
    public void markAsFailed() {
        this.resolution = false;
    }

    public void markAsFailed(String message) {
        this.resolution = false;
        this.failedMessage = message;
        log.warn(this.failedMessage);
    }

    public void markAsSuccess() {
        this.resolution = true;
    }

    public boolean isValidated() {
        if (this.resolution == null) {
            return false;
        }
        return this.resolution;
    }

    public boolean isFailed() {
        if (this.resolution == null) {
            return false;
        }
        return this.resolution == false;
    }

    public boolean addPackage(String pkgName, Version v) {
        return this.addPackage(pkgName, v, false);
    }

    public synchronized boolean addPackage(String pkgName, Version v, boolean fifo) {
        if (!this.allPackages.containsKey(pkgName)) {
            log.debug("addPackage " + pkgName + " " + v);
            this.allPackages.put(pkgName, v);
            if (fifo) {
                this.orderedInstallablePackages.add(pkgName + "-" + v.toString());
            } else {
                this.orderedInstallablePackages.add(0, pkgName + "-" + v.toString());
            }
        } else if (!this.allPackages.get(pkgName).equals(v)) {
            this.markAsFailed("addPackage conflict " + pkgName + " " + v + " with " + this.allPackages.get(pkgName));
        } else {
            log.debug("addPackage ignored " + pkgName + " " + v);
        }
        return !this.isFailed();
    }

    public boolean addUnchangedPackage(String pkgName, Version v) {
        if (!this.allPackages.containsKey(pkgName)) {
            log.debug("addPackage " + pkgName + " " + v);
            this.allPackages.put(pkgName, v);
        } else if (!this.allPackages.get(pkgName).equals(v)) {
            this.markAsFailed("addPackage conflict " + pkgName + " " + v + " with " + this.allPackages.get(pkgName));
        } else {
            log.debug("addPackage ignored " + pkgName + " " + v);
        }
        return !this.isFailed();
    }

    public void markPackageForRemoval(String pkgName, Version v) {
        this.markPackageForRemoval(pkgName, v, false);
    }

    public synchronized void markPackageForRemoval(String pkgName, Version v, boolean fifo) {
        log.debug("markPackageForRemoval " + pkgName + " " + v);
        this.localPackagesToRemove.put(pkgName, v);
        if (fifo) {
            this.orderedRemovablePackages.add(pkgName + "-" + v.toString());
        } else {
            this.orderedRemovablePackages.add(0, pkgName + "-" + v.toString());
        }
    }

    public synchronized void sort(PackageManager pm) {
        this.localPackagesToUpgrade.clear();
        this.newPackagesToDownload.clear();
        this.localPackagesToInstall.clear();
        this.localUnchangedPackages.clear();
        this.allPackagesToDownload.clear();
        for (String pkgName : this.allPackages.keySet()) {
            String id = pkgName + "-" + this.allPackages.get(pkgName).toString();
            DownloadablePackage pkg = pm.findPackageById(id);
            List<Version> installedVersions = pm.findLocalPackageInstalledVersions(pkg.getName());
            if (pkg.getPackageState().isInstalled() && !this.orderedRemovablePackages.contains(id)) {
                this.localUnchangedPackages.put(pkg.getName(), pkg.getVersion());
                continue;
            }
            if (installedVersions.size() > 0 && !installedVersions.contains(pkg.getVersion())) {
                this.localPackagesToUpgrade.put(pkg.getName(), installedVersions.get(installedVersions.size() - 1));
            }
            if (pkg.getPackageState() == PackageState.REMOTE) {
                this.newPackagesToDownload.put(pkg.getName(), pkg.getVersion());
                this.allPackagesToDownload.add(id);
                continue;
            }
            this.localPackagesToInstall.put(pkg.getName(), pkg.getVersion());
        }
        this.sorted = true;
    }

    public Map<String, Version> getNewPackagesToDownload() {
        return this.newPackagesToDownload;
    }

    public Map<String, Version> getLocalPackagesToInstall() {
        return this.localPackagesToInstall;
    }

    public Map<String, Version> getLocalPackagesToUpgrade() {
        return this.localPackagesToUpgrade;
    }

    public Map<String, Version> getLocalPackagesToRemove() {
        return this.localPackagesToRemove;
    }

    public Map<String, Version> getLocalUnchangedPackages() {
        return this.localUnchangedPackages;
    }

    public boolean requireChanges() {
        return !this.localPackagesToRemove.isEmpty() || !this.localPackagesToUpgrade.isEmpty() || !this.localPackagesToInstall.isEmpty() || !this.newPackagesToDownload.isEmpty();
    }

    public List<String> getUnchangedPackageIds() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Version> entry : this.getLocalUnchangedPackages().entrySet()) {
            res.add(entry.getKey() + "-" + entry.getValue().toString());
        }
        Collections.sort(res);
        return res;
    }

    public List<String> getUpgradePackageIds() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Version> entry : this.getLocalPackagesToUpgrade().entrySet()) {
            res.add(entry.getKey() + "-" + entry.getValue().toString());
        }
        Collections.sort(res);
        return res;
    }

    public List<String> getInstallPackageIds() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Version> entry : this.getLocalPackagesToInstall().entrySet()) {
            res.add(entry.getKey() + "-" + entry.getValue().toString());
        }
        for (Map.Entry<String, Version> entry : this.getNewPackagesToDownload().entrySet()) {
            res.add(entry.getKey() + "-" + entry.getValue().toString());
        }
        Collections.sort(res);
        return res;
    }

    public List<String> getInstallPackageNames() {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(this.getLocalPackagesToInstall().keySet());
        res.addAll(this.getNewPackagesToDownload().keySet());
        Collections.sort(res);
        return res;
    }

    public List<String> getDownloadPackageIds() {
        return this.allPackagesToDownload;
    }

    public List<String> getRemovePackageIds() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Version> entry : this.getLocalPackagesToRemove().entrySet()) {
            res.add(entry.getKey() + "-" + entry.getValue().toString());
        }
        Collections.sort(res);
        return res;
    }

    public List<String> getRemovePackageNames() {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(this.getLocalPackagesToRemove().keySet());
        Collections.sort(res);
        return res;
    }

    public List<String> getLocalToInstallIds() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Version> entry : this.getLocalPackagesToInstall().entrySet()) {
            res.add(entry.getKey() + "-" + entry.getValue().toString());
        }
        Collections.sort(res);
        return res;
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Set<String>> entry : this.reinstallForNewlyInstalledOptionals.entrySet()) {
            sb.append(String.format("\nAs package '%s' has an optional dependency on package(s) %s currently being installed, it will be reinstalled.", entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, Set<String>> entry : this.reinstallForNewlyRemovedOptionals.entrySet()) {
            sb.append(String.format("\nAs package '%s' has an optional dependency on package(s) %s currently being uninstalled, it will be reinstalled.", entry.getKey(), entry.getValue()));
        }
        if (this.isFailed()) {
            sb.append("\nFailed to resolve dependencies: ");
            sb.append(this.failedMessage);
        } else if (!this.sorted) {
            this.append(sb, this.allPackages, "\nUnsorted packages: ");
        } else if (!this.isEmpty()) {
            sb.append("\nDependency resolution:\n");
            this.append(sb, this.orderedInstallablePackages, "Installation order");
            this.append(sb, this.orderedRemovablePackages, "Uninstallation order");
            this.append(sb, this.localUnchangedPackages, "Unchanged packages");
            this.append(sb, this.localPackagesToUpgrade, "Packages to upgrade");
            this.append(sb, this.newPackagesToDownload, "Packages to download");
            this.append(sb, this.localPackagesToInstall, "Local packages to install");
            this.append(sb, this.localPackagesToRemove, "Local packages to remove");
        } else {
            sb.append("\nDependency resolution:\n");
            this.append(sb, this.localUnchangedPackages, "Unchanged packages");
        }
        return sb.toString();
    }

    private StringBuffer append(StringBuffer sb, Map<String, Version> pkgMap, String title) {
        if (!pkgMap.isEmpty()) {
            this.append(sb, title, pkgMap.size());
            for (String pkgName : pkgMap.keySet()) {
                sb.append(pkgName);
                sb.append(":");
                sb.append(pkgMap.get(pkgName).toString());
                sb.append(", ");
            }
            sb.replace(sb.length() - 2, sb.length(), "\n");
        }
        return sb;
    }

    private StringBuffer append(StringBuffer sb, List<String> pkgList, String title) {
        if (!pkgList.isEmpty()) {
            this.append(sb, title, pkgList.size());
            for (String pkg : pkgList) {
                sb.append(pkg + "/");
            }
            sb.replace(sb.length() - 1, sb.length(), "\n");
        }
        return sb;
    }

    private void append(StringBuffer sb, String title, int size) {
        if (title.length() > 0) {
            sb.append(String.format("  %-30s ", title + " (" + size + "):"));
        }
    }

    public synchronized String getInstallationOrderAsString() {
        return this.removeLineReturn(this.append(new StringBuffer(), this.orderedInstallablePackages, ""));
    }

    private String removeLineReturn(StringBuffer sb) {
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    public synchronized List<String> getOrderedPackageIdsToInstall() {
        return this.orderedInstallablePackages;
    }

    public synchronized List<String> getOrderedPackageIdsToRemove() {
        return this.orderedRemovablePackages;
    }

    public String getAllPackagesToDownloadAsString() {
        return this.removeLineReturn(this.append(new StringBuffer(), this.allPackagesToDownload, ""));
    }

    public int getNbPackagesToDownload() {
        return this.allPackagesToDownload.size();
    }

    public boolean isEmpty() {
        if (!this.sorted) {
            return this.allPackages.isEmpty();
        }
        return this.orderedInstallablePackages.isEmpty() && this.orderedRemovablePackages.isEmpty() && this.newPackagesToDownload.isEmpty() && this.localPackagesToInstall.isEmpty() && this.localPackagesToUpgrade.isEmpty();
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void addReinstallForNewlyInstalledOptional(String installedPkgId, String optDepToInsallId) {
        this.reinstallForNewlyInstalledOptionals.computeIfAbsent(installedPkgId, k -> new HashSet()).add(optDepToInsallId);
    }

    public void addReinstallForNewlyRemovedOptional(String installedPkgId, String optDepToRemoveId) {
        this.reinstallForNewlyRemovedOptionals.computeIfAbsent(installedPkgId, k -> new HashSet()).add(optDepToRemoveId);
    }
}

