/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.platform.PlatformId;
import org.nuxeo.connect.platform.PlatformVersionRange;
import org.nuxeo.connect.update.Package;

public class TargetPlatformFilterHelper {
    protected static Log log = LogFactory.getLog(TargetPlatformFilterHelper.class);

    public static boolean isCompatibleWithTargetPlatform(Package pkg, PlatformId targetPlatform) {
        if (targetPlatform == null) {
            return true;
        }
        if (StringUtils.isBlank(pkg.getTargetPlatformRange()) || StringUtils.isBlank(pkg.getTargetPlatformName())) {
            return TargetPlatformFilterHelper.isCompatibleWithTargetPlatform(pkg.getTargetPlatforms(), targetPlatform);
        }
        try {
            PlatformVersionRange pkgAllowedTpRange = PlatformVersionRange.fromRangeSpec(pkg.getTargetPlatformRange());
            return pkgAllowedTpRange.containsVersion(targetPlatform.version()) && pkg.getTargetPlatformName().equalsIgnoreCase(targetPlatform.name());
        }
        catch (IllegalArgumentException e) {
            log.warn(String.format("Could not parse target platform range expression '%s' for package '%s', using former compatibility format.", pkg.getTargetPlatformRange(), pkg.getId()), e);
            return TargetPlatformFilterHelper.isCompatibleWithTargetPlatform(pkg.getTargetPlatforms(), targetPlatform);
        }
    }

    private static boolean isCompatibleWithTargetPlatform(String[] targetPlatforms, PlatformId targetPlatform) {
        if (targetPlatforms == null || targetPlatforms.length == 0) {
            return true;
        }
        Set<String> possibleStringForms = TargetPlatformFilterHelper.getPossibleStringForms(targetPlatform);
        for (String target : targetPlatforms) {
            if (!possibleStringForms.stream().anyMatch(tpString -> FilenameUtils.wildcardMatch(tpString, target, IOCase.INSENSITIVE))) continue;
            return true;
        }
        return false;
    }

    protected static Set<String> getPossibleStringForms(PlatformId targetPlatform) {
        HashSet<String> result = new HashSet<String>();
        String defaultAsString = targetPlatform.asString();
        result.add(defaultAsString);
        if (targetPlatform.version().getBuildNumber() == 0) {
            String qualifier = targetPlatform.version().getQualifier();
            boolean hasQualifier = StringUtils.isNotBlank(qualifier);
            String qualifierSuffix = hasQualifier ? "-" + qualifier : "";
            String noQualifier = StringUtils.removeEnd(defaultAsString, qualifierSuffix);
            String with0BuildNumber = noQualifier + ".0" + qualifierSuffix;
            result.add(with0BuildNumber);
            if (targetPlatform.version().getMinorVersion() == 0) {
                String without0Minor = StringUtils.removeEnd(noQualifier, ".0") + qualifierSuffix;
                result.add(without0Minor);
            }
        }
        return result;
    }
}

