/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.platform;

import org.nuxeo.connect.platform.PlatformVersion;

public class PlatformId {
    private final String name;
    private final PlatformVersion version;

    PlatformId(String name, PlatformVersion version) {
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        this.name = name;
        if (version == null) {
            throw new NullPointerException("Null version");
        }
        this.version = version;
    }

    public String name() {
        return this.name;
    }

    public PlatformVersion version() {
        return this.version;
    }

    public String toString() {
        return "PlatformId{name=" + this.name + ", version=" + this.version + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PlatformId) {
            PlatformId that = (PlatformId)o;
            return this.name.equals(that.name()) && this.version.equals(that.version());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        return h$ ^= this.version.hashCode();
    }

    public static PlatformId parse(String id) {
        return PlatformId.parseWithHyphen(id, id.lastIndexOf(45));
    }

    private static PlatformId parseWithHyphen(String id, int lastHyphenIdx) {
        if (lastHyphenIdx == -1) {
            throw new IllegalArgumentException("Bad platform id: " + id);
        }
        String name = id.substring(0, lastHyphenIdx);
        String version = id.substring(lastHyphenIdx + 1);
        try {
            return PlatformId.parse(name, version);
        }
        catch (RuntimeException e) {
            return PlatformId.parseWithHyphen(id, id.substring(0, lastHyphenIdx).lastIndexOf(45));
        }
    }

    public static PlatformId parse(String name, String version) {
        return PlatformId.of(name, new PlatformVersion(version));
    }

    public static PlatformId of(String name, PlatformVersion version) {
        return new PlatformId(name, version);
    }

    public String asString() {
        return this.name() + "-" + this.version().asString();
    }
}

