/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.platform;

import java.util.Locale;

public class PlatformVersion
implements Comparable<PlatformVersion> {
    public static final int MAX_VERSION_PART_VALUE = 9999;
    private Integer majorVersion;
    private Integer minorVersion;
    private Integer buildNumber;
    private String qualifier;
    private String comparable;

    public PlatformVersion(String version) {
        this.parseVersion(version);
    }

    public int hashCode() {
        return this.comparable.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlatformVersion)) {
            return false;
        }
        return this.compareTo((PlatformVersion)other) == 0;
    }

    @Override
    public int compareTo(PlatformVersion otherVersion) {
        return this.comparable.compareTo(otherVersion.comparable);
    }

    public int getMajorVersion() {
        return this.majorVersion != null ? this.majorVersion : 0;
    }

    public int getMinorVersion() {
        return this.minorVersion != null ? this.minorVersion : 0;
    }

    public int getBuildNumber() {
        return this.buildNumber != null ? this.buildNumber : 0;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getComparable() {
        return this.comparable != null ? this.comparable : "0";
    }

    public final void parseVersion(String version) {
        if (PlatformVersion.isBlank(version)) {
            throw new IllegalArgumentException("Version cannot be blank");
        }
        if (version.contains(",") || version.contains("[") || version.contains("]") || version.contains("(") || version.contains(")")) {
            throw new IllegalArgumentException("Version cannot contain commas (','), brackets ('[]') or parenthesis ('()'): " + version);
        }
        String[] parts = version.split("-", -1);
        String[] versionParts = parts[0].split("\\.");
        if (!PlatformVersion.isDigits(versionParts[0].trim())) {
            throw new IllegalArgumentException("Version should at least explicit a major number: " + version);
        }
        this.majorVersion = PlatformVersion.tryParseVersionPartInt(versionParts[0].trim());
        if (versionParts.length >= 2) {
            this.minorVersion = PlatformVersion.tryParseVersionPartInt(versionParts[1].trim());
        }
        if (versionParts.length >= 3) {
            this.buildNumber = PlatformVersion.tryParseVersionPartInt(versionParts[2].trim());
        }
        if (versionParts.length >= 4) {
            // empty if block
        }
        if (parts.length >= 2) {
            String trimmedQualifier = version.substring(version.indexOf("-") + 1).trim();
            if (PlatformVersion.containsWhitespace(trimmedQualifier)) {
                throw new IllegalArgumentException("Version cannot contain whitespaces in qualifier: " + version);
            }
            this.qualifier = trimmedQualifier;
        }
        this.comparable = PlatformVersion.computeComparable(this);
    }

    public static String computeComparable(PlatformVersion version) {
        StringBuilder builder = new StringBuilder();
        builder.append(PlatformVersion.formatOn4Digits(version.getMajorVersion())).append(".").append(PlatformVersion.formatOn4Digits(version.getMinorVersion())).append(".").append(PlatformVersion.formatOn4Digits(version.getBuildNumber()));
        String qualifier = version.getQualifier();
        if (!PlatformVersion.isBlank(qualifier)) {
            builder.append("-").append(qualifier.toUpperCase(Locale.ROOT));
        }
        return builder.toString();
    }

    private static String formatOn4Digits(int number) {
        String result = "" + number;
        while (result.length() < 4) {
            result = "0" + result;
        }
        return result;
    }

    private static Integer tryParseVersionPartInt(String s) {
        if (!PlatformVersion.isDigits(s)) {
            return null;
        }
        try {
            long longValue = Long.parseLong(s);
            if (longValue > 9999L) {
                return null;
            }
            return (int)longValue;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.asString());
        builder.append(" (").append(this.comparable).append(")");
        return builder.toString();
    }

    public String asString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getMajorVersion()).append(".").append(this.getMinorVersion());
        if (this.getBuildNumber() > 0) {
            builder.append(".").append(this.getBuildNumber());
        }
        if (!PlatformVersion.isBlank(this.qualifier)) {
            builder.append("-").append(this.qualifier);
        }
        return builder.toString();
    }

    public boolean isEqualTo(PlatformVersion otherVersion) {
        return this.compareTo(otherVersion) == 0;
    }

    public boolean isBeforeIncluding(PlatformVersion otherVersion) {
        return this.compareTo(otherVersion) <= 0;
    }

    public boolean isAfterIncluding(PlatformVersion otherVersion) {
        return this.compareTo(otherVersion) >= 0;
    }

    public boolean isBefore(PlatformVersion otherVersion) {
        return this.compareTo(otherVersion) < 0;
    }

    public boolean isAfter(PlatformVersion otherVersion) {
        return this.compareTo(otherVersion) > 0;
    }

    public boolean isBetween(PlatformVersion left, PlatformVersion right) {
        return this.isAfter(left) && this.isBefore(right);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsWhitespace(CharSequence seq) {
        if (seq == null) {
            return false;
        }
        int strLen = seq.length();
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(seq.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isDigits(CharSequence cs) {
        if (cs == null || cs.length() == 0) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

