/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.standalone;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Command;
import org.nuxeo.connect.update.task.standalone.AbstractTask;
import org.nuxeo.connect.update.xml.XmlWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class CommandsTask
extends AbstractTask {
    protected final List<Command> commands = new ArrayList<Command>();
    protected final LinkedList<Command> commandLog = new LinkedList();

    public CommandsTask(PackageUpdateService pus) {
        super(pus);
    }

    protected abstract File getCommandsFile() throws PackageException;

    @Override
    public void initialize(LocalPackage pkg, boolean restart) throws PackageException {
        super.initialize(pkg, restart);
        this.loadCommands();
    }

    protected void loadCommands() throws PackageException {
        try {
            String content = this.loadParametrizedFile(this.getCommandsFile(), this.env);
            StringReader reader = new StringReader(content);
            this.readLog(reader);
        }
        catch (IOException e) {
            throw new PackageException("Failed to load commands file", e);
        }
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public List<Command> getCommandLog() {
        return this.commandLog;
    }

    public void addCommand(Command command) {
        this.commands.add(command);
    }

    @Override
    protected void doRun(Map<String, String> params) throws PackageException {
        for (Command cmd : this.commands) {
            Command rollbackCmd = cmd.run(this, params);
            if (rollbackCmd == null) continue;
            if (rollbackCmd.isPostInstall()) {
                this.commandLog.add(rollbackCmd);
                continue;
            }
            this.commandLog.addFirst(rollbackCmd);
        }
        this.flush();
    }

    protected abstract void flush() throws PackageException;

    @Override
    protected void doRollback() throws PackageException {
        while (!this.commandLog.isEmpty()) {
            this.commandLog.removeFirst().run(this, null);
        }
    }

    @Override
    public void doValidate(ValidationStatus status) throws PackageException {
        for (Command cmd : this.commands) {
            cmd.validate(this, status);
        }
    }

    public void writeLog(File file) throws PackageException {
        XmlWriter writer = new XmlWriter();
        writer.start("uninstall");
        writer.startContent();
        for (Command cmd : this.commandLog) {
            cmd.writeTo(writer);
        }
        writer.end("uninstall");
        try {
            String content = this.parametrizePaths(writer.toString());
            content = content.replace(File.separator.concat(File.separator), File.separator);
            FileUtils.writeStringToFile(file, content, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new PackageException("Failed to write commands", e);
        }
    }

    public String parametrizePaths(String content) {
        return content.replace(this.serverPathPrefix, "${env.server.home}/");
    }

    public void readLog(Reader reader) throws PackageException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(reader));
            Element root = document.getDocumentElement();
            for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String id = node.getNodeName();
                Command cmd = this.service.getCommand(id);
                if (cmd == null) {
                    try {
                        cmd = (Command)this.pkg.getData().loadClass(id).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (ReflectiveOperationException t) {
                        throw new PackageException("Unknown command: " + id);
                    }
                }
                cmd.initialize(element);
                cmd.setPackageUpdateService(this.service);
                this.commands.add(cmd);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new PackageException("Failed to read commands", e);
        }
    }
}

