/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.xml;

import org.apache.commons.lang3.mutable.MutableObject;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.connect.data.PackageDescriptor;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.model.PackageDefinition;
import org.nuxeo.connect.update.model.TaskDefinition;
import org.nuxeo.connect.update.xml.TaskDefinitionImpl;
import org.nuxeo.connect.update.xml.XmlSerializer;
import org.nuxeo.connect.update.xml.XmlWriter;

@XObject(value="package")
public class PackageDefinitionImpl
implements PackageDefinition {
    @XNode(value="@name")
    protected String name;
    @XNode(value="@version")
    protected Version version;
    @XNode(value="@type")
    protected PackageType type;
    @XNode(value="title")
    protected String title;
    @XNode(value="description")
    protected String description;
    @XNode(value="classifier")
    protected String classifier;
    @XNode(value="vendor")
    protected String vendor;
    @XNode(value="hotreload-support")
    protected boolean hotReloadSupport = false;
    @XNode(value="require-terms-and-conditions-acceptance")
    protected boolean requireTermsAndConditionsAcceptance = false;
    @XNode(value="license")
    protected String license;
    @XNode(value="license-url")
    protected String licenseUrl;
    protected String[] platforms;
    @XNode(value="target-platform/version")
    protected String targetPlatformRange;
    @XNode(value="target-platform/name")
    protected String targetPlatformName;
    @XNodeList(value="dependencies/package", type=PackageDependency[].class, componentType=PackageDependency.class)
    protected PackageDependency[] dependencies;
    @XNodeList(value="optional-dependencies/package", type=PackageDependency[].class, componentType=PackageDependency.class)
    protected PackageDependency[] optionalDependencies;
    @XNodeList(value="conflicts/package", type=PackageDependency[].class, componentType=PackageDependency.class)
    protected PackageDependency[] conflicts;
    @XNodeList(value="provides/package", type=PackageDependency[].class, componentType=PackageDependency.class)
    protected PackageDependency[] provides;
    @XNode(value="installer")
    protected TaskDefinitionImpl installer;
    @XNode(value="uninstaller")
    protected TaskDefinitionImpl uninstaller;
    @XNode(value="validator")
    protected String validator;

    @Override
    public String getId() {
        if (this.version == null) {
            return this.name;
        }
        return this.name + "-" + this.version.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.dependencies = PackageDescriptor.fixDependencies(name, this.dependencies);
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public PackageType getType() {
        return this.type;
    }

    @Override
    public void setType(PackageType type) {
        this.type = type;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    @Override
    @Deprecated
    public String getLicense() {
        return this.getLicenseType();
    }

    @Override
    public String getLicenseType() {
        return this.license;
    }

    @Override
    @Deprecated
    public void setLicense(String license) {
        this.setLicenseType(license);
    }

    @Override
    public void setLicenseType(String license) {
        this.license = license;
    }

    @Override
    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    @Override
    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    @Override
    @Deprecated
    public String[] getPlatforms() {
        return this.getTargetPlatforms();
    }

    @Override
    public String[] getTargetPlatforms() {
        return this.platforms;
    }

    @Override
    @Deprecated
    public void setPlatforms(String[] platforms) {
        this.setTargetPlatforms(platforms);
    }

    @Override
    @XNodeList(value="platforms/platform", type=String[].class, componentType=String.class)
    public void setTargetPlatforms(String[] platforms) {
        MutableObject packageDependencies = new MutableObject();
        this.platforms = PackageDescriptor.fixTargetPlatforms(this.name, platforms, packageDependencies);
        this.setDependencies((PackageDependency[])packageDependencies.getValue());
    }

    @Override
    public String getTargetPlatformRange() {
        return this.targetPlatformRange;
    }

    @Override
    public void setTargetPlatformRange(String targetPlatformRange) {
        this.targetPlatformRange = targetPlatformRange;
    }

    @Override
    public String getTargetPlatformName() {
        return this.targetPlatformName;
    }

    @Override
    public void setTargetPlatformName(String targetPlatformName) {
        this.targetPlatformName = targetPlatformName;
    }

    @Override
    public PackageDependency[] getDependencies() {
        return this.dependencies;
    }

    @Override
    public void setDependencies(PackageDependency[] dependencies) {
        this.dependencies = PackageDescriptor.addPackageDependencies(this.dependencies, dependencies);
    }

    @Override
    public PackageDependency[] getOptionalDependencies() {
        return this.optionalDependencies;
    }

    @Override
    public void setOptionalDependencies(PackageDependency[] optionalDependencies) {
        this.optionalDependencies = optionalDependencies;
    }

    @Override
    public PackageDependency[] getConflicts() {
        return this.conflicts;
    }

    @Override
    public void setConflicts(PackageDependency[] conflicts) {
        this.conflicts = conflicts;
    }

    @Override
    public PackageDependency[] getProvides() {
        return this.provides;
    }

    @Override
    public void setProvides(PackageDependency[] provides) {
        this.provides = provides;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    @Override
    public TaskDefinition getInstaller() {
        return this.installer;
    }

    @Override
    public void setInstaller(TaskDefinition installer) {
        this.installer = installer instanceof TaskDefinitionImpl ? (TaskDefinitionImpl)installer : new TaskDefinitionImpl(installer.getType(), installer.getRequireRestart());
    }

    @Override
    public TaskDefinition getUninstaller() {
        return this.uninstaller;
    }

    @Override
    public void setUninstaller(TaskDefinition uninstaller) {
        this.uninstaller = uninstaller instanceof TaskDefinitionImpl ? (TaskDefinitionImpl)uninstaller : new TaskDefinitionImpl(uninstaller.getType(), uninstaller.getRequireRestart());
    }

    @Override
    public String getValidator() {
        return this.validator;
    }

    @Override
    public void setValidator(String validator) {
        this.validator = validator;
    }

    @Override
    public void setHotReloadSupport(boolean hotReloadSupport) {
        this.hotReloadSupport = hotReloadSupport;
    }

    @Deprecated
    public void write(XmlWriter writer) {
        writer.writeXmlDecl();
        writer.start("package");
        writer.attr("name", this.name);
        if (this.version != null) {
            writer.attr("version", this.version.toString());
        }
        if (this.type != null) {
            writer.attr("type", this.type.getValue());
        }
        writer.startContent();
        writer.element("title", this.title);
        writer.element("description", this.description);
        writer.element("classifier", this.classifier);
        writer.element("vendor", this.vendor);
        writer.element("license", this.license);
        writer.element("license-url", this.licenseUrl);
        writer.element("hotreload-support", Boolean.valueOf(this.hotReloadSupport).toString());
        writer.element("require-terms-and-conditions-acceptance", Boolean.valueOf(this.requireTermsAndConditionsAcceptance).toString());
        if (this.platforms != null) {
            writer.start("platforms");
            writer.startContent();
            for (String string : this.platforms) {
                writer.element("platform", string);
            }
            writer.end("platforms");
        }
        if (this.dependencies != null) {
            writer.start("dependencies");
            writer.startContent();
            for (PackageDependency packageDependency : this.dependencies) {
                writer.element("package", packageDependency.toString());
            }
            writer.end("dependencies");
        }
        if (this.optionalDependencies != null) {
            writer.start("optional-dependencies");
            writer.startContent();
            for (PackageDependency packageDependency : this.optionalDependencies) {
                writer.element("package", packageDependency.toString());
            }
            writer.end("optional-dependencies");
        }
        if (this.installer != null) {
            writer.start("installer");
            writer.attr("class", this.installer.getType());
            writer.attr("restart", String.valueOf(this.installer.getRequireRestart()));
            writer.end();
        }
        if (this.uninstaller != null) {
            writer.start("uninstaller");
            writer.attr("class", this.uninstaller.getType());
            writer.attr("restart", String.valueOf(this.uninstaller.getRequireRestart()));
            writer.end();
        }
        writer.element("validator", this.validator);
        writer.end("package");
    }

    @Override
    public boolean supportsHotReload() {
        return this.hotReloadSupport;
    }

    @Override
    public void setRequireTermsAndConditionsAcceptance(boolean requireTermsAndConditionsAcceptance) {
        this.requireTermsAndConditionsAcceptance = requireTermsAndConditionsAcceptance;
    }

    @Override
    public boolean requireTermsAndConditionsAcceptance() {
        return this.requireTermsAndConditionsAcceptance;
    }

    @Override
    public String toXML() {
        return new XmlSerializer().toXML(this);
    }

    @Override
    @Deprecated
    public int getState() {
        return PackageState.UNKNOWN.getValue();
    }

    @Override
    public PackageState getPackageState() {
        return PackageState.UNKNOWN;
    }

    @Override
    public boolean isLocal() {
        throw new UnsupportedOperationException();
    }
}

