/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.daemon;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private static final AtomicInteger count = new AtomicInteger(0);
    private final String basename;
    private final boolean daemon;

    public DaemonThreadFactory(String basename) {
        this(basename, true);
    }

    public DaemonThreadFactory(String basename, boolean daemon) {
        this.basename = basename;
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable, this.basename + "-" + count.getAndIncrement());
        thread.setDaemon(this.daemon);
        return thread;
    }
}

