/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.common.function.ThrowableRunnable;
import org.nuxeo.common.function.ThrowableSupplier;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.DefaultServiceProvider;
import org.nuxeo.runtime.api.ServiceProvider;
import org.nuxeo.runtime.api.SharedResourceLoader;
import org.nuxeo.runtime.api.login.LoginAs;
import org.nuxeo.runtime.api.login.LoginService;
import org.nuxeo.runtime.api.login.NuxeoLoginContext;
import org.nuxeo.runtime.trackers.files.FileEvent;

public final class Framework {
    private static final Log log = LogFactory.getLog(Framework.class);
    public static final String NUXEO_DEV_SYSTEM_PROP = "org.nuxeo.dev";
    public static final String NUXEO_TESTING_SYSTEM_PROP = "org.nuxeo.runtime.testing";
    @Deprecated(since="9.1")
    public static final String NUXEO_STRICT_RUNTIME_SYSTEM_PROP = "org.nuxeo.runtime.strict";
    private static RuntimeService runtime;
    private static final ListenerList listeners;
    protected static SharedResourceLoader resourceLoader;
    protected static Boolean isOSGiServiceSupported;

    private Framework() {
    }

    public static void initialize(RuntimeService runtimeService) {
        if (runtime != null) {
            throw new RuntimeServiceException("Nuxeo Framework was already initialized");
        }
        runtime = runtimeService;
        Framework.reloadResourceLoader();
        runtime.start();
    }

    public static void reloadResourceLoader() {
        URL url;
        File rs = new File(Environment.getDefault().getData(), "resources");
        rs.mkdirs();
        try {
            url = rs.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeServiceException(e);
        }
        resourceLoader = new SharedResourceLoader(new URL[]{url}, Framework.class.getClassLoader());
    }

    public static void reloadResourceLoader(List<URL> urlsToAdd, List<URL> urlsToRemove) {
        URL url;
        File rs = new File(Environment.getDefault().getData(), "resources");
        rs.mkdirs();
        URL[] existing = null;
        if (resourceLoader != null) {
            existing = resourceLoader.getURLs();
        }
        try {
            url = rs.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeServiceException(e);
        }
        SharedResourceLoader loader = new SharedResourceLoader(new URL[]{url}, Framework.class.getClassLoader());
        if (existing != null) {
            for (URL oldURL : existing) {
                if (urlsToRemove != null && urlsToRemove.contains(oldURL)) continue;
                loader.addURL(oldURL);
            }
        }
        if (urlsToAdd != null) {
            for (URL newURL : urlsToAdd) {
                loader.addURL(newURL);
            }
        }
        if (resourceLoader != null) {
            try {
                resourceLoader.close();
            }
            catch (IOException e) {
                log.error("Failed to close previous resource loader", e);
            }
        }
        resourceLoader = loader;
    }

    public static void shutdown() throws InterruptedException {
        if (runtime == null) {
            throw new IllegalStateException("runtime not exist");
        }
        try {
            runtime.stop();
        }
        finally {
            runtime = null;
        }
    }

    public static synchronized boolean isInitialized() {
        return runtime != null;
    }

    public static SharedResourceLoader getResourceLoader() {
        return resourceLoader;
    }

    public static RuntimeService getRuntime() {
        return runtime;
    }

    public static <T> T getService(Class<T> serviceClass) {
        ServiceProvider provider = DefaultServiceProvider.getProvider();
        if (provider != null) {
            return provider.getService(serviceClass);
        }
        Framework.checkRuntimeInitialized();
        return runtime.getService(serviceClass);
    }

    @Deprecated(since="9.10")
    public static <T> T getLocalService(Class<T> serviceClass) {
        return Framework.getService(serviceClass);
    }

    public static void doPrivileged(Runnable runnable) {
        Framework.loginAndDo(Framework::loginSystem, () -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T doPrivileged(Supplier<T> supplier) {
        return (T)Framework.loginAndDo(Framework::loginSystem, supplier::get);
    }

    public static <E extends Throwable> void doPrivilegedThrowing(ThrowableRunnable<E> runnable) throws E {
        Framework.loginAndDo(Framework::loginSystem, runnable.toThrowableSupplier());
    }

    public static <T, E extends Throwable> T doPrivilegedThrowing(ThrowableSupplier<T, E> supplier) throws E {
        return Framework.loginAndDo(Framework::loginSystem, supplier);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static <T, E extends Throwable> T loginAndDo(ThrowableSupplier<NuxeoLoginContext, LoginException> authSupplier, ThrowableSupplier<T, E> supplier) throws E {
        try (NuxeoLoginContext loginContext = authSupplier.get();){
            T t = supplier.get();
            return t;
        }
        catch (LoginException e) {
            throw new RuntimeServiceException(e);
        }
    }

    public static NuxeoLoginContext loginSystem() {
        Framework.checkRuntimeInitialized();
        LoginService loginService = runtime.getService(LoginService.class);
        return loginService.login();
    }

    public static NuxeoLoginContext loginSystem(String originatingUser) {
        Framework.checkRuntimeInitialized();
        LoginService loginService = runtime.getService(LoginService.class);
        return loginService.loginAs(originatingUser);
    }

    public static NuxeoLoginContext loginUser(String username) throws LoginException {
        Framework.checkRuntimeInitialized();
        return Framework.getService(LoginAs.class).loginAs(username);
    }

    @Deprecated
    public static LoginContext login() throws LoginException {
        return Framework.loginSystem();
    }

    @Deprecated
    public static LoginContext loginAs(String originatingUser) throws LoginException {
        return Framework.loginSystem(originatingUser);
    }

    @Deprecated
    public static LoginContext loginAsUser(String username) throws LoginException {
        return Framework.loginUser(username);
    }

    @Deprecated
    public static LoginContext login(String username, Object password) throws LoginException {
        return Framework.loginUser(username);
    }

    public static void sendEvent(RuntimeServiceEvent event) {
        Object[] listenersArray;
        for (Object listener : listenersArray = listeners.getListeners()) {
            ((RuntimeServiceListener)listener).handleEvent(event);
        }
    }

    public static void addListener(RuntimeServiceListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(RuntimeServiceListener listener) {
        listeners.remove(listener);
    }

    public static String getProperty(String key) {
        return Framework.getProperty(key, null);
    }

    public static String getProperty(String key, String defValue) {
        Framework.checkRuntimeInitialized();
        return runtime.getProperty(key, defValue);
    }

    public static Properties getProperties() {
        Framework.checkRuntimeInitialized();
        return runtime.getProperties();
    }

    public static String expandVars(String expression) {
        Framework.checkRuntimeInitialized();
        return runtime.expandVars(expression);
    }

    public static boolean isOSGiServiceSupported() {
        if (isOSGiServiceSupported == null) {
            isOSGiServiceSupported = Framework.isBooleanPropertyTrue("ecr.osgi.services");
        }
        return isOSGiServiceSupported;
    }

    public static boolean isDevModeSet() {
        return Framework.isBooleanPropertyTrue(NUXEO_DEV_SYSTEM_PROP);
    }

    public static boolean isTestModeSet() {
        return Framework.isBooleanPropertyTrue(NUXEO_TESTING_SYSTEM_PROP);
    }

    public static boolean isBooleanPropertyFalse(String propName) {
        String v = Framework.getProperty(propName);
        if (v == null) {
            v = System.getProperty(propName);
        }
        if (StringUtils.isBlank(v)) {
            return false;
        }
        return !Boolean.parseBoolean(v);
    }

    public static boolean isBooleanPropertyTrue(String propName) {
        String v = Framework.getProperty(propName);
        if (v == null) {
            v = System.getProperty(propName);
        }
        return Boolean.parseBoolean(v);
    }

    public static void trackFile(File file, Object marker) {
        FileEvent.onFile(Framework.class, file, marker).send();
    }

    protected static void checkRuntimeInitialized() {
        if (runtime == null) {
            throw new IllegalStateException("Runtime not initialized");
        }
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        try {
            return File.createTempFile(prefix, suffix, Framework.getTempDir());
        }
        catch (IOException e) {
            throw new IOException("Could not create temp file in " + Framework.getTempDir(), e);
        }
    }

    private static File getTempDir() {
        Environment env = Environment.getDefault();
        File temp = env != null ? env.getTemp() : new File(System.getProperty("nuxeo.tmp.dir", System.getProperty("java.io.tmpdir")));
        temp.mkdirs();
        return temp;
    }

    public static Path createTempFilePath(String prefix, String suffix, FileAttribute<?> ... attrs) throws IOException {
        try {
            return Files.createTempFile(Framework.getTempDir().toPath(), prefix, suffix, attrs);
        }
        catch (IOException e) {
            throw new IOException("Could not create temp file in " + Framework.getTempDir(), e);
        }
    }

    public static Path createTempDirectory(String prefix, FileAttribute<?> ... attrs) throws IOException {
        try {
            return Files.createTempDirectory(Framework.getTempDir().toPath(), prefix, attrs);
        }
        catch (IOException e) {
            throw new IOException("Could not create temp directory in " + Framework.getTempDir(), e);
        }
    }

    static {
        listeners = new ListenerList();
    }
}

