/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api.login;

import java.lang.reflect.Constructor;
import java.security.Principal;
import java.util.Collections;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.nuxeo.runtime.api.login.LoginComponent;
import sun.reflect.ReflectionFactory;

public class NuxeoLoginContext
extends LoginContext
implements AutoCloseable {
    protected Principal principal;
    protected Subject subject;
    protected boolean loggedIn;
    private static final Constructor<?> BARE_CONSTRUCTOR;

    public NuxeoLoginContext() throws LoginException {
        super(NuxeoLoginContext.error());
    }

    private static String error() {
        throw new UnsupportedOperationException("must use create() method");
    }

    public static NuxeoLoginContext create(Principal principal) {
        NuxeoLoginContext loginContext;
        try {
            loginContext = (NuxeoLoginContext)BARE_CONSTRUCTOR.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        loginContext.setPrincipal(principal);
        return loginContext;
    }

    protected void setPrincipal(Principal principal) {
        this.principal = principal;
        this.subject = new Subject(true, Collections.singleton(principal), Collections.emptySet(), Collections.emptySet());
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public void login() {
        if (!this.loggedIn) {
            LoginComponent.pushPrincipal(this.principal);
            this.loggedIn = true;
        }
    }

    @Override
    public void logout() {
        this.close();
    }

    @Override
    public void close() {
        if (this.loggedIn) {
            LoginComponent.popPrincipal();
            this.loggedIn = false;
        }
    }

    static {
        try {
            Class<NuxeoLoginContext> klass = NuxeoLoginContext.class;
            BARE_CONSTRUCTOR = ReflectionFactory.getReflectionFactory().newConstructorForSerialization(klass, Object.class.getDeclaredConstructor(new Class[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

