/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.osgi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.Environment;
import org.nuxeo.common.codec.CryptoProperties;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.runtime.AbstractRuntimeService;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.impl.ComponentPersistence;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.osgi.OSGiRuntimeContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class OSGiRuntimeService
extends AbstractRuntimeService
implements FrameworkListener {
    public static final ComponentName FRAMEWORK_STARTED_COMP = new ComponentName("org.nuxeo.runtime.started");
    public static final String PROP_HOME_DIR = "org.nuxeo.runtime.home";
    public static final String PROP_INSTALL_DIR = "INSTALL_DIR";
    public static final String PROP_CONFIG_DIR = "CONFIG_DIR";
    public static final String PROP_HOST_ADAPTER = "HOST_ADAPTER";
    public static final String PROP_NUXEO_BIND_ADDRESS = "nuxeo.bind.address";
    public static final String NAME = "OSGi NXRuntime";
    public static final Version VERSION = Version.parseString("1.4.0");
    private static final Logger log = LogManager.getLogger(OSGiRuntimeService.class);
    private final BundleContext bundleContext;
    private final Map<String, RuntimeContext> contexts;
    private boolean appStarted = false;
    final Map<String, Bundle> bundles;
    final ComponentPersistence persistence;

    public OSGiRuntimeService(BundleContext context) {
        this(new OSGiRuntimeContext(context.getBundle()), context);
    }

    public OSGiRuntimeService(OSGiRuntimeContext runtimeContext, BundleContext context) {
        super(runtimeContext);
        this.bundleContext = context;
        this.bundles = new ConcurrentHashMap<String, Bundle>();
        this.contexts = new ConcurrentHashMap<String, RuntimeContext>();
        String bindAddress = context.getProperty(PROP_NUXEO_BIND_ADDRESS);
        if (bindAddress != null) {
            this.properties.put(PROP_NUXEO_BIND_ADDRESS, bindAddress);
        }
        String homeDir = this.getProperty(PROP_HOME_DIR);
        log.debug("Home directory: {}", (Object)homeDir);
        this.workingDir = homeDir != null ? new File(homeDir) : this.bundleContext.getDataFile("/");
        Environment env = Environment.getDefault();
        if (env == null) {
            env = new Environment(this.workingDir);
            Environment.setDefault(env);
            env.setServerHome(this.workingDir);
            env.init();
        }
        this.workingDir.mkdirs();
        this.persistence = new ComponentPersistence(this);
        log.debug("Working directory: {}", (Object)this.workingDir);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Version getVersion() {
        return VERSION;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public Bundle getBundle(String symbolicName) {
        return this.bundles.get(symbolicName);
    }

    public Map<String, Bundle> getBundlesMap() {
        return this.bundles;
    }

    public ComponentPersistence getComponentPersistence() {
        return this.persistence;
    }

    public synchronized RuntimeContext createContext(Bundle bundle) {
        RuntimeContext ctx = this.contexts.get(bundle.getSymbolicName());
        if (ctx == null) {
            ctx = new OSGiRuntimeContext(bundle);
            this.contexts.put(bundle.getSymbolicName(), ctx);
            this.loadComponents(bundle, ctx, true);
        }
        return ctx;
    }

    public synchronized void destroyContext(Bundle bundle) {
        RuntimeContext ctx = this.contexts.remove(bundle.getSymbolicName());
        if (ctx != null) {
            ctx.destroy();
        }
    }

    public synchronized RuntimeContext getContext(Bundle bundle) {
        return this.contexts.get(bundle.getSymbolicName());
    }

    public synchronized RuntimeContext getContext(String symbolicName) {
        return this.contexts.get(symbolicName);
    }

    @Override
    protected void doStart() {
        this.bundleContext.addFrameworkListener(this);
        this.loadComponents(this.bundleContext.getBundle(), this.context, false);
    }

    @Override
    protected void doStop() {
        this.bundleContext.removeFrameworkListener(this);
        super.doStop();
    }

    protected void loadComponents(Bundle bundle, RuntimeContext ctx, boolean isFragment) {
        String name = bundle.getSymbolicName();
        if (isFragment && name.equals(this.context.getBundle().getSymbolicName())) {
            return;
        }
        String list = OSGiRuntimeService.getComponentsList(bundle);
        if (list == null) {
            log.debug("Bundle {} doesn't have components", (Object)name);
            return;
        }
        log.trace("Load Bundle: {} / Components: {}", (Object)name, (Object)list);
        StringTokenizer tok = new StringTokenizer(list, ", \t\n\r\f");
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            URL url = bundle.getEntry(path);
            if (url != null) {
                log.trace("Load component {} [{}]", (Object)name, (Object)url);
                try {
                    ctx.deploy(url);
                }
                catch (IOException e) {
                    log.error(e, (Throwable)e);
                    this.messageHandler.addMessage(new RuntimeMessage(RuntimeMessage.Level.ERROR, e.getMessage(), RuntimeMessage.Source.BUNDLE, name));
                }
                continue;
            }
            String message = "Unknown component '" + path + "' referenced by bundle '" + name + "'";
            log.error(message + ". Check the MANIFEST.MF");
            this.messageHandler.addMessage(new RuntimeMessage(RuntimeMessage.Level.ERROR, message, RuntimeMessage.Source.BUNDLE, name));
        }
    }

    public static String getComponentsList(Bundle bundle) {
        return (String)bundle.getHeaders().get("Nuxeo-Component");
    }

    protected boolean loadConfigurationFromProvider() throws IOException {
        Iterable<URL> provider = Environment.getDefault().getConfigurationProvider();
        if (provider == null) {
            return false;
        }
        Iterator<URL> it = provider.iterator();
        ArrayList<URL> props = new ArrayList<URL>();
        ArrayList<URL> xmls = new ArrayList<URL>();
        while (it.hasNext()) {
            URL url = it.next();
            String path = url.getPath();
            if (path.endsWith("-config.xml")) {
                xmls.add(url);
                continue;
            }
            if (!path.endsWith(".properties")) continue;
            props.add(url);
        }
        xmls.sort(Comparator.comparing(URL::getPath));
        for (URL url : props) {
            this.loadProperties(url);
        }
        for (URL url : xmls) {
            this.context.deploy(url);
        }
        return true;
    }

    @Override
    protected void loadConfig() throws IOException {
        Environment env = Environment.getDefault();
        if (env == null) {
            log.warn("Configuration: no host application");
            return;
        }
        log.debug("Configuration: host application: {}", (Object)env.getHostApplicationName());
        File blacklistFile = new File(env.getConfig(), "blacklist");
        if (blacklistFile.isFile()) {
            Set<String> lines = org.apache.commons.io.FileUtils.readLines(blacklistFile, StandardCharsets.UTF_8).stream().map(String::trim).filter(line -> !line.isEmpty()).collect(Collectors.toSet());
            this.manager.setBlacklist(lines);
        }
        if (this.loadConfigurationFromProvider()) {
            return;
        }
        String configDir = this.bundleContext.getProperty(PROP_CONFIG_DIR);
        if (configDir != null && configDir.contains(":/")) {
            URL url = new URL(configDir);
            log.debug("Configuration: loading properties from: {}", (Object)configDir);
            this.loadProperties(url);
            return;
        }
        boolean isNotJBoss4 = !OSGiRuntimeService.isJBoss4(env);
        File dir = env.getConfig();
        String[] names = dir.list();
        if (names != null) {
            Arrays.sort(names, String::compareToIgnoreCase);
            log.debug("Deployment order of configuration files: {}", () -> Stream.of(names).reduce((n1, n2) -> n1 + "\n\t" + n2).map(n -> "\n\t" + n).orElse(""));
            for (String name : names) {
                File file;
                if (name.endsWith("-config.xml") || name.endsWith("-bundle.xml")) {
                    if (!isNotJBoss4) continue;
                    file = new File(dir, name);
                    log.trace("Configuration: deploy config component: {}", (Object)name);
                    try {
                        this.context.deploy(file.toURI().toURL());
                    }
                    catch (IOException e) {
                        String message = String.format("Error deploying config %s (%s)", name, e.getMessage());
                        log.error(message, (Throwable)e);
                        this.messageHandler.addMessage(new RuntimeMessage(RuntimeMessage.Level.ERROR, message, RuntimeMessage.Source.CONFIG, name));
                    }
                    continue;
                }
                if (name.endsWith(".config") || name.endsWith(".ini") || name.endsWith(".properties")) {
                    file = new File(dir, name);
                    log.trace("Configuration: loading properties: {}", (Object)name);
                    this.loadProperties(file);
                    continue;
                }
                log.trace("Configuration: ignoring: {}", (Object)name);
            }
        } else if (dir.isFile()) {
            log.debug("Configuration: loading properties: {}", (Object)dir);
            this.loadProperties(dir);
        } else {
            log.debug("Configuration: no configuration file found");
        }
        this.loadDefaultConfig();
    }

    @Override
    public void reloadProperties() throws IOException {
        File dir = Environment.getDefault().getConfig();
        String[] names = dir.list();
        if (names != null) {
            Arrays.sort(names, String::compareToIgnoreCase);
            CryptoProperties props = new CryptoProperties(System.getProperties());
            for (String name : names) {
                if (!name.endsWith(".config") && !name.endsWith(".ini") && !name.endsWith(".properties")) continue;
                try (FileInputStream in = new FileInputStream(new File(dir, name));){
                    props.load(in);
                }
            }
            this.properties = props;
        }
    }

    protected void loadDefaultConfig() {
        String varName = "org.nuxeo.ecm.contextPath";
        if (Framework.getProperty(varName) == null) {
            this.properties.setProperty(varName, "/nuxeo");
        }
    }

    public void loadProperties(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            this.loadProperties(in);
        }
    }

    public void loadProperties(URL url) throws IOException {
        try (InputStream in = url.openStream();){
            this.loadProperties(in);
        }
    }

    public void loadProperties(InputStream in) throws IOException {
        this.properties.load(in);
    }

    @Override
    public String getProperty(String name, String defValue) {
        String value = this.properties.getProperty(name);
        if (value == null && (value = this.bundleContext.getProperty(name)) == null) {
            return defValue == null ? null : this.expandVars(defValue);
        }
        if (("${" + name + "}").equals(value)) {
            return value;
        }
        return this.expandVars(value);
    }

    @Override
    public String expandVars(String expression) {
        return new TextTemplate(this.getProperties()){

            @Override
            public String getVariable(String name) {
                String value = super.getVariable(name);
                if (value == null) {
                    value = OSGiRuntimeService.this.bundleContext.getProperty(name);
                }
                return value;
            }
        }.processText(expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startComponents() {
        OSGiRuntimeService oSGiRuntimeService = this;
        synchronized (oSGiRuntimeService) {
            if (this.appStarted) {
                return;
            }
            this.appStarted = true;
        }
        try {
            this.persistence.loadPersistedComponents();
        }
        catch (IOException | RuntimeException e) {
            log.error("Failed to load persisted components", (Throwable)e);
        }
        this.deployFrameworkStartedComponent();
        this.manager.start();
        this.manager.snapshot();
        this.printStatusMessage();
    }

    @Override
    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() != 1) {
            return;
        }
        this.startComponents();
    }

    private void printStatusMessage() {
        StringBuilder msg = new StringBuilder();
        msg.append("Nuxeo Platform Started\n");
        if (this.getStatusMessage(msg)) {
            log.info(msg);
        } else {
            log.error(msg);
            if (Boolean.getBoolean("nuxeo.start.strict")) {
                throw new IllegalStateException("Startup aborted due to previous failures (strict mode)");
            }
        }
    }

    protected void deployFrameworkStartedComponent() {
        RegistrationInfoImpl ri = new RegistrationInfoImpl(FRAMEWORK_STARTED_COMP);
        ri.setContext(this.context);
        this.manager.register(ri);
    }

    public Bundle findHostBundle(Bundle bundle) {
        String hostId = (String)bundle.getHeaders().get("Fragment-Host");
        log.debug("Looking for host bundle: {} host id: {}", (Object)bundle.getSymbolicName(), (Object)hostId);
        if (hostId != null) {
            RuntimeContext ctx;
            int p = hostId.indexOf(59);
            if (p > -1) {
                hostId = hostId.substring(0, p);
            }
            if ((ctx = this.contexts.get(hostId)) != null) {
                log.debug("Context was found for host id: {}", (Object)hostId);
                return ctx.getBundle();
            }
            log.warn("No context found for host id: {}", (Object)hostId);
        }
        return null;
    }

    @Override
    public File getBundleFile(Bundle bundle) {
        File file;
        String location = bundle.getLocation();
        String name = bundle.getSymbolicName();
        if (location.startsWith("file:")) {
            try {
                file = FileUtils.urlToFile(location);
            }
            catch (MalformedURLException e) {
                log.error("getBundleFile: Unable to create file for bundle name: {} as URI: {}", (Object)name, (Object)location);
                return null;
            }
        } else {
            file = new File(location);
        }
        if (file.exists()) {
            log.debug("getBundleFile: {} bound to file: {}", (Object)name, (Object)file);
            return file;
        }
        log.debug("getBundleFile: {} cannot bind to nonexistent file: {}", (Object)name, (Object)file);
        return null;
    }

    public static boolean isJBoss4(Environment env) {
        if (env == null) {
            return false;
        }
        String hn = env.getHostApplicationName();
        String hv = env.getHostApplicationVersion();
        if (hn == null || hv == null) {
            return false;
        }
        return "JBoss".equals(hn) && hv.startsWith("4");
    }
}

