/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.util.SimpleRuntime;

public abstract class NXRuntimeApplication {
    protected RuntimeService runtime;
    private static final Log log = LogFactory.getLog(NXRuntimeApplication.class);
    protected final File home;

    protected NXRuntimeApplication(File home) {
        this.home = home;
    }

    protected NXRuntimeApplication() {
        this(null);
    }

    public void start() throws InterruptedException {
        this.start(new String[0]);
    }

    public void start(String[] args) throws InterruptedException {
        this.initialize(args);
        this.run();
        this.shutdown();
    }

    public void initialize(String[] args) {
        this.runtime = new SimpleRuntime(this.home);
        Framework.initialize(this.runtime);
        this.deployAll();
    }

    public void shutdown() throws InterruptedException {
        Framework.shutdown();
    }

    public void deploy(String bundle) {
        URL url = this.getResource(bundle);
        if (url == null) {
            log.error("Cannot locate resource for deploying bundle " + bundle);
            return;
        }
        try {
            Framework.getRuntime().getContext().deploy(url);
        }
        catch (IOException e) {
            throw new RuntimeServiceException("Cannot deploy: " + url, e);
        }
    }

    public void undeploy(String bundle) {
        URL url = this.getResource(bundle);
        assert (url != null);
        try {
            Framework.getRuntime().getContext().undeploy(url);
        }
        catch (IOException e) {
            log.error(e, e);
        }
    }

    public URL getResource(String resource) {
        return this.runtime.getContext().getResource(resource);
    }

    protected void deployAll() {
        this.deploy("EventService.xml");
    }

    protected abstract void run();
}

