/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.PrintWriter;
import org.sat4j.AbstractLauncher;
import org.sat4j.ExitCode;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.TimeoutException;

public abstract class AbstractOptimizationLauncher
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;
    private static final String CURRENT_OPTIMUM_VALUE_PREFIX = "o ";
    private boolean incomplete = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.AbstractOptimizationLauncher");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected void setIncomplete(boolean value) {
        this.incomplete = value;
    }

    protected void displayResult() {
        this.displayAnswer();
        this.log("Total wall clock time (in seconds): " + (double)(System.currentTimeMillis() - this.getBeginTime()) / 1000.0);
    }

    protected void displayAnswer() {
        if (this.solver == null) {
            return;
        }
        System.out.flush();
        PrintWriter out = this.getLogWriter();
        out.flush();
        this.solver.printStat(out, "c ");
        this.solver.printInfos(out, "c ");
        ExitCode exitCode = this.getExitCode();
        out.println("s " + exitCode);
        if (exitCode == ExitCode.SATISFIABLE || exitCode == ExitCode.OPTIMUM_FOUND || this.incomplete && exitCode == ExitCode.UPPER_BOUND) {
            out.print("v ");
            this.getReader().decode(this.solver.model(), out);
            out.println();
            IOptimizationProblem optproblem = (IOptimizationProblem)((Object)this.solver);
            if (!optproblem.hasNoObjectiveFunction()) {
                this.log("objective function=" + optproblem.getObjectiveValue());
            }
        }
    }

    protected void solve(IProblem problem) throws TimeoutException {
        boolean isSatisfiable = false;
        IOptimizationProblem optproblem = (IOptimizationProblem)problem;
        try {
            while (optproblem.admitABetterSolution()) {
                if (!isSatisfiable) {
                    if (optproblem.nonOptimalMeansSatisfiable()) {
                        this.setExitCode(ExitCode.SATISFIABLE);
                        if (optproblem.hasNoObjectiveFunction()) {
                            return;
                        }
                        this.log("SATISFIABLE");
                    } else if (this.incomplete) {
                        this.setExitCode(ExitCode.UPPER_BOUND);
                    }
                    isSatisfiable = true;
                    this.log("OPTIMIZING...");
                }
                this.log("Got one! Elapsed wall clock time (in seconds):" + (double)(System.currentTimeMillis() - this.getBeginTime()) / 1000.0);
                this.getLogWriter().println(CURRENT_OPTIMUM_VALUE_PREFIX + optproblem.getObjectiveValue());
                optproblem.discardCurrentSolution();
            }
            if (isSatisfiable) {
                this.setExitCode(ExitCode.OPTIMUM_FOUND);
            } else {
                this.setExitCode(ExitCode.UNSATISFIABLE);
            }
        }
        catch (ContradictionException contradictionException) {
            if (!$assertionsDisabled && !isSatisfiable) {
                throw new AssertionError();
            }
            this.setExitCode(ExitCode.OPTIMUM_FOUND);
        }
    }
}

