/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Clauses;
import org.sat4j.minisat.core.Constr;
import org.sat4j.pb.constraints.AbstractPBDataStructureFactory;
import org.sat4j.pb.constraints.ICardConstructor;
import org.sat4j.pb.constraints.IClauseConstructor;
import org.sat4j.pb.constraints.IPBConstructor;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public abstract class AbstractPBClauseCardConstrDataStructure
extends AbstractPBDataStructureFactory {
    private static final long serialVersionUID = 1L;
    static final BigInteger MAX_INT_VALUE;
    private final IPBConstructor ipbc;
    private final ICardConstructor icardc;
    private final IClauseConstructor iclausec;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.constraints.AbstractPBClauseCardConstrDataStructure");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        MAX_INT_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    }

    AbstractPBClauseCardConstrDataStructure(IClauseConstructor iclausec, ICardConstructor icardc, IPBConstructor ipbc) {
        this.iclausec = iclausec;
        this.icardc = icardc;
        this.ipbc = ipbc;
    }

    public Constr createClause(IVecInt literals) throws ContradictionException {
        IVecInt v = Clauses.sanityCheck(literals, this.getVocabulary(), this.solver);
        return this.constructClause(v);
    }

    public Constr createUnregisteredClause(IVecInt literals) {
        return this.constructLearntClause(literals);
    }

    protected Constr constraintFactory(int[] literals, BigInteger[] coefs, BigInteger degree) throws ContradictionException {
        if (literals.length == 0 && degree.signum() <= 0) {
            return null;
        }
        if (degree.equals(BigInteger.ONE)) {
            IVecInt v = Clauses.sanityCheck(new VecInt(literals), this.getVocabulary(), this.solver);
            if (v == null) {
                return null;
            }
            return this.constructClause(v);
        }
        if (AbstractPBClauseCardConstrDataStructure.coefficientsEqualToOne(coefs)) {
            if (!$assertionsDisabled && degree.compareTo(MAX_INT_VALUE) >= 0) {
                throw new AssertionError();
            }
            return this.constructCard(new VecInt(literals), degree.intValue());
        }
        return this.constructPB(literals, coefs, degree);
    }

    protected Constr learntConstraintFactory(IDataStructurePB dspb) {
        if (dspb.getDegree().equals(BigInteger.ONE)) {
            VecInt literals = new VecInt();
            Vec<BigInteger> resCoefs = new Vec<BigInteger>();
            dspb.buildConstraintFromConflict(literals, resCoefs);
            int indLit = dspb.getAssertiveLiteral();
            if (indLit > -1) {
                int tmp = literals.get(indLit);
                literals.set(indLit, literals.get(0));
                literals.set(0, tmp);
            }
            return this.constructLearntClause(literals);
        }
        if (dspb.isCardinality()) {
            return this.constructLearntCard(dspb);
        }
        return this.constructLearntPB(dspb);
    }

    static boolean coefficientsEqualToOne(BigInteger[] coefs) {
        int i = 0;
        while (i < coefs.length) {
            if (!coefs[i].equals(BigInteger.ONE)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Constr constructClause(IVecInt v) {
        return this.iclausec.constructClause(this.solver, this.getVocabulary(), v);
    }

    protected Constr constructCard(IVecInt theLits, int degree) throws ContradictionException {
        return this.icardc.constructCard(this.solver, this.getVocabulary(), theLits, degree);
    }

    protected Constr constructPB(int[] theLits, BigInteger[] coefs, BigInteger degree) throws ContradictionException {
        return this.ipbc.constructPB(this.solver, this.getVocabulary(), theLits, coefs, degree);
    }

    protected Constr constructLearntClause(IVecInt literals) {
        return this.iclausec.constructLearntClause(this.getVocabulary(), literals);
    }

    protected Constr constructLearntCard(IDataStructurePB dspb) {
        return this.icardc.constructLearntCard(this.getVocabulary(), dspb);
    }

    protected Constr constructLearntPB(IDataStructurePB dspb) {
        return this.ipbc.constructLearntPB(this.getVocabulary(), dspb);
    }
}

