/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.Path;
import org.nuxeo.common.xmap.Sorter;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.w3c.dom.Element;

public class XAnnotatedObject {
    final XMap xmap;
    final Class<?> klass;
    final Constructor<?> constructor;
    final Path path;
    final List<XAnnotatedMember> members;
    Sorter sorter;
    protected boolean hasRegistry;
    protected XAnnotatedMember registryId;
    protected XAnnotatedMember merge;
    protected XAnnotatedMember remove;
    protected XAnnotatedMember enable;

    public XAnnotatedObject(XMap xmap, Class<?> klass, XObject xob) {
        try {
            this.xmap = xmap;
            this.klass = klass;
            this.constructor = this.klass.getDeclaredConstructor(new Class[0]);
            this.constructor.setAccessible(true);
            this.path = new Path(xob.value());
            this.members = new ArrayList<XAnnotatedMember>();
            String[] order = xob.order();
            if (order.length > 0) {
                this.sorter = new Sorter(order);
            }
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Invalid xmap class - no default constructor found", e);
        }
    }

    public void addMember(XAnnotatedMember member) {
        this.members.add(member);
    }

    public Path getPath() {
        return this.path;
    }

    public Class<?> getKlass() {
        return this.klass;
    }

    public Object newInstance(Context ctx, Element element) {
        return this.newInstance(ctx, element, null);
    }

    public Object newInstance(Context ctx, Element element, Object existing) {
        if (existing == null) {
            Object ob;
            try {
                ob = this.constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException(e);
            }
            ctx.push(ob);
        } else {
            ctx.push(existing);
        }
        if (this.sorter != null) {
            Collections.sort(this.members, this.sorter);
            this.sorter = null;
        }
        for (XAnnotatedMember member : this.members) {
            member.process(ctx, element, existing);
        }
        return ctx.pop();
    }

    public boolean hasRegistry() {
        return this.hasRegistry;
    }

    public void setHasRegistry(boolean hasRegistry) {
        this.hasRegistry = hasRegistry;
    }

    public XAnnotatedMember getRegistryId() {
        return this.registryId;
    }

    public void setRegistryId(XAnnotatedMember registryId) {
        this.registryId = registryId;
    }

    public XAnnotatedMember getMerge() {
        return this.merge;
    }

    public void setMerge(XAnnotatedMember merge) {
        this.merge = merge;
    }

    public XAnnotatedMember getRemove() {
        return this.remove;
    }

    public void setRemove(XAnnotatedMember remove) {
        this.remove = remove;
    }

    public XAnnotatedMember getEnable() {
        return this.enable;
    }

    public void setEnable(XAnnotatedMember enable) {
        this.enable = enable;
    }
}

