/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap.registry;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.Registry;
import org.nuxeo.common.xmap.registry.RegistryContribution;
import org.w3c.dom.Element;

public abstract class AbstractRegistry
implements Registry {
    protected volatile boolean initialized;
    protected Set<String> tags = ConcurrentHashMap.newKeySet();
    protected List<RegistryContribution> registrations = new CopyOnWriteArrayList<RegistryContribution>();

    @Override
    public boolean isNull() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isInitialized() {
        AbstractRegistry abstractRegistry = this;
        synchronized (abstractRegistry) {
            return this.initialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInitialized(boolean initialized) {
        AbstractRegistry abstractRegistry = this;
        synchronized (abstractRegistry) {
            this.initialized = initialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkInitialized() {
        if (!this.initialized) {
            AbstractRegistry abstractRegistry = this;
            synchronized (abstractRegistry) {
                if (!this.initialized) {
                    this.initialize();
                    this.initialized = true;
                }
            }
        }
    }

    @Override
    public void initialize() {
        this.registrations.forEach(this::register);
        this.setInitialized(true);
    }

    @Override
    public void tag(String id) {
        this.tags.add(id);
    }

    @Override
    public boolean isTagged(String id) {
        return this.tags.contains(id);
    }

    @Override
    public void register(Context ctx, XAnnotatedObject xObject, Element element, String tag) {
        this.tag(tag);
        this.registrations.add(new RegistryContribution(ctx, xObject, element, tag));
        this.setInitialized(false);
    }

    @Override
    public void unregister(String tag) {
        if (tag == null || !this.isTagged(tag)) {
            return;
        }
        this.tags.remove(tag);
        this.registrations.removeIf(reg -> tag.equals(reg.getTag()));
        this.setInitialized(false);
    }

    protected void register(RegistryContribution rc) {
        this.register(rc.getContext(), rc.getObject(), rc.getElement());
    }

    protected abstract void register(Context var1, XAnnotatedObject var2, Element var3);
}

