/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap.registry;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.AbstractRegistry;
import org.nuxeo.common.xmap.registry.Registry;
import org.w3c.dom.Element;

public class MapRegistry
extends AbstractRegistry
implements Registry {
    protected Map<String, Object> contributions = Collections.synchronizedMap(new LinkedHashMap());
    protected Set<String> disabled = ConcurrentHashMap.newKeySet();

    @Override
    public void initialize() {
        this.contributions.clear();
        this.disabled.clear();
        super.initialize();
    }

    public <T> Map<String, T> getContributions() {
        this.checkInitialized();
        return this.contributions.entrySet().stream().filter(x -> !this.disabled.contains(x.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2, LinkedHashMap::new));
    }

    public <T> List<T> getContributionValues() {
        this.checkInitialized();
        return this.contributions.entrySet().stream().filter(x -> !this.disabled.contains(x.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public <T> Optional<T> getContribution(String id) {
        this.checkInitialized();
        if (this.disabled.contains(id)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.contributions.get(id));
    }

    @Override
    protected void register(Context ctx, XAnnotatedObject xObject, Element element) {
        XAnnotatedMember remove;
        String id = (String)xObject.getRegistryId().getValue(ctx, element);
        if (id == null) {
            id = "null";
        }
        if ((remove = xObject.getRemove()) != null && Boolean.TRUE.equals(remove.getValue(ctx, element))) {
            this.contributions.remove(id);
            return;
        }
        XAnnotatedMember merge = xObject.getMerge();
        Object contrib = merge != null && Boolean.TRUE.equals(merge.getValue(ctx, element)) ? xObject.newInstance(ctx, element, this.contributions.get(id)) : xObject.newInstance(ctx, element);
        this.contributions.put(id, contrib);
        XAnnotatedMember enable = xObject.getEnable();
        if (enable != null) {
            Object enabled = enable.getValue(ctx, element);
            if (enabled != null && Boolean.FALSE.equals(enabled)) {
                this.disabled.add(id);
            } else {
                this.disabled.remove(id);
            }
        }
    }
}

