/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.capabilities;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.capabilities.Capabilities;
import org.nuxeo.runtime.capabilities.CapabilitiesService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.DefaultComponent;

public class CapabilitiesServiceImpl
extends DefaultComponent
implements CapabilitiesService {
    public static final String CAPABILITY_SERVER = "server";
    protected final Map<String, Supplier<Map<String, Object>>> capabilitiesSuppliers = new HashMap<String, Supplier<Map<String, Object>>>();

    @Override
    public void activate(ComponentContext context) {
        super.activate(context);
        new ComponentManager.Listener(){

            @Override
            public void beforeStart(ComponentManager mgr, boolean isResume) {
                CapabilitiesServiceImpl.this.capabilitiesSuppliers.clear();
            }
        }.install();
    }

    @Override
    public int getApplicationStartedOrder() {
        return -2000;
    }

    @Override
    public void start(ComponentContext context) {
        this.registerCapabilities(CAPABILITY_SERVER, this::getServerCapabilities);
    }

    protected Map<String, Object> getServerCapabilities() {
        LinkedHashMap<String, Object> serverCapabilities = new LinkedHashMap<String, Object>();
        serverCapabilities.put("distributionName", Framework.getProperty("org.nuxeo.distribution.name"));
        serverCapabilities.put("distributionVersion", Framework.getProperty("org.nuxeo.distribution.version"));
        serverCapabilities.put("distributionServer", Framework.getProperty("org.nuxeo.distribution.server"));
        String hotfixVersion = Framework.getProperty("org.nuxeo.distribution.hotfix");
        if (StringUtils.isNotBlank(hotfixVersion)) {
            serverCapabilities.put("hotfixVersion", hotfixVersion);
        }
        return serverCapabilities;
    }

    @Override
    public void registerCapabilities(String name, Map<String, Object> map) {
        this.registerCapabilities(name, () -> map);
    }

    @Override
    public void registerCapabilities(String name, Supplier<Map<String, Object>> supplier) {
        this.capabilitiesSuppliers.put(name, supplier);
    }

    @Override
    public Capabilities getCapabilities() {
        return this.capabilitiesSuppliers.entrySet().stream().collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, e -> (Map)((Supplier)e.getValue()).get()), Capabilities::new));
    }
}

