/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.DOMHelper;
import org.nuxeo.common.xmap.Path;
import org.nuxeo.common.xmap.XAccessor;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.XMLBuilder;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.XValueFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XAnnotatedMember {
    protected final XAccessor accessor;
    protected Path path;
    protected Path fallbackPath;
    protected String defaultValue;
    protected boolean trim = true;
    protected Class<?> type;
    protected XAnnotatedObject xao;
    protected XValueFactory valueFactory;

    protected XAnnotatedMember(XMap xmap, XAccessor accessor) {
        this.accessor = accessor;
    }

    public XAnnotatedMember(XMap xmap, XAccessor accessor, String path, String fallbackPath, String defaultValue, boolean trim) {
        this(xmap, accessor);
        this.path = new Path(path);
        if (fallbackPath != null && !"__NO_FALLBACK_MARKER__".equals(fallbackPath)) {
            this.fallbackPath = new Path(fallbackPath);
        }
        this.type = accessor.getType();
        this.valueFactory = xmap.getValueFactory(this.type);
        if (this.valueFactory == null && this.type.isEnum()) {
            this.valueFactory = new XValueFactory(){

                @Override
                public String serialize(Context arg0, Object arg1) {
                    return ((Enum)arg1).name();
                }

                @Override
                public Object deserialize(Context arg0, String arg1) {
                    Class<?> enumType = XAnnotatedMember.this.type;
                    return Enum.valueOf(enumType, arg1);
                }
            };
            xmap.setValueFactory(this.type, this.valueFactory);
        }
        this.xao = xmap.register(this.type);
        if (!"__NO_DEFAULT_ASSIGNMENT_MARKER__".equals(defaultValue)) {
            this.defaultValue = defaultValue;
        }
        this.trim = trim;
    }

    public XAnnotatedMember(XMap xmap, XAccessor setter, XNode anno) {
        this(xmap, setter, anno.value(), anno.fallback(), anno.defaultAssignment(), anno.trim());
    }

    protected void setValue(Object instance, Object value) {
        try {
            this.accessor.setValue(instance, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("%s, setter=%s, value=%s", e.getMessage(), this.accessor, value), e);
        }
    }

    public void toXML(Object instance, Element parent) {
        Element e = XMLBuilder.getOrCreateElement(parent, this.path);
        Object v = this.accessor.getValue(instance);
        if (this.xao == null) {
            String value;
            if (v != null && this.valueFactory != null && (value = this.valueFactory.serialize(null, v)) != null) {
                XMLBuilder.fillField(e, value, this.path.attribute);
            }
        } else {
            XMLBuilder.toXML(v, e, this.xao);
        }
    }

    public void process(Context ctx, Element element) {
        this.process(ctx, element, null);
    }

    public void process(Context ctx, Element element, Object existing) {
        Object value;
        if ((existing == null || this.hasValue(ctx, element)) && (value = existing == null ? this.getValue(ctx, element) : this.getValue(ctx, element, this.accessor.getValue(existing))) != null) {
            this.setValue(ctx.getObject(), value);
        }
    }

    public boolean hasValue(Context ctx, Element element) {
        return DOMHelper.hasNode(element, this.path) || this.fallbackPath != null && DOMHelper.hasNode(element, this.fallbackPath);
    }

    protected Element getElement(Element base) {
        Element el = (Element)DOMHelper.getElementNode((Node)base, this.path);
        if (el == null && this.fallbackPath != null) {
            el = (Element)DOMHelper.getElementNode((Node)base, this.fallbackPath);
        }
        return el;
    }

    public Object getValue(Context ctx, Element base) {
        return this.getValue(ctx, base, null);
    }

    public Object getValue(Context ctx, Element base, Object existing) {
        if (this.xao != null) {
            Element el = this.getElement(base);
            if (el == null) {
                return null;
            }
            return this.xao.newInstance(ctx, el, existing);
        }
        if (this.type == Element.class) {
            return this.getElement(base);
        }
        String val = DOMHelper.getNodeValue(base, this.path);
        if (val == null && this.fallbackPath != null) {
            val = DOMHelper.getNodeValue(base, this.fallbackPath);
        }
        if (val != null) {
            if (this.trim) {
                val = val.trim();
            }
            if (this.valueFactory == null) {
                throw new NullPointerException("Missing XValueFactory for " + this.type);
            }
            return this.valueFactory.deserialize(ctx, val);
        }
        return this.getDefaultValue(ctx);
    }

    protected Object getDefaultValue(Context ctx) {
        if (this.defaultValue != null && this.valueFactory != null) {
            return this.valueFactory.deserialize(ctx, this.defaultValue);
        }
        return this.defaultValue;
    }
}

