/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap.registry;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.Registry;
import org.nuxeo.common.xmap.registry.RegistryContribution;
import org.w3c.dom.Element;

public abstract class AbstractRegistry
implements Registry {
    protected volatile boolean initialized;
    protected Set<String> tags = ConcurrentHashMap.newKeySet();
    protected List<RegistryContribution> registrations = new CopyOnWriteArrayList<RegistryContribution>();

    protected AbstractRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isInitialized() {
        AbstractRegistry abstractRegistry = this;
        synchronized (abstractRegistry) {
            return this.initialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInitialized(boolean initialized) {
        AbstractRegistry abstractRegistry = this;
        synchronized (abstractRegistry) {
            this.initialized = initialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkInitialized() {
        if (!this.initialized) {
            AbstractRegistry abstractRegistry = this;
            synchronized (abstractRegistry) {
                if (!this.initialized) {
                    this.initialize();
                    this.initialized = true;
                }
            }
        }
    }

    @Override
    public void initialize() {
        this.registrations.forEach(rc -> this.doRegister(rc.getContext(), rc.getObject(), rc.getElement(), rc.getRuntimeExtensionFromTag()));
        this.setInitialized(true);
    }

    @Override
    public void tag(String id) {
        this.tags.add(id);
    }

    @Override
    public boolean isTagged(String id) {
        return this.tags.contains(id);
    }

    @Override
    public void register(Context ctx, XAnnotatedObject xObject, Element element, String tag) {
        this.tag(tag);
        this.registrations.add(new RegistryContribution(ctx, xObject, element, tag));
        this.setInitialized(false);
    }

    @Override
    public void unregister(String tag) {
        if (tag == null || !this.isTagged(tag)) {
            return;
        }
        this.tags.remove(tag);
        this.registrations.removeIf(reg -> tag.equals(reg.getTag()));
        this.setInitialized(false);
    }

    protected abstract <T> T doRegister(Context var1, XAnnotatedObject var2, Element var3, String var4);

    protected boolean shouldRemove(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        XAnnotatedMember remove = xObject.getRemove();
        return remove != null && Boolean.TRUE.equals(remove.getValue(ctx, element));
    }

    protected Boolean shouldEnable(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        XAnnotatedMember enable = xObject.getEnable();
        if (enable != null && enable.hasValue(ctx, element)) {
            Object enabled = enable.getValue(ctx, element);
            return enabled == null || Boolean.TRUE.equals(enabled);
        }
        return null;
    }

    protected boolean onlyHandlesEnablement(Context ctx, XAnnotatedObject xObject, Element element, boolean hasId) {
        int maxNbAttr;
        if (element.getChildNodes().getLength() > 0) {
            return false;
        }
        int nbAttr = element.getAttributes().getLength();
        int n = maxNbAttr = hasId ? 2 : 1;
        if (nbAttr > maxNbAttr) {
            return false;
        }
        XAnnotatedMember enable = xObject.getEnable();
        return enable != null && enable.hasValue(ctx, element);
    }

    protected boolean shouldMerge(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        XAnnotatedMember merge = xObject.getMerge();
        return merge != null && Boolean.TRUE.equals(merge.getValue(ctx, element));
    }

    protected <T> T getMergedInstance(Context ctx, XAnnotatedObject xObject, Element element, Object existing) {
        return (T)xObject.newInstance(ctx, element, existing);
    }

    protected <T> T getInstance(Context ctx, XAnnotatedObject xObject, Element element) {
        return (T)xObject.newInstance(ctx, element);
    }
}

