/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.fake;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.nuxeo.connect.connector.AbstractConnectConnector;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.connector.ConnectServerResponse;
import org.nuxeo.connect.connector.fake.ConnectFakeResponse;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.dependencies.TargetPlatformFilterHelper;
import org.nuxeo.connect.platform.PlatformId;

public abstract class AbstractFakeConnector
extends AbstractConnectConnector {
    protected abstract String getJSONDataForStatus();

    protected abstract String getJSONDataForDownloads(String var1);

    protected abstract String getJSONDataForDownload(String var1);

    @Override
    protected ConnectServerResponse execServerCall(String url, Map<String, String> headers) throws ConnectServerError {
        String data = null;
        if (url.endsWith("/status")) {
            data = this.getJSONDataForStatus();
        } else if (url.contains("/getDownloads/")) {
            String type = StringUtils.substringBetween(url, "getDownloads/", "?");
            if (type == null) {
                type = StringUtils.substringAfterLast(url, "/");
            }
            data = this.getJSONDataForDownloads(type);
        } else if (url.contains("/getDownload/")) {
            String pkgId = url.split("getDownload\\/")[1];
            data = this.getJSONDataForDownload(pkgId);
        }
        return new ConnectFakeResponse(data);
    }

    @Override
    protected ConnectServerResponse execServerPost(String url, Map<String, String> headers) throws ConnectServerError {
        throw new UnsupportedOperationException();
    }

    @Override
    protected List<DownloadablePackage> getDownloads(String fileSuffix, String urlSuffix) throws ConnectServerError {
        List<DownloadablePackage> downloads = super.getDownloads(fileSuffix, urlSuffix);
        if (StringUtils.contains((CharSequence)urlSuffix, "?")) {
            Map<String, String> queryParams = URLEncodedUtils.parse(StringUtils.substringAfter(urlSuffix, "?"), Charset.forName("UTF-8")).stream().collect(Collectors.toMap(pair -> pair.getName(), pair -> pair.getValue()));
            PlatformId targetPlatform = PlatformId.parse(queryParams.get("targetPlatform"));
            return downloads.stream().filter(pkg -> TargetPlatformFilterHelper.isCompatibleWithTargetPlatform(pkg, targetPlatform)).collect(Collectors.toList());
        }
        return downloads;
    }
}

