/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.standalone;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.task.update.UpdateManager;

public abstract class AbstractTask
implements Task {
    static final Log log = LogFactory.getLog(AbstractTask.class);
    public static final String PKG_ID = "package.id";
    public static final String PKG_NAME = "package.name";
    public static final String PKG_VERSION = "package.version";
    public static final String PKG_ROOT = "package.root";
    public static final String ENV_HOME = "env.home";
    public static final String ENV_SERVER_HOME = "env.server.home";
    public static final String ENV_EAR = "env.ear";
    public static final String ENV_LIB = "env.lib";
    public static final String ENV_SYSLIB = "env.syslib";
    public static final String ENV_BUNDLES = "env.bundles";
    public static final String ENV_CONFIG = "env.config";
    public static final String ENV_TEMPLATES = "env.templates";
    public static final String ENV_TIMESTAMP = "sys.timestamp";
    public static final String ENV_HOSTAPP_NAME = "env.hostapp.name";
    public static final String ENV_HOSTAPP_VERSION = "env.hostapp.version";
    protected boolean restart;
    protected LocalPackage pkg;
    protected String serverPathPrefix;
    protected UpdateManager updateMgr;
    protected boolean updateMgrLoaded = false;
    protected PackageUpdateService service;
    protected final Map<String, String> env;

    public AbstractTask(PackageUpdateService pus) {
        this.service = pus;
        this.env = new HashMap<String, String>();
        Environment nxenv = Environment.getDefault();
        File serverHome = nxenv.getServerHome();
        File nxHome = nxenv.getRuntimeHome();
        File config = nxenv.getConfig();
        this.serverPathPrefix = serverHome.getAbsolutePath();
        if (!this.serverPathPrefix.endsWith(File.separator)) {
            this.serverPathPrefix = this.serverPathPrefix.concat(File.separator);
        }
        this.env.put(ENV_SERVER_HOME, serverHome.getAbsolutePath());
        this.env.put(ENV_HOME, nxHome.getAbsolutePath());
        this.env.put(ENV_CONFIG, config.getAbsolutePath());
        this.env.put(ENV_HOSTAPP_NAME, nxenv.getHostApplicationName());
        this.env.put(ENV_HOSTAPP_VERSION, nxenv.getHostApplicationVersion());
        this.env.put(ENV_SYSLIB, new File(serverHome, "lib").getAbsolutePath());
        if (nxenv.isJBoss()) {
            File ear = config.getParentFile();
            this.env.put(ENV_EAR, ear.getAbsolutePath());
            this.env.put(ENV_LIB, new File(ear, "lib").getAbsolutePath());
            this.env.put(ENV_BUNDLES, new File(ear, "bundles").getAbsolutePath());
        } else {
            this.env.put(ENV_LIB, new File(nxHome, "lib").getAbsolutePath());
            this.env.put(ENV_BUNDLES, new File(nxHome, "bundles").getAbsolutePath());
        }
        this.env.put(ENV_TEMPLATES, new File(serverHome, "templates").getAbsolutePath());
        this.env.put(ENV_TIMESTAMP, new SimpleDateFormat("yyMMddHHmmss").format(new Date()));
        this.updateMgr = new UpdateManager(serverHome, this.service.getRegistry());
    }

    public abstract boolean isInstallTask();

    @Override
    public void initialize(LocalPackage pkg, boolean restart) throws PackageException {
        this.pkg = pkg;
        this.restart = restart;
        this.env.put(PKG_ID, pkg.getId());
        this.env.put(PKG_NAME, pkg.getName());
        this.env.put(PKG_VERSION, pkg.getVersion().toString());
        this.env.put(PKG_ROOT, pkg.getData().getRoot().getAbsolutePath());
        if (log.isDebugEnabled()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream outPrint = new PrintStream(out);
            MapUtils.debugPrint(outPrint, null, this.env);
            log.debug(out.toString());
        }
    }

    public File getFile(String key) {
        String val = this.env.get(key);
        return val == null ? null : new File(val);
    }

    @Override
    public boolean isRestartRequired() {
        return this.restart;
    }

    @Override
    public LocalPackage getPackage() {
        return this.pkg;
    }

    protected Map<Object, Object> createContextMap(Map<String, String> params) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(System.getProperties());
        map.putAll(this.env);
        if (params != null && !params.isEmpty()) {
            map.putAll(params);
        }
        return map;
    }

    protected String loadParametrizedFile(File file, Map<String, String> params) throws IOException {
        String content = FileUtils.readFileToString(file, StandardCharsets.UTF_8);
        return StringUtils.expandVars(content, this.createContextMap(params));
    }

    protected void saveParams(Map<String, String> params) throws PackageException {
        if (params == null || params.isEmpty()) {
            return;
        }
        try {
            Properties props = new Properties();
            props.putAll(params);
            File file = this.pkg.getData().getEntry("install.properties");
            try (FileOutputStream out = new FileOutputStream(file);){
                props.store(out, "user install parameters");
            }
        }
        catch (IOException e) {
            throw new PackageException("Failed to save install parameters", e);
        }
    }

    @Override
    public synchronized void run(Map<String, String> params) throws PackageException {
        LocalPackage oldpkg;
        if (this.isInstallTask() && (oldpkg = this.service.getActivePackage(this.pkg.getName())) != null) {
            if (oldpkg.getPackageState() == PackageState.INSTALLING) {
                throw new PackageException("Another package with the same name is installing: " + oldpkg.getName());
            }
            Task utask = oldpkg.getUninstallTask();
            try {
                utask.run(new HashMap<String, String>());
            }
            catch (PackageException e) {
                utask.rollback();
                throw new PackageException("Failed to uninstall: " + oldpkg.getId() + ". Cannot continue installation of " + this.pkg.getId(), e);
            }
        }
        this.service.setPackageState(this.pkg, PackageState.INSTALLING);
        this.saveParams(params);
        this.doRun(params);
        this.taskDone();
        if (this.updateMgrLoaded) {
            this.updateMgr.store();
        }
    }

    public synchronized UpdateManager getUpdateManager() throws PackageException {
        if (!this.updateMgrLoaded) {
            this.updateMgr.load();
            this.updateMgrLoaded = true;
        }
        return this.updateMgr;
    }

    protected abstract void rollbackDone() throws PackageException;

    protected abstract void taskDone() throws PackageException;

    @Override
    public void rollback() throws PackageException {
        try {
            this.doRollback();
        }
        finally {
            this.rollbackDone();
        }
    }

    @Override
    public void setRestartRequired(boolean isRestartRequired) {
        this.restart = isRestartRequired;
    }

    protected abstract void doRun(Map<String, String> var1) throws PackageException;

    protected abstract void doRollback() throws PackageException;

    @Override
    public ValidationStatus validate() throws PackageException {
        ValidationStatus status = new ValidationStatus();
        if (this.isInstallTask()) {
            this.validateInstall(status);
        }
        this.doValidate(status);
        return status;
    }

    public abstract void doValidate(ValidationStatus var1) throws PackageException;

    protected LocalPackage validateInstall(ValidationStatus status) throws PackageException {
        LocalPackage oldpkg = this.service.getActivePackage(this.pkg.getName());
        if (oldpkg != null) {
            if (oldpkg.getPackageState() == PackageState.INSTALLING) {
                status.addWarning("A package with the same name: " + oldpkg.getId() + " is being installing. Try again later.");
            } else {
                status.addWarning("The package " + oldpkg.getId() + " will be uninstalled!");
            }
            return oldpkg;
        }
        return null;
    }

    @Override
    public String getRelativeFilePath(File file) {
        String path = file.getAbsolutePath();
        if (path.startsWith(this.serverPathPrefix)) {
            return path.substring(this.serverPathPrefix.length());
        }
        return path;
    }
}

