/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.process;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.nuxeo.launcher.process.ProcessManager;

public class WindowsProcessManager
extends ProcessManager {
    private static final Pattern PROCESS_GET_LINE = Pattern.compile("^(.*?)\\s+(\\d+)\\s*$");

    protected WindowsProcessManager(Pattern processPattern) {
        super(processPattern);
    }

    @Override
    public Optional<Long> findPid() throws IOException {
        for (String line : WindowsProcessManager.execute("wmic", "process", "get", "CommandLine,ProcessId")) {
            Matcher lineMatcher = PROCESS_GET_LINE.matcher(line);
            if (!lineMatcher.matches()) continue;
            String commandLine = lineMatcher.group(1);
            String pid = lineMatcher.group(2);
            Matcher commandMatcher = this.processPattern.matcher(commandLine);
            if (!commandMatcher.find()) continue;
            return Optional.ofNullable(pid).map(Long::valueOf);
        }
        return super.findPid();
    }

    @Override
    public void kill(ProcessHandle processHandle) throws IOException {
        WindowsProcessManager.execute("taskkill", "/t", "/f", "/pid", String.valueOf(processHandle.pid()));
    }

    private static List<String> execute(String ... command) throws IOException {
        Process process = new ProcessBuilder(command).start();
        process.getOutputStream().close();
        List<String> lines = IOUtils.readLines(process.getInputStream(), StandardCharsets.UTF_8);
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return lines;
    }

    protected static boolean isUsable() {
        try {
            WindowsProcessManager.execute("wmic", "quit");
            WindowsProcessManager.execute("taskkill", "/?");
            return true;
        }
        catch (IOException ioException) {
            return false;
        }
    }
}

