/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.services.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.utils.DurationUtils;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.services.config.ConfigurationPropertyDescriptor;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class ConfigurationServiceImpl
extends DefaultComponent
implements ConfigurationService {
    protected static final Logger log = LogManager.getLogger(ConfigurationServiceImpl.class);
    public static final String CONFIGURATION_EP = "configuration";
    protected static final JavaPropsMapper PROPERTIES_MAPPER = new JavaPropsMapper();
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Override
    @Deprecated
    public String getProperty(String key) {
        return this.getString(key, null);
    }

    @Override
    @Deprecated
    public String getProperty(String key, String defaultValue) {
        return this.getString(key, defaultValue);
    }

    @Override
    @Deprecated
    public boolean isBooleanPropertyTrue(String key) {
        String value = this.getProperty(key);
        return Boolean.parseBoolean(value);
    }

    @Override
    @Deprecated
    public boolean isBooleanPropertyFalse(String key) {
        String value = this.getProperty(key);
        return StringUtils.isNotBlank(value) && !Boolean.parseBoolean(value);
    }

    @Override
    public Map<String, Serializable> getProperties(String namespace) {
        if (StringUtils.isEmpty(namespace)) {
            return null;
        }
        if (namespace.charAt(namespace.length() - 1) == '.') {
            throw new IllegalArgumentException("namespace cannot end with a dot");
        }
        List values = this.getRegistryContributions(CONFIGURATION_EP);
        return values.stream().filter(desc -> ConfigurationServiceImpl.startsWithNamespace(desc.getId(), namespace)).collect(Collectors.toMap(desc -> desc.getId().substring(namespace.length() + 1), desc -> desc.getValue() != null && desc.list ? desc.getValue().split(",") : desc.getValue()));
    }

    @Override
    public String getPropertiesAsJson(String namespace) throws IOException {
        Properties properties = new Properties();
        this.getProperties(namespace).forEach((key, value) -> {
            if (value instanceof String[]) {
                int idx = 1;
                for (String v : (String[])value) {
                    properties.put(String.format("%s.%d", key, idx++), v);
                }
            } else {
                properties.put(key, value);
            }
        });
        return OBJECT_MAPPER.writer().writeValueAsString(PROPERTIES_MAPPER.readPropertiesAs(properties, ObjectNode.class));
    }

    protected static boolean startsWithNamespace(String string, String namespace) {
        int nl = namespace.length();
        return string.length() > nl && string.charAt(nl) == '.' && string.startsWith(namespace);
    }

    @Override
    public Optional<String> getString(String key) {
        Optional<ConfigurationPropertyDescriptor> desc = this.getRegistryContribution(CONFIGURATION_EP, key);
        return desc.map(value -> value.getValue()).filter(StringUtils::isNotBlank);
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.getString(key).orElse(defaultValue);
    }

    @Override
    public Optional<Integer> getInteger(String key) {
        return this.getString(key).map(value -> {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                log.error("Invalid configuration property '{}', '{}' should be a number", (Object)key, value, (Object)e);
                return null;
            }
        });
    }

    @Override
    public int getInteger(String key, int defaultValue) {
        return this.getInteger(key).orElse(defaultValue);
    }

    @Override
    public Optional<Long> getLong(String key) {
        return this.getString(key).map(value -> {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                log.error("Invalid configuration property '{}', '{}' should be a number", (Object)key, value, (Object)e);
                return null;
            }
        });
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return this.getLong(key).orElse(defaultValue);
    }

    @Override
    public Optional<Boolean> getBoolean(String key) {
        return this.getString(key).map(value -> {
            if ("true".equalsIgnoreCase((String)value)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase((String)value)) {
                return Boolean.FALSE;
            }
            log.error("Invalid configuration property '{}', '{}' should be a boolean", (Object)key, value);
            return null;
        });
    }

    @Override
    public boolean isBooleanTrue(String key) {
        return this.getBoolean(key).filter(Boolean.TRUE::equals).orElse(Boolean.FALSE);
    }

    @Override
    public boolean isBooleanFalse(String key) {
        return this.getBoolean(key).filter(Boolean.FALSE::equals).map(value -> value == false).orElse(Boolean.FALSE);
    }

    @Override
    public Optional<Duration> getDuration(String key) {
        return this.getString(key).map(value -> {
            try {
                return DurationUtils.parse(value);
            }
            catch (DateTimeParseException e) {
                log.error("Invalid configuration property '{}', '{}' should be a duration", (Object)key, value, (Object)e);
                return null;
            }
        });
    }

    @Override
    public Duration getDuration(String key, Duration defaultValue) {
        return this.getDuration(key).orElse(defaultValue);
    }
}

